/*    */ package org.jboss.aspects.asynch;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.util.concurrent.ExecutionException;
/*    */ import java.util.concurrent.Future;
/*    */ import java.util.concurrent.TimeUnit;
/*    */ import org.jboss.aop.Dispatcher;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class FutureImplJavaUtilConcurrent
/*    */   implements RemotableFuture
/*    */ {
/*    */   private Future result;
/*    */   private GUID remoteObjectID;
/*    */ 
/*    */   public FutureImplJavaUtilConcurrent(Future result)
/*    */   {
/* 45 */     this.result = result;
/*    */   }
/*    */ 
/*    */   public void setRemoteObjectID(GUID remoteObjectID)
/*    */   {
/* 50 */     this.remoteObjectID = remoteObjectID;
/*    */   }
/*    */ 
/*    */   public void release()
/*    */   {
/* 55 */     if (this.remoteObjectID != null)
/*    */     {
/* 57 */       Dispatcher.singleton.unregisterTarget(this.remoteObjectID);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object get() throws InterruptedException, InvocationTargetException
/*    */   {
/*    */     try
/*    */     {
/* 65 */       Object rtn = this.result.get();
/* 66 */       release();
/* 67 */       return rtn;
/*    */     }
/*    */     catch (ExecutionException e)
/*    */     {
/* 71 */       release();
/* 72 */     }throw new InvocationTargetException(e.getCause());
/*    */   }
/*    */ 
/*    */   public Object get(long milliseconds)
/*    */     throws TimeoutException, InterruptedException, InvocationTargetException
/*    */   {
/*    */     try
/*    */     {
/* 80 */       Object rtn = this.result.get(milliseconds, TimeUnit.MILLISECONDS);
/* 81 */       release();
/* 82 */       return rtn;
/*    */     }
/*    */     catch (ExecutionException e)
/*    */     {
/* 86 */       release();
/* 87 */       throw new InvocationTargetException(e.getCause());
/*    */     }
/*    */     catch (java.util.concurrent.TimeoutException e) {
/*    */     }
/* 91 */     throw new TimeoutException(e);
/*    */   }
/*    */ 
/*    */   public boolean isDone()
/*    */   {
/* 97 */     return this.result.isDone();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.FutureImplJavaUtilConcurrent
 * JD-Core Version:    0.6.0
 */