/*    */ package org.jboss.aspects.asynch;
/*    */ 
/*    */ import EDU.oswego.cs.dl.util.concurrent.FutureResult;
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import org.jboss.aop.Dispatcher;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class FutureImpl
/*    */   implements RemotableFuture
/*    */ {
/*    */   private FutureResult result;
/*    */   private GUID remoteObjectID;
/*    */ 
/*    */   public FutureImpl(FutureResult result)
/*    */   {
/* 44 */     this.result = result;
/*    */   }
/*    */ 
/*    */   public void setRemoteObjectID(GUID remoteObjectID)
/*    */   {
/* 49 */     this.remoteObjectID = remoteObjectID;
/*    */   }
/*    */ 
/*    */   public void release()
/*    */   {
/* 54 */     if (this.remoteObjectID != null)
/*    */     {
/* 56 */       Dispatcher.singleton.unregisterTarget(this.remoteObjectID);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object get() throws InterruptedException, InvocationTargetException
/*    */   {
/*    */     try
/*    */     {
/* 64 */       Object rtn = this.result.get();
/* 65 */       release();
/* 66 */       return rtn;
/*    */     }
/*    */     catch (InvocationTargetException e)
/*    */     {
/* 70 */       release();
/* 71 */     }throw e;
/*    */   }
/*    */ 
/*    */   public Object get(long milliseconds)
/*    */     throws TimeoutException, InterruptedException, InvocationTargetException
/*    */   {
/*    */     try
/*    */     {
/* 79 */       Object rtn = this.result.timedGet(milliseconds);
/* 80 */       release();
/* 81 */       return rtn;
/*    */     }
/*    */     catch (EDU.oswego.cs.dl.util.concurrent.TimeoutException e)
/*    */     {
/* 85 */       throw new TimeoutException(e);
/*    */     }
/*    */     catch (InvocationTargetException e)
/*    */     {
/* 89 */       release();
/* 90 */     }throw e;
/*    */   }
/*    */ 
/*    */   public boolean isDone()
/*    */   {
/* 96 */     return this.result.isReady();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.FutureImpl
 * JD-Core Version:    0.6.0
 */