/*     */ package org.jboss.aop.util.reference;
/*     */ 
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.lang.ref.WeakReference;
/*     */ 
/*     */ public abstract class PersistentReference
/*     */ {
/*     */   public static final int REFERENCE_WEAK = 1;
/*     */   public static final int REFERENCE_SOFT = 2;
/*     */   private WeakReference classReference;
/*     */   private Reference referencedObject;
/*  45 */   private int referenceType = 0;
/*     */ 
/*     */   public PersistentReference(Class clazz, Object referencedObject, int referenceType)
/*     */   {
/*  55 */     this.referenceType = referenceType;
/*  56 */     if (clazz != null)
/*     */     {
/*  58 */       this.classReference = new WeakReference(clazz);
/*     */     }
/*  60 */     buildReference(referencedObject);
/*     */   }
/*     */ 
/*     */   protected Object internalGet()
/*     */   {
/*  66 */     if (this.referencedObject == null) {
/*  67 */       return null;
/*     */     }
/*  69 */     return this.referencedObject.get();
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */   {
/*  76 */     if (this.referencedObject == null) {
/*  77 */       return null;
/*     */     }
/*  79 */     Object returnValue = this.referencedObject.get();
/*  80 */     if (returnValue == null)
/*     */     {
/*     */       try
/*     */       {
/*  85 */         return rebuildReference();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  89 */         throw new RuntimeException(e.getMessage(), e);
/*     */       }
/*     */     }
/*     */ 
/*  93 */     return returnValue;
/*     */   }
/*     */   public abstract Object rebuildReference() throws Exception;
/*     */ 
/*     */   public void buildReference(Object obj) {
/*  99 */     if (obj == null)
/*     */     {
/* 101 */       this.referencedObject = null;
/*     */     }
/* 105 */     else if (this.referenceType == 1)
/*     */     {
/* 107 */       this.referencedObject = new WeakReference(obj);
/*     */     }
/*     */     else
/*     */     {
/* 111 */       this.referencedObject = new SoftReference(obj);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getMappedClass()
/*     */   {
/* 118 */     if (this.classReference == null) return null;
/* 119 */     Class returnClass = (Class)this.classReference.get();
/* 120 */     if (returnClass == null)
/*     */     {
/* 122 */       throw new RuntimeException("Class was already unloaded");
/*     */     }
/* 124 */     return returnClass;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.reference.PersistentReference
 * JD-Core Version:    0.6.0
 */