/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static Method[] getDeclaredMethods(Class clazz)
/*     */   {
/* 107 */     if (System.getSecurityManager() == null)
/*     */     {
/* 109 */       return GetDeclaredMethodsAction.NON_PRIVILEGED.getDeclaredMethods(clazz);
/*     */     }
/*     */ 
/* 113 */     return GetDeclaredMethodsAction.PRIVILEGED.getDeclaredMethods(clazz);
/*     */   }
/*     */ 
/*     */   static Constructor[] getDeclaredConstructors(Class clazz)
/*     */   {
/* 119 */     if (System.getSecurityManager() == null)
/*     */     {
/* 121 */       return GetDeclaredConstructorsAction.NON_PRIVILEGED.getDeclaredConstructors(clazz);
/*     */     }
/*     */ 
/* 125 */     return GetDeclaredConstructorsAction.PRIVILEGED.getDeclaredConstructors(clazz);
/*     */   }
/*     */ 
/*     */   static abstract interface GetDeclaredConstructorsAction
/*     */   {
/*  75 */     public static final GetDeclaredConstructorsAction PRIVILEGED = new GetDeclaredConstructorsAction()
/*     */     {
/*     */       public Constructor[] getDeclaredConstructors(Class clazz)
/*     */       {
/*     */         try
/*     */         {
/*  81 */           return (Constructor[])(Constructor[])AccessController.doPrivileged(new PrivilegedExceptionAction(clazz)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/*  85 */               return this.val$clazz.getDeclaredConstructors();
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/*  91 */         throw new RuntimeException(e);
/*     */       }
/*  75 */     };
/*     */ 
/*  96 */     public static final GetDeclaredConstructorsAction NON_PRIVILEGED = new GetDeclaredConstructorsAction()
/*     */     {
/*     */       public Constructor[] getDeclaredConstructors(Class clazz)
/*     */       {
/* 100 */         return clazz.getDeclaredConstructors();
/*     */       }
/*  96 */     };
/*     */ 
/*     */     public abstract Constructor[] getDeclaredConstructors(Class paramClass);
/*     */   }
/*     */ 
/*     */   static abstract interface GetDeclaredMethodsAction
/*     */   {
/*  41 */     public static final GetDeclaredMethodsAction PRIVILEGED = new GetDeclaredMethodsAction()
/*     */     {
/*     */       public Method[] getDeclaredMethods(Class clazz)
/*     */       {
/*     */         try
/*     */         {
/*  47 */           return (Method[])(Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(clazz)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/*  51 */               return this.val$clazz.getDeclaredMethods();
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/*  57 */         throw new RuntimeException(e);
/*     */       }
/*  41 */     };
/*     */ 
/*  62 */     public static final GetDeclaredMethodsAction NON_PRIVILEGED = new GetDeclaredMethodsAction()
/*     */     {
/*     */       public Method[] getDeclaredMethods(Class clazz)
/*     */       {
/*  66 */         return clazz.getDeclaredMethods();
/*     */       }
/*  62 */     };
/*     */ 
/*     */     public abstract Method[] getDeclaredMethods(Class paramClass);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.SecurityActions
 * JD-Core Version:    0.6.0
 */