/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.aop.util.reference.ConstructorPersistentReference;
/*     */ import org.jboss.aop.util.reference.MethodPersistentReference;
/*     */ 
/*     */ public class MethodHashing
/*     */ {
/*  49 */   static Map methodHashesByName = new WeakHashMap();
/*     */ 
/*  51 */   static Map methodHashesByClass = new WeakHashMap();
/*  52 */   static Map constructorHashesByClass = new WeakHashMap();
/*     */ 
/*     */   public static Method findMethodByHash(Class clazz, long hash) throws Exception
/*     */   {
/*  56 */     return findMethodByHash(clazz, new Long(hash));
/*     */   }
/*     */ 
/*     */   public static Method findMethodByHash(Class clazz, Long hash) throws Exception
/*     */   {
/*  61 */     Map hashes = getMethodHashes(clazz);
/*  62 */     MethodPersistentReference ref = (MethodPersistentReference)hashes.get(hash);
/*  63 */     if (ref != null)
/*     */     {
/*  65 */       return ref.getMethod();
/*     */     }
/*     */ 
/*  68 */     if (clazz.isInterface())
/*     */     {
/*  70 */       Class[] interfaces = clazz.getInterfaces();
/*  71 */       int numInterfaces = interfaces.length;
/*  72 */       for (int count = 0; count < numInterfaces; count++)
/*     */       {
/*  74 */         Method method = findMethodByHash(interfaces[count], hash);
/*  75 */         if (method != null)
/*     */         {
/*  77 */           return method;
/*     */         }
/*     */       }
/*     */     }
/*  81 */     else if (clazz.getSuperclass() != null)
/*     */     {
/*  83 */       return findMethodByHash(clazz.getSuperclass(), hash);
/*     */     }
/*  85 */     return null;
/*     */   }
/*     */ 
/*     */   public static Constructor findConstructorByHash(Class clazz, long hash) throws Exception
/*     */   {
/*  90 */     return findConstructorByHash(clazz, new Long(hash));
/*     */   }
/*     */ 
/*     */   public static Constructor findConstructorByHash(Class clazz, Long hash) throws Exception
/*     */   {
/*  95 */     Map hashes = getConstructorHashes(clazz);
/*  96 */     ConstructorPersistentReference ref = (ConstructorPersistentReference)hashes.get(hash);
/*  97 */     if (ref != null)
/*     */     {
/*  99 */       return ref.getConstructor();
/*     */     }
/* 101 */     if (clazz.getSuperclass() != null)
/*     */     {
/* 103 */       return findConstructorByHash(clazz, hash);
/*     */     }
/*     */ 
/* 115 */     return null;
/*     */   }
/*     */ 
/*     */   public static long methodHash(Method method)
/*     */     throws Exception
/*     */   {
/* 121 */     Class[] parameterTypes = method.getParameterTypes();
/* 122 */     StringBuffer methodDesc = new StringBuffer(method.getName() + "(");
/* 123 */     for (int j = 0; j < parameterTypes.length; j++)
/*     */     {
/* 125 */       methodDesc.append(getTypeString(parameterTypes[j]));
/*     */     }
/* 127 */     methodDesc.append(")" + getTypeString(method.getReturnType()));
/* 128 */     return createHash(methodDesc.toString());
/*     */   }
/*     */ 
/*     */   public static long createHash(String methodDesc)
/*     */     throws Exception
/*     */   {
/* 134 */     long hash = 0L;
/* 135 */     ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/* 136 */     MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/* 137 */     DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/* 138 */     dataoutputstream.writeUTF(methodDesc);
/* 139 */     dataoutputstream.flush();
/* 140 */     byte[] abyte0 = messagedigest.digest();
/* 141 */     for (int j = 0; j < Math.min(8, abyte0.length); j++)
/* 142 */       hash += ((abyte0[j] & 0xFF) << j * 8);
/* 143 */     return hash;
/*     */   }
/*     */ 
/*     */   public static long constructorHash(Constructor method)
/*     */     throws Exception
/*     */   {
/* 150 */     Class[] parameterTypes = method.getParameterTypes();
/* 151 */     StringBuffer methodDesc = new StringBuffer(method.getName() + "(");
/* 152 */     for (int j = 0; j < parameterTypes.length; j++)
/*     */     {
/* 154 */       methodDesc.append(getTypeString(parameterTypes[j]));
/*     */     }
/* 156 */     methodDesc.append(")");
/*     */ 
/* 158 */     return createHash(methodDesc.toString());
/*     */   }
/*     */ 
/*     */   static String getTypeString(Class cl)
/*     */   {
/* 163 */     if (cl == Byte.TYPE)
/*     */     {
/* 165 */       return "B";
/* 166 */     }if (cl == Character.TYPE)
/*     */     {
/* 168 */       return "C";
/* 169 */     }if (cl == Double.TYPE)
/*     */     {
/* 171 */       return "D";
/* 172 */     }if (cl == Float.TYPE)
/*     */     {
/* 174 */       return "F";
/* 175 */     }if (cl == Integer.TYPE)
/*     */     {
/* 177 */       return "I";
/* 178 */     }if (cl == Long.TYPE)
/*     */     {
/* 180 */       return "J";
/* 181 */     }if (cl == Short.TYPE)
/*     */     {
/* 183 */       return "S";
/* 184 */     }if (cl == Boolean.TYPE)
/*     */     {
/* 186 */       return "Z";
/* 187 */     }if (cl == Void.TYPE)
/*     */     {
/* 189 */       return "V";
/* 190 */     }if (cl.isArray())
/*     */     {
/* 192 */       return "[" + getTypeString(cl.getComponentType());
/*     */     }
/*     */ 
/* 195 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   public static long calculateHash(Method method)
/*     */   {
/* 208 */     Map methodHashes = (Map)methodHashesByName.get(method.getDeclaringClass());
/*     */ 
/* 210 */     if (methodHashes == null)
/*     */     {
/* 212 */       methodHashes = getInterfaceHashes(method.getDeclaringClass());
/*     */ 
/* 215 */       WeakHashMap newHashMap = new WeakHashMap();
/* 216 */       newHashMap.putAll(methodHashesByName);
/* 217 */       newHashMap.put(method.getDeclaringClass(), methodHashes);
/* 218 */       methodHashesByName = newHashMap;
/*     */     }
/*     */ 
/* 221 */     return ((Long)methodHashes.get(method.toString())).longValue();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static Map getInterfaceHashes(Class intf)
/*     */   {
/* 235 */     Method[] methods = SecurityActions.getDeclaredMethods(intf);
/* 236 */     HashMap map = new HashMap();
/* 237 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 239 */       Method method = methods[i];
/*     */       try
/*     */       {
/* 242 */         long hash = methodHash(method);
/* 243 */         map.put(method.toString(), new Long(hash));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 250 */     return map;
/*     */   }
/*     */ 
/*     */   private static Map getMethodHashes(Class clazz)
/*     */   {
/* 255 */     Map methodHashes = (Map)methodHashesByClass.get(clazz);
/* 256 */     if (methodHashes == null)
/*     */     {
/* 258 */       methodHashes = getMethodHashMap(clazz);
/* 259 */       methodHashesByClass.put(clazz, methodHashes);
/*     */     }
/* 261 */     return methodHashes;
/*     */   }
/*     */ 
/*     */   private static Map getMethodHashMap(Class clazz)
/*     */   {
/* 267 */     Method[] methods = SecurityActions.getDeclaredMethods(clazz);
/* 268 */     HashMap map = new HashMap();
/* 269 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 273 */         long hash = methodHash(methods[i]);
/*     */ 
/* 275 */         map.put(new Long(hash), new MethodPersistentReference(methods[i], 2));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 282 */     return map;
/*     */   }
/*     */ 
/*     */   private static Map getConstructorHashes(Class clazz)
/*     */   {
/* 287 */     Map constructorHashes = (Map)constructorHashesByClass.get(clazz);
/* 288 */     if (constructorHashes == null)
/*     */     {
/* 290 */       constructorHashes = getConstructorHashMap(clazz);
/* 291 */       constructorHashesByClass.put(clazz, constructorHashes);
/*     */     }
/* 293 */     return constructorHashes;
/*     */   }
/*     */ 
/*     */   private static Map getConstructorHashMap(Class clazz)
/*     */   {
/* 299 */     Constructor[] constructors = SecurityActions.getDeclaredConstructors(clazz);
/* 300 */     HashMap map = new HashMap();
/* 301 */     for (int i = 0; i < constructors.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 305 */         long hash = constructorHash(constructors[i]);
/*     */ 
/* 307 */         map.put(new Long(hash), new ConstructorPersistentReference(constructors[i], 2));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 314 */     return map;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.MethodHashing
 * JD-Core Version:    0.6.0
 */