/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.OutputStream;
/*     */ import java.util.Arrays;
/*     */ 
/*     */ public class MarshalledValue
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -1527598981234110311L;
/*  51 */   private byte[] serializedForm = null;
/*     */   private int hashCode;
/*  57 */   private boolean isHashComputed = false;
/*     */ 
/*  59 */   private ByteArrayOutputStream baos = null;
/*     */ 
/*     */   public MarshalledValue()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MarshalledValue(Object obj)
/*     */     throws IOException
/*     */   {
/*  71 */     this.baos = new ByteArrayOutputStream();
/*  72 */     MarshalledValueOutputStream mvos = new MarshalledValueOutputStream(this.baos);
/*  73 */     mvos.writeObject(obj);
/*  74 */     mvos.flush();
/*     */ 
/*  76 */     this.serializedForm = this.baos.toByteArray();
/*     */ 
/*  78 */     this.isHashComputed = false;
/*     */   }
/*     */ 
/*     */   public Object get() throws IOException, ClassNotFoundException
/*     */   {
/*  83 */     if (this.serializedForm == null) {
/*  84 */       return null;
/*     */     }
/*  86 */     ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedForm);
/*  87 */     MarshalledValueInputStream mvis = new MarshalledValueInputStream(bais);
/*  88 */     return mvis.readObject();
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray()
/*     */   {
/*  93 */     return this.serializedForm;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  98 */     int size = this.serializedForm != null ? this.serializedForm.length : 0;
/*  99 */     return size;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 111 */     if (!this.isHashComputed)
/*     */     {
/* 113 */       int hash = 0;
/* 114 */       for (int i = 0; i < this.serializedForm.length; i++)
/*     */       {
/* 116 */         hash = 31 * hash + this.serializedForm[i];
/*     */       }
/*     */ 
/* 119 */       this.hashCode = hash;
/*     */     }
/*     */ 
/* 122 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 127 */     if (this == obj) {
/* 128 */       return true;
/*     */     }
/* 130 */     boolean equals = false;
/* 131 */     if ((obj instanceof MarshalledValue))
/*     */     {
/* 133 */       MarshalledValue mv = (MarshalledValue)obj;
/* 134 */       if (this.serializedForm == mv.serializedForm)
/*     */       {
/* 136 */         equals = true;
/*     */       }
/*     */       else
/*     */       {
/* 140 */         equals = Arrays.equals(this.serializedForm, mv.serializedForm);
/*     */       }
/*     */     }
/* 143 */     return equals;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 161 */     int length = in.readInt();
/* 162 */     this.serializedForm = null;
/* 163 */     if (length > 0)
/*     */     {
/* 165 */       this.serializedForm = new byte[length];
/* 166 */       in.readFully(this.serializedForm);
/*     */     }
/* 168 */     this.isHashComputed = false;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 189 */     out.writeInt(this.baos.size());
/* 190 */     this.baos.writeTo((OutputStream)out);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.MarshalledValue
 * JD-Core Version:    0.6.0
 */