/*    */ package org.jboss.aop.standalone;
/*    */ 
/*    */ import java.lang.instrument.ClassDefinition;
/*    */ import java.lang.instrument.Instrumentation;
/*    */ import java.lang.instrument.UnmodifiableClassException;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import org.jboss.aop.instrument.HotSwapper;
/*    */ 
/*    */ class InstrumentationAdapter
/*    */   implements HotSwapper
/*    */ {
/*    */   private Instrumentation instrumentation;
/*    */   private Collection<ClassDefinition> classDefinitions;
/*    */ 
/*    */   public InstrumentationAdapter(Instrumentation instrumentation)
/*    */   {
/* 50 */     this.instrumentation = instrumentation;
/* 51 */     this.classDefinitions = new ArrayList();
/*    */   }
/*    */ 
/*    */   public synchronized void registerChange(Class clazz, byte[] classCode)
/*    */   {
/* 61 */     ClassDefinition classDef = new ClassDefinition(clazz, classCode);
/* 62 */     this.classDefinitions.add(classDef);
/*    */   }
/*    */ 
/*    */   public synchronized void hotSwap()
/*    */   {
/* 72 */     ClassDefinition[] definitions = new ClassDefinition[this.classDefinitions.size()];
/* 73 */     definitions = (ClassDefinition[])(ClassDefinition[])this.classDefinitions.toArray(definitions);
/*    */     try
/*    */     {
/* 76 */       this.instrumentation.redefineClasses(definitions);
/*    */     }
/*    */     catch (ClassNotFoundException e)
/*    */     {
/* 80 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (UnmodifiableClassException e)
/*    */     {
/* 84 */       throw new RuntimeException(e);
/*    */     }
/*    */     finally
/*    */     {
/* 88 */       this.classDefinitions.clear();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.standalone.InstrumentationAdapter
 * JD-Core Version:    0.6.0
 */