/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.Domain;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisorDelegate;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ public class InstanceProxyContainer extends ClassProxyContainer
/*     */   implements InstanceAdvisor
/*     */ {
/*     */   Advisor classAdvisor;
/*     */   InstanceAdvisorDelegate delegate;
/*     */ 
/*     */   public InstanceProxyContainer(String name, ProxyAdvisorDomain instanceDomain, Advisor classAdvisor, MetaData metaData)
/*     */   {
/*  50 */     super(name, instanceDomain);
/*  51 */     this.classAdvisor = classAdvisor;
/*  52 */     instanceDomain.setAdvisor(this);
/*  53 */     setMetadata(metaData);
/*  54 */     this.delegate = new InstanceAdvisorDelegate(classAdvisor, this);
/*  55 */     this.delegate.initialize();
/*  56 */     initialise(classAdvisor.getClazz());
/*     */   }
/*     */ 
/*     */   public static InstanceProxyContainer createInstanceProxyContainer(Advisor classAdvisor, InterfaceIntroduction introduction, MetaData metaData)
/*     */   {
/*  61 */     String name = Domain.getDomainName(classAdvisor.getClazz(), true);
/*  62 */     ProxyAdvisorDomain domain = new ProxyAdvisorDomain(classAdvisor.getManager(), name, classAdvisor.getClazz(), true);
/*  63 */     if (introduction != null)
/*     */     {
/*  65 */       domain.addInterfaceIntroduction(introduction);
/*     */     }
/*     */ 
/*  68 */     InstanceProxyContainer ia = new InstanceProxyContainer(classAdvisor.getName(), domain, classAdvisor, metaData);
/*     */ 
/*  70 */     return ia;
/*     */   }
/*     */ 
/*     */   public Advisor getClassAdvisor()
/*     */   {
/*  75 */     return this.classAdvisor;
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(String aspectName)
/*     */   {
/*  80 */     return this.delegate.getPerInstanceAspect(aspectName);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(AspectDefinition def)
/*     */   {
/*  85 */     return this.delegate.getPerInstanceAspect(def);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def)
/*     */   {
/*  90 */     return this.delegate.getPerInstanceJoinpointAspect(joinpoint, def);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/*  95 */     return this.delegate.getMetaData();
/*     */   }
/*     */ 
/*     */   public Domain getDomain()
/*     */   {
/* 100 */     return (Domain)super.getManager();
/*     */   }
/*     */ 
/*     */   public boolean hasInterceptors()
/*     */   {
/* 108 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors()
/*     */   {
/* 116 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors(Interceptor[] baseChain)
/*     */   {
/* 124 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void insertInterceptor(Interceptor interceptor)
/*     */   {
/* 132 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void removeInterceptor(String name)
/*     */   {
/* 140 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void appendInterceptor(Interceptor interceptor)
/*     */   {
/* 148 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void insertInterceptorStack(String stackName)
/*     */   {
/* 156 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void removeInterceptorStack(String name)
/*     */   {
/* 164 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void appendInterceptorStack(String stackName)
/*     */   {
/* 172 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void insertInterceptor(int index, Interceptor interceptor)
/*     */   {
/* 180 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void appendInterceptor(int index, Interceptor interceptor)
/*     */   {
/* 188 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public void removeFromDomain()
/*     */   {
/* 193 */     ProxyAdvisorDomain domain = (ProxyAdvisorDomain)this.manager;
/* 194 */     domain.removeAdvisor(this);
/*     */   }
/*     */ 
/*     */   public Object getInstance()
/*     */   {
/* 199 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public MethodInfo getMethodInfo(long hash)
/*     */   {
/* 208 */     MethodInfo info = super.getMethodInfo(hash);
/* 209 */     if (((this.classAdvisor instanceof ClassAdvisor)) && (info.getMethod().equals(info.getUnadvisedMethod())))
/*     */     {
/* 211 */       MethodInfo superInfo = this.classAdvisor.getMethodInfo(hash);
/* 212 */       if (superInfo != null)
/*     */       {
/* 214 */         info.setUnadvisedMethod(superInfo.getUnadvisedMethod());
/*     */       }
/*     */     }
/*     */ 
/* 218 */     return info;
/*     */   }
/*     */ 
/*     */   protected Advisor getParentAdvisor()
/*     */   {
/* 223 */     return this.classAdvisor;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.InstanceProxyContainer
 * JD-Core Version:    0.6.0
 */