/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ 
/*     */ public class ContainerCacheUtil
/*     */ {
/*     */   public static WeakReference[] getSortedWeakReferenceForInterfaces(Class[] ifaces)
/*     */   {
/*  42 */     if (ifaces == null)
/*     */     {
/*  44 */       return null;
/*     */     }
/*     */ 
/*  47 */     WeakReference[] interfaces = new WeakReference[ifaces.length];
/*     */ 
/*  49 */     for (int i = 0; i < ifaces.length; i++)
/*     */     {
/*  51 */       interfaces[i] = new WeakReference(ifaces[i]);
/*     */     }
/*     */ 
/*  54 */     Arrays.sort(interfaces, Alphabetical.singleton);
/*  55 */     return interfaces;
/*     */   }
/*     */ 
/*     */   public static boolean compareClassRefs(WeakReference my, WeakReference other)
/*     */   {
/*  60 */     Class myClass = (Class)my.get();
/*  61 */     Class otherClass = (Class)other.get();
/*     */ 
/*  63 */     if ((myClass == null) || (otherClass == null))
/*     */     {
/*  65 */       return false;
/*     */     }
/*     */ 
/*  70 */     return myClass.equals(otherClass);
/*     */   }
/*     */ 
/*     */   public static boolean compareInterfaceRefs(WeakReference[] my, WeakReference[] other)
/*     */   {
/*  77 */     if (((my == null) && (other != null)) || ((my == null) && (other != null)))
/*     */     {
/*  80 */       return false;
/*     */     }
/*     */ 
/*  83 */     if ((my != null) && (my != null))
/*     */     {
/*  85 */       if (my.length != other.length)
/*     */       {
/*  87 */         return false;
/*     */       }
/*     */ 
/*  90 */       for (int i = 0; i < my.length; i++)
/*     */       {
/*  92 */         Class myIf = (Class)my[i].get();
/*  93 */         Class otherIf = (Class)other[i].get();
/*     */ 
/*  95 */         if (!myIf.equals(otherIf))
/*     */         {
/*  97 */           return false;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 102 */     return true;
/*     */   }
/*     */ 
/*     */   static class Alphabetical implements Comparator
/*     */   {
/* 107 */     static Alphabetical singleton = new Alphabetical();
/*     */ 
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/* 111 */       String name1 = ((Class)((WeakReference)o1).get()).getName();
/* 112 */       String name2 = ((Class)((WeakReference)o2).get()).getName();
/* 113 */       return name1.compareTo(name2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.ContainerCacheUtil
 * JD-Core Version:    0.6.0
 */