/*     */ package org.jboss.aop.proxy;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.SerialVersionUID;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.instrument.TransformerCommon;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.reference.MethodPersistentReference;
/*     */ import org.jboss.util.collection.WeakValueHashMap;
/*     */ 
/*     */ public class ClassProxyFactory
/*     */ {
/*  59 */   private static Object maplock = new Object();
/*  60 */   private static WeakValueHashMap classnameMap = new WeakValueHashMap();
/*  61 */   private static WeakHashMap proxyCache = new WeakHashMap();
/*  62 */   private static WeakHashMap methodMapCache = new WeakHashMap();
/*     */ 
/* 134 */   private static int counter = 0;
/*     */ 
/*     */   public static ClassProxy newInstance(Class clazz)
/*     */     throws Exception
/*     */   {
/*  66 */     return newInstance(clazz, null);
/*     */   }
/*     */ 
/*     */   public static ClassProxy newInstance(Class clazz, ProxyMixin[] mixins) throws Exception
/*     */   {
/*  71 */     return newInstance(clazz, mixins, new ClassInstanceAdvisor());
/*     */   }
/*     */ 
/*     */   private static Class getProxyClass(Class clazz, ProxyMixin[] mixins)
/*     */     throws Exception
/*     */   {
/*  78 */     if (ClassProxy.class.isAssignableFrom(clazz)) clazz = clazz.getSuperclass();
/*     */ 
/*  80 */     Class proxyClass = null;
/*  81 */     synchronized (maplock)
/*     */     {
/*  83 */       WeakReference ref = (WeakReference)proxyCache.get(clazz);
/*  84 */       if (ref != null)
/*     */       {
/*  86 */         proxyClass = (Class)ref.get();
/*     */       }
/*  88 */       if (proxyClass == null)
/*     */       {
/*  90 */         proxyClass = generateProxy(clazz, mixins);
/*  91 */         classnameMap.put(clazz.getName(), proxyClass);
/*  92 */         proxyCache.put(clazz, new WeakReference(proxyClass));
/*  93 */         HashMap map = methodMap(clazz);
/*  94 */         methodMapCache.put(proxyClass, map);
/*     */       }
/*     */     }
/*  97 */     return proxyClass;
/*     */   }
/*     */ 
/*     */   public static ClassProxy newInstance(Class clazz, ProxyMixin[] mixins, InstanceAdvisor advisor) throws Exception
/*     */   {
/* 102 */     Class proxyClass = getProxyClass(clazz, mixins);
/* 103 */     ClassProxy proxy = (ClassProxy)proxyClass.newInstance();
/* 104 */     proxy.setMixins(mixins);
/* 105 */     proxy._setInstanceAdvisor(advisor);
/* 106 */     return proxy;
/*     */   }
/*     */ 
/*     */   public static HashMap getMethodMap(String classname)
/*     */   {
/* 112 */     synchronized (maplock)
/*     */     {
/* 114 */       Class clazz = (Class)classnameMap.get(classname);
/* 115 */       if (clazz == null) return null;
/* 116 */       return (HashMap)methodMapCache.get(clazz);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static HashMap getMethodMap(Class clazz)
/*     */   {
/* 122 */     HashMap map = getMethodMap(clazz.getName());
/* 123 */     if (map != null) return map;
/*     */     try
/*     */     {
/* 126 */       return methodMap(clazz);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 130 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private static CtClass createProxyCtClass(ProxyMixin[] mixins, Class clazz)
/*     */     throws Exception
/*     */   {
/* 139 */     ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
/* 140 */     if (pool == null) throw new NullPointerException("Could not find ClassPool");
/*     */ 
/* 142 */     String classname = "AOPClassProxy$" + counter++;
/*     */ 
/* 144 */     CtClass template = pool.get("org.jboss.aop.proxy.ClassProxyTemplate");
/* 145 */     CtClass superclass = pool.get(clazz.getName());
/*     */ 
/* 147 */     CtField mixinField = template.getField("mixins");
/* 148 */     CtField instanceAdvisor = template.getField("instanceAdvisor");
/*     */ 
/* 150 */     CtClass proxy = TransformerCommon.makeClass(pool, classname, superclass);
/*     */ 
/* 152 */     mixinField = new CtField(mixinField.getType(), "mixins", proxy);
/* 153 */     mixinField.setModifiers(2);
/* 154 */     proxy.addField(mixinField);
/* 155 */     instanceAdvisor = new CtField(instanceAdvisor.getType(), "instanceAdvisor", proxy);
/* 156 */     instanceAdvisor.setModifiers(2);
/* 157 */     proxy.addField(instanceAdvisor);
/*     */ 
/* 159 */     CtMethod writeEx = CtNewMethod.make("   public void writeExternal(java.io.ObjectOutput out)\n   throws java.io.IOException\n   {\n   }", proxy);
/*     */ 
/* 163 */     CtMethod readEx = CtNewMethod.make("   public void readExternal(java.io.ObjectInput in)\n   throws java.io.IOException, ClassNotFoundException\n   {\n   }", proxy);
/*     */ 
/* 167 */     CtMethod getInstanceAdvisor = CtNewMethod.make("   public org.jboss.aop.InstanceAdvisor _getInstanceAdvisor()\n   {\n      return instanceAdvisor;\n   }", proxy);
/*     */ 
/* 171 */     CtMethod setInstanceAdvisor = CtNewMethod.make("   public void _setInstanceAdvisor(org.jboss.aop.InstanceAdvisor newAdvisor)\n   {\n      instanceAdvisor = (org.jboss.aop.ClassInstanceAdvisor) newAdvisor;\n   }", proxy);
/*     */ 
/* 175 */     CtMethod dynamicInvoke = CtNewMethod.make("   public org.jboss.aop.joinpoint.InvocationResponse _dynamicInvoke(org.jboss.aop.joinpoint.Invocation invocation)\n   throws Throwable\n   {\n      ((org.jboss.aop.joinpoint.InvocationBase) invocation).setInstanceResolver(instanceAdvisor.getMetaData());\n      org.jboss.aop.advice.Interceptor[] aspects = instanceAdvisor.getInterceptors();\n      return new org.jboss.aop.joinpoint.InvocationResponse(invocation.invokeNext(aspects));\n   }", proxy);
/*     */ 
/* 183 */     CtMethod setMixins = CtNewMethod.make("   public void setMixins(org.jboss.aop.proxy.ProxyMixin[] mixins)\n   {\n      this.mixins = mixins;\n   }", proxy);
/*     */ 
/* 188 */     CtMethod writeReplace = CtNewMethod.make("   public Object writeReplace() throws java.io.ObjectStreamException\n   {\n      return new org.jboss.aop.proxy.MarshalledClassProxy(this.getClass().getSuperclass(), mixins, instanceAdvisor);\n   }", proxy);
/*     */ 
/* 194 */     proxy.addMethod(writeEx);
/* 195 */     proxy.addMethod(readEx);
/* 196 */     proxy.addMethod(getInstanceAdvisor);
/* 197 */     proxy.addMethod(setInstanceAdvisor);
/* 198 */     proxy.addMethod(dynamicInvoke);
/* 199 */     proxy.addMethod(setMixins);
/* 200 */     proxy.addMethod(writeReplace);
/*     */ 
/* 224 */     proxy.addInterface(pool.get("org.jboss.aop.proxy.ClassProxy"));
/* 225 */     proxy.addInterface(pool.get("java.io.Externalizable"));
/* 226 */     proxy.addInterface(pool.get("org.jboss.aop.instrument.Untransformable"));
/* 227 */     proxy.addInterface(pool.get("org.jboss.aop.proxy.MethodMapped"));
/*     */ 
/* 229 */     CtClass map = pool.get("java.util.Map");
/* 230 */     CtField methodMap = new CtField(map, "methodMap", proxy);
/* 231 */     methodMap.setModifiers(10);
/* 232 */     proxy.addField(methodMap);
/* 233 */     CtMethod getMethodMap = CtNewMethod.getter("getMethodMap", methodMap);
/* 234 */     getMethodMap.setModifiers(1);
/* 235 */     proxy.addMethod(getMethodMap);
/*     */ 
/* 237 */     HashSet addedInterfaces = new HashSet();
/* 238 */     HashSet addedMethods = new HashSet();
/* 239 */     if (mixins != null)
/*     */     {
/* 241 */       for (int i = 0; i < mixins.length; i++)
/*     */       {
/* 243 */         HashSet mixinMethods = new HashSet();
/* 244 */         Class[] mixinf = mixins[i].getInterfaces();
/* 245 */         ClassPool mixPool = AspectManager.instance().findClassPool(mixins[i].getMixin().getClass().getClassLoader());
/* 246 */         CtClass mixClass = mixPool.get(mixins[i].getMixin().getClass().getName());
/* 247 */         for (int j = 0; j < mixinf.length; j++)
/*     */         {
/* 249 */           if (addedInterfaces.contains(mixinf[j].getName())) throw new Exception("2 mixins are implementing the same interfaces");
/* 250 */           ClassPool mixIntfPool = AspectManager.instance().findClassPool(mixinf[j].getClassLoader());
/* 251 */           CtClass intfClass = mixIntfPool.get(mixinf[j].getName());
/* 252 */           CtMethod[] methods = intfClass.getMethods();
/* 253 */           for (int m = 0; m < methods.length; m++)
/*     */           {
/* 255 */             if (!methods[m].getDeclaringClass().getName().equals("java.lang.Object")) {
/* 256 */               Long hash = new Long(JavassistMethodHashing.methodHash(methods[m]));
/* 257 */               if (!mixinMethods.contains(hash)) {
/* 258 */                 if (addedMethods.contains(hash)) throw new Exception("More than one mixin has same method");
/* 259 */                 mixinMethods.add(hash);
/* 260 */                 addedMethods.add(hash);
/* 261 */                 String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
/* 262 */                 String code = "{   " + mixClass.getName() + " mixin = (" + mixClass.getName() + ")mixins[" + i + "].getMixin();" + "   " + returnStr + " mixin." + methods[m].getName() + "($$);" + "}";
/*     */ 
/* 266 */                 CtMethod newMethod = CtNewMethod.make(methods[m].getReturnType(), methods[m].getName(), methods[m].getParameterTypes(), methods[m].getExceptionTypes(), code, proxy);
/* 267 */                 newMethod.setModifiers(1);
/* 268 */                 proxy.addMethod(newMethod);
/*     */               }
/*     */             }
/*     */           }
/* 271 */           proxy.addInterface(intfClass);
/* 272 */           addedInterfaces.add(intfClass.getName());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 277 */     HashMap allMethods = JavassistMethodHashing.getMethodMap(superclass);
/*     */ 
/* 279 */     Iterator it = allMethods.entrySet().iterator();
/* 280 */     while (it.hasNext())
/*     */     {
/* 282 */       Map.Entry entry = (Map.Entry)it.next();
/* 283 */       CtMethod m = (CtMethod)entry.getValue();
/* 284 */       if ((!javassist.Modifier.isPublic(m.getModifiers())) || (javassist.Modifier.isStatic(m.getModifiers())))
/*     */         continue;
/* 286 */       Long hash = (Long)entry.getKey();
/* 287 */       if (!addedMethods.contains(hash)) {
/* 288 */         addedMethods.add(hash);
/* 289 */         String aopReturnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
/* 290 */         String args = "null";
/* 291 */         if (m.getParameterTypes().length > 0) args = "$args";
/* 292 */         String code = "{       org.jboss.aop.advice.Interceptor[] aspects = instanceAdvisor.getInterceptors();     org.jboss.aop.MethodInfo mi = new org.jboss.aop.MethodInfo();     mi.setHash(" + hash.longValue() + "L);" + "    org.jboss.aop.proxy.ProxyMethodInvocation invocation = new org.jboss.aop.proxy.ProxyMethodInvocation(this, mi, aspects); " + "    invocation.setInstanceResolver(instanceAdvisor.getMetaData()); " + "    invocation.setArguments(" + args + "); " + "    " + aopReturnStr + " invocation.invokeNext(); " + "}";
/*     */ 
/* 301 */         CtMethod newMethod = CtNewMethod.make(m.getReturnType(), m.getName(), m.getParameterTypes(), m.getExceptionTypes(), code, proxy);
/* 302 */         newMethod.setModifiers(1);
/* 303 */         proxy.addMethod(newMethod);
/*     */       }
/*     */     }
/* 305 */     SerialVersionUID.setSerialVersionUID(proxy);
/* 306 */     return proxy;
/*     */   }
/*     */ 
/*     */   private static Class generateProxy(Class clazz, ProxyMixin[] mixins) throws Exception
/*     */   {
/* 311 */     CtClass proxy = createProxyCtClass(mixins, clazz);
/* 312 */     ProtectionDomain pd = clazz.getProtectionDomain();
/* 313 */     Class proxyClass = TransformerCommon.toClass(proxy, pd);
/* 314 */     Map methodmap = getMethodMap(proxyClass);
/* 315 */     Field field = proxyClass.getDeclaredField("methodMap");
/* 316 */     SecurityActions.setAccessible(field);
/* 317 */     field.set(null, methodmap);
/* 318 */     return proxyClass;
/*     */   }
/*     */ 
/*     */   private static void populateMethodTables(HashMap advised, List ignoredHash, Class superclass)
/*     */     throws Exception
/*     */   {
/* 324 */     if (superclass == null) return;
/* 325 */     if (superclass.getName().equals("java.lang.Object")) return;
/*     */ 
/* 327 */     Method[] declaredMethods = superclass.getDeclaredMethods();
/* 328 */     for (int i = 0; i < declaredMethods.length; i++)
/*     */     {
/* 330 */       if (!ClassAdvisor.isAdvisable(declaredMethods[i]))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 335 */       if (!java.lang.reflect.Modifier.isVolatile(declaredMethods[i].getModifiers()))
/*     */       {
/* 337 */         long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 338 */         if (!ignoredHash.contains(new Long(hash)))
/* 339 */           advised.put(new Long(hash), new MethodPersistentReference(declaredMethods[i], 2));
/*     */       }
/*     */       else
/*     */       {
/* 343 */         long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 344 */         ignoredHash.add(new Long(hash));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 349 */     populateMethodTables(advised, ignoredHash, superclass.getSuperclass());
/*     */   }
/*     */ 
/*     */   public static HashMap methodMap(Class clazz)
/*     */     throws Exception
/*     */   {
/* 356 */     HashMap methods = new HashMap();
/* 357 */     List ignoredHash = new ArrayList();
/* 358 */     populateMethodTables(methods, ignoredHash, clazz);
/* 359 */     return methods;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.ClassProxyFactory
 * JD-Core Version:    0.6.0
 */