/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class SimpleNode
/*     */   implements Node
/*     */ {
/*     */   protected Node parent;
/*     */   protected Node[] children;
/*     */   protected int id;
/*     */   protected Object parser;
/*     */ 
/*     */   public SimpleNode(int i)
/*     */   {
/*  32 */     this.id = i;
/*     */   }
/*     */ 
/*     */   public SimpleNode(Object p, int i) {
/*  36 */     this(i);
/*  37 */     this.parser = p;
/*     */   }
/*     */   public void jjtOpen() {
/*     */   }
/*     */ 
/*     */   public void jjtClose() {
/*     */   }
/*     */ 
/*     */   public void jjtSetParent(Node n) {
/*  46 */     this.parent = n; } 
/*  47 */   public Node jjtGetParent() { return this.parent; }
/*     */ 
/*     */   public void jjtAddChild(Node n, int i) {
/*  50 */     if (this.children == null) {
/*  51 */       this.children = new Node[i + 1];
/*  52 */     } else if (i >= this.children.length) {
/*  53 */       Node[] c = new Node[i + 1];
/*  54 */       System.arraycopy(this.children, 0, c, 0, this.children.length);
/*  55 */       this.children = c;
/*     */     }
/*  57 */     this.children[i] = n;
/*     */   }
/*     */ 
/*     */   public Node jjtGetChild(int i) {
/*  61 */     return this.children[i];
/*     */   }
/*     */ 
/*     */   public int jjtGetNumChildren() {
/*  65 */     return this.children == null ? 0 : this.children.length;
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(PointcutExpressionParserVisitor visitor, Object data)
/*     */   {
/*  70 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(TypeExpressionParserVisitor visitor, Object data)
/*     */   {
/*  76 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public Object childrenAccept(PointcutExpressionParserVisitor visitor, Object data)
/*     */   {
/*  81 */     if (this.children != null) {
/*  82 */       for (int i = 0; i < this.children.length; i++) {
/*  83 */         this.children[i].jjtAccept(visitor, data);
/*     */       }
/*     */     }
/*  86 */     return data;
/*     */   }
/*     */ 
/*     */   public Object childrenAccept(TypeExpressionParserVisitor visitor, Object data)
/*     */   {
/*  91 */     if (this.children != null) {
/*  92 */       for (int i = 0; i < this.children.length; i++) {
/*  93 */         this.children[i].jjtAccept(visitor, data);
/*     */       }
/*     */     }
/*  96 */     return data;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     return PointcutExpressionParserTreeConstants.jjtNodeName[this.id]; } 
/* 106 */   public String toString(String prefix) { return prefix + toString();
/*     */   }
/*     */ 
/*     */   public void dump(String prefix)
/*     */   {
/* 112 */     System.out.println(toString(prefix));
/* 113 */     if (this.children != null)
/* 114 */       for (int i = 0; i < this.children.length; i++) {
/* 115 */         SimpleNode n = (SimpleNode)this.children[i];
/* 116 */         if (n != null)
/* 117 */           n.dump(prefix + " ");
/*     */       }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.SimpleNode
 * JD-Core Version:    0.6.0
 */