/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ 
/*     */ public class ClassExpression
/*     */ {
/*     */   private String original;
/*     */   private Pattern classPattern;
/*  37 */   private boolean isAnnotation = false;
/*  38 */   private boolean isInstanceOf = false;
/*  39 */   private boolean isTypedef = false;
/*  40 */   private boolean isPackage = false;
/*     */ 
/*  42 */   private boolean isInstanceOfAnnotated = false;
/*     */ 
/*     */   public ClassExpression(String expr)
/*     */   {
/*  46 */     this.original = expr;
/*  47 */     if (expr.startsWith("@"))
/*     */     {
/*  49 */       this.isAnnotation = true;
/*     */     }
/*     */     else
/*     */     {
/*  53 */       expr = this.original;
/*  54 */       if (expr.startsWith("$instanceof{"))
/*     */       {
/*  56 */         this.isInstanceOf = true;
/*  57 */         expr = expr.substring(12, expr.lastIndexOf("}"));
/*  58 */         this.isInstanceOfAnnotated = expr.startsWith("@");
/*     */       }
/*  60 */       else if (expr.startsWith("$typedef{"))
/*     */       {
/*  62 */         this.isTypedef = true;
/*  63 */         expr = expr.substring(9, expr.lastIndexOf("}"));
/*     */       }
/*  65 */       else if (expr.endsWith(".."))
/*     */       {
/*  67 */         this.isPackage = true;
/*  68 */         expr = expr.substring(0, expr.lastIndexOf(".."));
/*     */       }
/*     */ 
/*  71 */       if (!this.isAnnotation)
/*     */       {
/*  73 */         expr = expr.replaceAll("\\.", "\\\\.");
/*  74 */         expr = expr.replaceAll("\\*", ".*");
/*  75 */         expr = expr.replaceAll("\\[", "\\\\[");
/*  76 */         expr = expr.replaceAll("]", "\\\\]");
/*  77 */         expr = expr.replaceAll("\\$", "\\\\\\$");
/*  78 */         this.classPattern = Pattern.compile(expr);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isSimple()
/*     */   {
/*  86 */     return (!this.isAnnotation) && (!this.isInstanceOf) && (!this.isTypedef) && (!this.isInstanceOfAnnotated);
/*     */   }
/*     */ 
/*     */   public boolean matches(String classname)
/*     */   {
/*  91 */     if (this.isAnnotation) return false;
/*  92 */     if (isPackage())
/*     */     {
/*  94 */       int index = classname.lastIndexOf(".");
/*  95 */       boolean matches = this.classPattern.toString().equals(".*");
/*  96 */       if ((!matches) && (index != -1))
/*     */       {
/*  98 */         String candidate = classname.substring(0, index);
/*  99 */         Matcher m = this.classPattern.matcher(candidate);
/* 100 */         matches = m.matches();
/*     */       }
/* 102 */       return matches;
/*     */     }
/*     */ 
/* 106 */     Matcher m = this.classPattern.matcher(classname);
/* 107 */     return m.matches();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/* 113 */     return this.isAnnotation;
/*     */   }
/*     */ 
/*     */   public boolean isPackage()
/*     */   {
/* 118 */     return this.isPackage;
/*     */   }
/*     */ 
/*     */   public boolean isInstanceOf()
/*     */   {
/* 123 */     return this.isInstanceOf;
/*     */   }
/*     */ 
/*     */   public boolean isTypedef()
/*     */   {
/* 128 */     return this.isTypedef;
/*     */   }
/*     */ 
/*     */   public boolean isInstanceOfAnnotated()
/*     */   {
/* 133 */     return this.isInstanceOfAnnotated;
/*     */   }
/*     */ 
/*     */   public String getInstanceOfAnnotation()
/*     */   {
/* 138 */     if (!this.isInstanceOfAnnotated)
/*     */     {
/* 140 */       return null;
/*     */     }
/* 142 */     return this.original.substring(12, this.original.lastIndexOf("}"));
/*     */   }
/*     */ 
/*     */   public String getOriginal()
/*     */   {
/* 147 */     return this.original;
/*     */   }
/*     */ 
/*     */   public static String simpleType(Class type)
/*     */   {
/* 152 */     Class ret = type;
/* 153 */     if (ret.isArray())
/*     */     {
/* 155 */       Class arr = ret;
/* 156 */       String array = "";
/* 157 */       while (arr.isArray())
/*     */       {
/* 159 */         array = array + "[]";
/* 160 */         arr = arr.getComponentType();
/*     */       }
/* 162 */       return arr.getName() + array;
/*     */     }
/* 164 */     return ret.getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.ClassExpression
 * JD-Core Version:    0.6.0
 */