/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.annotation.AnnotationElement;
/*     */ import org.jboss.aop.annotation.PortableAnnotationElement;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTException;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTParameter;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class Util
/*     */ {
/*     */   public static boolean matchesClassExpr(ClassExpression classExpr, CtClass clazz, Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/*  67 */       if (classExpr.isAnnotation())
/*     */       {
/*  69 */         String sub = classExpr.getOriginal().substring(1);
/*  70 */         if (advisor != null)
/*     */         {
/*  72 */           if (advisor.getClassMetaData().hasTag(sub)) return true;
/*  73 */           return advisor.hasAnnotation(clazz, sub);
/*     */         }
/*     */ 
/*  77 */         return AnnotationElement.isAnyAnnotationPresent(clazz, sub);
/*     */       }
/*     */ 
/*  80 */       if (classExpr.isInstanceOf())
/*     */       {
/*  82 */         return subtypeOf(clazz, classExpr, advisor);
/*     */       }
/*  84 */       if (classExpr.isTypedef())
/*     */       {
/*  86 */         return matchesTypedef(clazz, classExpr, advisor);
/*     */       }
/*     */ 
/*  90 */       return classExpr.matches(clazz.getName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*  95 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static boolean matchesClassExpr(ClassExpression classExpr, Class clazz)
/*     */   {
/* 102 */     return matchesClassExpr(classExpr, clazz, null);
/*     */   }
/*     */ 
/*     */   public static boolean matchesClassExpr(ClassExpression classExpr, Class clazz, Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 109 */       if (classExpr.isAnnotation())
/*     */       {
/* 111 */         String sub = classExpr.getOriginal().substring(1);
/* 112 */         if (advisor != null)
/*     */         {
/* 114 */           if (advisor.getClassMetaData().hasTag(sub)) return true;
/* 115 */           return advisor.hasAnnotation(clazz, sub);
/*     */         }
/*     */ 
/* 119 */         return AnnotationElement.isAnyAnnotationPresent(clazz, sub);
/*     */       }
/*     */ 
/* 122 */       if (classExpr.isInstanceOf())
/*     */       {
/* 124 */         return subtypeOf(clazz, classExpr, advisor);
/*     */       }
/* 126 */       if (classExpr.isTypedef())
/*     */       {
/* 128 */         return matchesTypedef(clazz, classExpr, advisor);
/*     */       }
/*     */ 
/* 132 */       return classExpr.matches(clazz.getName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 137 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static boolean methodExistsInSuperClassOrInterface(Method method, ClassExpression target, boolean exactSuper, Advisor advisor)
/*     */     throws Exception
/*     */   {
/* 148 */     long hash = MethodHashing.calculateHash(method);
/* 149 */     boolean exists = methodExistsInSuperClassOrInterface(hash, target, method.getDeclaringClass(), exactSuper);
/* 150 */     if (!exists)
/*     */     {
/* 152 */       exists = checkMethodExistsInIntroductions(hash, target, exactSuper, advisor);
/*     */     }
/* 154 */     return exists;
/*     */   }
/*     */ 
/*     */   private static boolean methodExistsInSuperClassOrInterface(long hash, ClassExpression expr, Class clazz, boolean exactSuper) throws Exception
/*     */   {
/* 159 */     if (clazz == null) return false;
/*     */ 
/* 161 */     if (expr.isAnnotation())
/*     */     {
/* 163 */       String sub = expr.getOriginal().substring(1);
/* 164 */       if (AnnotationElement.isAnyAnnotationPresent(clazz, sub))
/*     */       {
/* 166 */         if (classHasMethod(clazz, hash, exactSuper)) return true;
/*     */       }
/*     */     }
/* 169 */     else if (expr.matches(clazz.getName()))
/*     */     {
/* 171 */       if (classHasMethod(clazz, hash, exactSuper)) return true;
/*     */     }
/*     */ 
/* 174 */     Class[] interfaces = clazz.getInterfaces();
/* 175 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 177 */       if (methodExistsInSuperClassOrInterface(hash, expr, interfaces[i], exactSuper)) return true;
/*     */     }
/*     */ 
/* 180 */     if (clazz.isInterface()) return false;
/*     */ 
/* 182 */     return methodExistsInSuperClassOrInterface(hash, expr, clazz.getSuperclass(), exactSuper);
/*     */   }
/*     */ 
/*     */   private static boolean checkMethodExistsInIntroductions(long hash, ClassExpression target, boolean exactSuper, Advisor advisor)
/*     */     throws Exception
/*     */   {
/*     */     ClassPool pool;
/*     */     HashSet doneClasses;
/*     */     Iterator it;
/* 191 */     if (advisor != null)
/*     */     {
/* 193 */       ArrayList intros = advisor.getInterfaceIntroductions();
/* 194 */       if (intros.size() > 0)
/*     */       {
/* 196 */         ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 197 */         pool = advisor.getManager().findClassPool(tcl);
/* 198 */         doneClasses = new HashSet();
/* 199 */         for (it = intros.iterator(); it.hasNext(); )
/*     */         {
/* 201 */           InterfaceIntroduction intro = (InterfaceIntroduction)it.next();
/* 202 */           String[] ifs = intro.getInterfaces();
/* 203 */           for (int i = 0; (ifs != null) && (i < ifs.length); i++)
/*     */           {
/* 205 */             if (doneClasses.contains(ifs[i]))
/*     */               continue;
/* 207 */             doneClasses.add(ifs[i]);
/* 208 */             if (methodExistsInSuperClassOrInterface(pool, hash, target, ifs[i], exactSuper)) return true;
/*     */ 
/*     */           }
/*     */ 
/* 212 */           ArrayList mixins = intro.getMixins();
/* 213 */           if ((mixins != null) && (mixins.size() > 0))
/*     */           {
/* 215 */             for (mit = mixins.iterator(); mit.hasNext(); )
/*     */             {
/* 217 */               InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mit.next();
/* 218 */               String[] mifs = mixin.getInterfaces();
/* 219 */               for (int i = 0; (mifs != null) && (i < mifs.length); i++)
/*     */               {
/* 221 */                 if (doneClasses.contains(mifs[i]))
/*     */                   continue;
/* 223 */                 doneClasses.add(mifs[i]);
/* 224 */                 if (methodExistsInSuperClassOrInterface(pool, hash, target, mifs[i], exactSuper)) return true;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     Iterator mit;
/* 232 */     return false;
/*     */   }
/*     */ 
/*     */   private static boolean classHasMethod(Class clazz, long hash, boolean exactSuper) throws Exception
/*     */   {
/* 237 */     Method m = MethodHashing.findMethodByHash(clazz, hash);
/* 238 */     if (m != null)
/*     */     {
/* 240 */       if (exactSuper)
/*     */       {
/* 243 */         return clazz == m.getDeclaringClass();
/*     */       }
/*     */ 
/* 247 */       return true;
/*     */     }
/*     */ 
/* 251 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean methodExistsInSuperClassOrInterface(CtMethod method, ClassExpression target, boolean exactSuper)
/*     */     throws Exception
/*     */   {
/* 260 */     long hash = JavassistMethodHashing.methodHash(method);
/* 261 */     return methodExistsInSuperClassOrInterface(hash, target, method.getDeclaringClass(), exactSuper);
/*     */   }
/*     */ 
/*     */   private static boolean methodExistsInSuperClassOrInterface(ClassPool pool, long hash, ClassExpression expr, String className, boolean exactSuper) throws Exception
/*     */   {
/* 266 */     CtClass clazz = pool.get(className);
/* 267 */     HashMap map = JavassistMethodHashing.getMethodMap(clazz);
/* 268 */     return methodExistsInSuperClassOrInterface(hash, expr, clazz, exactSuper);
/*     */   }
/*     */ 
/*     */   private static boolean methodExistsInSuperClassOrInterface(long hash, ClassExpression expr, CtClass clazz, boolean exactSuper) throws Exception
/*     */   {
/* 273 */     if (clazz == null) return false;
/*     */ 
/* 275 */     if (expr.isAnnotation())
/*     */     {
/* 277 */       String sub = expr.getOriginal().substring(1);
/* 278 */       if (AnnotationElement.isAnyAnnotationPresent(clazz, sub))
/*     */       {
/* 280 */         if (classHasMethod(clazz, hash, exactSuper)) return true;
/*     */       }
/*     */     }
/* 283 */     else if (expr.matches(clazz.getName()))
/*     */     {
/* 285 */       if (classHasMethod(clazz, hash, exactSuper)) return true;
/*     */     }
/*     */ 
/* 288 */     CtClass[] interfaces = clazz.getInterfaces();
/* 289 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 291 */       if (methodExistsInSuperClassOrInterface(hash, expr, interfaces[i], exactSuper)) return true;
/*     */     }
/* 293 */     if (clazz.isInterface()) return false;
/*     */ 
/* 295 */     return methodExistsInSuperClassOrInterface(hash, expr, clazz.getSuperclass(), exactSuper);
/*     */   }
/*     */ 
/*     */   private static boolean classHasMethod(CtClass clazz, long hash, boolean exactSuper) throws Exception
/*     */   {
/* 300 */     HashMap methods = JavassistMethodHashing.getMethodMap(clazz);
/* 301 */     CtMethod m = (CtMethod)methods.get(new Long(hash));
/* 302 */     if (m != null)
/*     */     {
/* 304 */       if (exactSuper)
/*     */       {
/* 307 */         return clazz == m.getDeclaringClass();
/*     */       }
/*     */ 
/* 311 */       return true;
/*     */     }
/*     */ 
/* 315 */     if ((clazz.isInterface()) && (!exactSuper))
/*     */     {
/* 317 */       CtClass[] interfaces = clazz.getInterfaces();
/* 318 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/* 320 */         if (classHasMethod(interfaces[i], hash, exactSuper)) return true;
/*     */       }
/*     */     }
/* 323 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean subtypeOf(CtClass clazz, ClassExpression instanceOf, Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 330 */       if (clazz == null) return false;
/* 331 */       if (instanceOf.isInstanceOfAnnotated())
/*     */       {
/* 333 */         if (clazz.isPrimitive()) return false;
/* 334 */         String sub = instanceOf.getInstanceOfAnnotation().substring(1);
/* 335 */         if (PortableAnnotationElement.isAnyAnnotationPresent(clazz, sub)) return true;
/*     */       }
/* 337 */       else if (instanceOf.matches(clazz.getName()))
/*     */       {
/* 339 */         return true;
/*     */       }
/* 341 */       CtClass[] interfaces = clazz.getInterfaces();
/* 342 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/* 344 */         if (subtypeOf(interfaces[i], instanceOf, advisor)) return true;
/*     */       }
/* 346 */       if (clazz.isInterface()) return false;
/*     */ 
/* 348 */       if (checkIntroductions(clazz, instanceOf, advisor))
/*     */       {
/* 350 */         return true;
/*     */       }
/*     */ 
/* 353 */       return subtypeOf(clazz.getSuperclass(), instanceOf, advisor);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 357 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private static boolean checkIntroductions(CtClass clazz, ClassExpression instanceOf, Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 365 */       if (advisor != null)
/*     */       {
/* 368 */         cl = SecurityActions.getContextClassLoader();
/* 369 */         ArrayList intros = advisor.getInterfaceIntroductions();
/* 370 */         if (intros.size() > 0)
/*     */         {
/* 372 */           for (itIntro = intros.iterator(); itIntro.hasNext(); )
/*     */           {
/* 374 */             InterfaceIntroduction intro = (InterfaceIntroduction)itIntro.next();
/* 375 */             String[] introductions = intro.getInterfaces();
/* 376 */             if (introductions != null)
/*     */             {
/* 378 */               for (int i = 0; i < introductions.length; i++)
/*     */               {
/* 380 */                 Class iface = cl.loadClass(introductions[i]);
/* 381 */                 if (subtypeOf(iface, instanceOf, advisor)) return true;
/*     */               }
/*     */             }
/* 384 */             ArrayList mixins = intro.getMixins();
/* 385 */             if (mixins.size() > 0)
/*     */             {
/* 387 */               for (itMixin = mixins.iterator(); itMixin.hasNext(); )
/*     */               {
/* 389 */                 InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)itMixin.next();
/* 390 */                 String[] mixinInterfaces = mixin.getInterfaces();
/* 391 */                 if (mixinInterfaces != null)
/*     */                 {
/* 393 */                   for (int i = 0; i < mixinInterfaces.length; i++)
/*     */                   {
/* 395 */                     Class iface = cl.loadClass(mixinInterfaces[i]);
/* 396 */                     if (subtypeOf(iface, instanceOf, advisor)) return true;
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*     */       ClassLoader cl;
/*     */       Iterator itIntro;
/*     */       Iterator itMixin;
/* 407 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 410 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean subtypeOf(Class clazz, ClassExpression instanceOf, Advisor advisor)
/*     */   {
/* 415 */     return MatcherStrategy.getMatcher(advisor).subtypeOf(clazz, instanceOf, advisor);
/*     */   }
/*     */ 
/*     */   public static boolean has(CtClass target, ASTMethod method, Advisor advisor)
/*     */   {
/* 420 */     return has(target, method, advisor, true);
/*     */   }
/*     */ 
/*     */   public static boolean has(CtClass target, ASTMethod method, Advisor advisor, boolean checkSuper)
/*     */   {
/*     */     try
/*     */     {
/* 427 */       CtMethod[] methods = target.getDeclaredMethods();
/* 428 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 430 */         MethodMatcher matcher = new MethodMatcher(advisor, methods[i], null);
/* 431 */         if (matcher.matches(method).booleanValue()) return true;
/*     */       }
/*     */ 
/* 434 */       if (checkSuper)
/*     */       {
/* 436 */         CtClass superClass = target.getSuperclass();
/* 437 */         if (superClass != null) return has(superClass, method, advisor, checkSuper);
/*     */       }
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 442 */       throw new RuntimeException(e);
/*     */     }
/* 444 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean has(CtClass target, ASTField field, Advisor advisor)
/*     */   {
/* 449 */     return has(target, field, advisor, true);
/*     */   }
/*     */ 
/*     */   public static boolean has(CtClass target, ASTField field, Advisor advisor, boolean checkSuper)
/*     */   {
/*     */     try
/*     */     {
/* 456 */       CtField[] fields = target.getDeclaredFields();
/* 457 */       for (int i = 0; i < fields.length; i++)
/*     */       {
/* 459 */         FieldGetMatcher matcher = new FieldGetMatcher(advisor, fields[i], null);
/* 460 */         if (((Boolean)field.jjtAccept(matcher, null)).booleanValue()) return true;
/*     */       }
/*     */ 
/* 463 */       if (checkSuper)
/*     */       {
/* 465 */         CtClass superClass = target.getSuperclass();
/* 466 */         if (superClass != null) return has(superClass, field, advisor, checkSuper);
/*     */       }
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 471 */       throw new RuntimeException(e);
/*     */     }
/* 473 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean has(CtClass target, ASTConstructor con, Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 480 */       CtConstructor[] cons = target.getDeclaredConstructors();
/* 481 */       for (int i = 0; i < cons.length; i++)
/*     */       {
/* 483 */         ConstructorMatcher matcher = new ConstructorMatcher(advisor, cons[i], null);
/* 484 */         if (matcher.matches(con).booleanValue()) return true;
/*     */       }
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 489 */       throw new RuntimeException(e);
/*     */     }
/* 491 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean has(Class target, ASTMethod method, Advisor advisor)
/*     */   {
/* 496 */     return has(target, method, advisor, true);
/*     */   }
/*     */ 
/*     */   public static boolean has(Class target, ASTMethod method, Advisor advisor, boolean checkSuper)
/*     */   {
/* 501 */     Method[] methods = advisor.getAllMethods();
/* 502 */     if (methods == null)
/* 503 */       methods = target.getDeclaredMethods();
/* 504 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 506 */       MethodMatcher matcher = new MethodMatcher(advisor, methods[i], null);
/* 507 */       if (matcher.matches(method).booleanValue()) return true;
/*     */     }
/*     */ 
/* 510 */     if (checkSuper)
/*     */     {
/* 512 */       Class superClass = target.getSuperclass();
/* 513 */       if (superClass != null) return has(superClass, method, advisor, checkSuper);
/*     */     }
/* 515 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean has(Class target, ASTField field, Advisor advisor)
/*     */   {
/* 520 */     return has(target, field, advisor, true);
/*     */   }
/*     */ 
/*     */   public static boolean has(Class target, ASTField field, Advisor advisor, boolean checkSuper)
/*     */   {
/* 525 */     Field[] fields = target.getDeclaredFields();
/* 526 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 528 */       FieldGetMatcher matcher = new FieldGetMatcher(advisor, fields[i], null);
/* 529 */       if (((Boolean)field.jjtAccept(matcher, null)).booleanValue()) return true;
/*     */     }
/*     */ 
/* 532 */     if (checkSuper)
/*     */     {
/* 534 */       Class superClass = target.getSuperclass();
/* 535 */       if (superClass != null) return has(superClass, field, advisor, checkSuper);
/*     */     }
/* 537 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean has(Class target, ASTConstructor con, Advisor advisor)
/*     */   {
/* 542 */     Constructor[] cons = target.getDeclaredConstructors();
/* 543 */     for (int i = 0; i < cons.length; i++)
/*     */     {
/* 545 */       ConstructorMatcher matcher = new ConstructorMatcher(advisor, cons[i], null);
/* 546 */       if (matcher.matches(con).booleanValue()) return true;
/*     */     }
/* 548 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean matchesTypedef(CtClass clazz, ClassExpression classExpr, Advisor advisor)
/*     */   {
/* 553 */     String original = classExpr.getOriginal();
/* 554 */     String typedefName = original.substring("$typedef{".length(), original.lastIndexOf("}"));
/* 555 */     AspectManager manager = advisor != null ? advisor.getManager() : AspectManager.instance();
/* 556 */     Typedef typedef = manager.getTypedef(typedefName);
/* 557 */     if (typedef == null) return false;
/* 558 */     return typedef.matches(advisor, clazz);
/*     */   }
/*     */ 
/*     */   public static boolean matchesTypedef(Class clazz, ClassExpression classExpr, Advisor advisor)
/*     */   {
/* 563 */     String original = classExpr.getOriginal();
/* 564 */     String typedefName = original.substring("$typedef{".length(), original.lastIndexOf("}"));
/* 565 */     AspectManager manager = advisor != null ? advisor.getManager() : AspectManager.instance();
/* 566 */     Typedef typedef = manager.getTypedef(typedefName);
/* 567 */     if (typedef == null) return false;
/* 568 */     return typedef.matches(advisor, clazz);
/*     */   }
/*     */ 
/*     */   public static boolean matchModifiers(ASTAttribute need, int have)
/*     */   {
/* 573 */     if ((Modifier.isAbstract(need.attribute)) && (need.not)) return !Modifier.isAbstract(have);
/* 574 */     if ((Modifier.isAbstract(need.attribute)) && (!need.not)) return Modifier.isAbstract(have);
/* 575 */     if ((Modifier.isFinal(need.attribute)) && (need.not)) return !Modifier.isFinal(have);
/* 576 */     if ((Modifier.isFinal(need.attribute)) && (!need.not)) return Modifier.isFinal(have);
/* 577 */     if ((Modifier.isInterface(need.attribute)) && (need.not)) return !Modifier.isInterface(have);
/* 578 */     if ((Modifier.isInterface(need.attribute)) && (!need.not)) return Modifier.isInterface(have);
/* 579 */     if ((Modifier.isNative(need.attribute)) && (need.not)) return !Modifier.isNative(have);
/* 580 */     if ((Modifier.isNative(need.attribute)) && (!need.not)) return Modifier.isNative(have);
/* 581 */     if ((Modifier.isPrivate(need.attribute)) && (need.not)) return !Modifier.isPrivate(have);
/* 582 */     if ((Modifier.isPrivate(need.attribute)) && (!need.not)) return Modifier.isPrivate(have);
/* 583 */     if ((Modifier.isProtected(need.attribute)) && (need.not)) return !Modifier.isProtected(have);
/* 584 */     if ((Modifier.isProtected(need.attribute)) && (!need.not)) return Modifier.isProtected(have);
/* 585 */     if ((Modifier.isPublic(need.attribute)) && (need.not)) return !Modifier.isPublic(have);
/* 586 */     if ((Modifier.isPublic(need.attribute)) && (!need.not)) return Modifier.isPublic(have);
/* 587 */     if ((Modifier.isStatic(need.attribute)) && (need.not)) return !Modifier.isStatic(have);
/* 588 */     if ((Modifier.isStatic(need.attribute)) && (!need.not)) return Modifier.isStatic(have);
/* 589 */     if ((Modifier.isStrict(need.attribute)) && (need.not)) return !Modifier.isStrict(have);
/* 590 */     if ((Modifier.isStrict(need.attribute)) && (!need.not)) return Modifier.isStrict(have);
/* 591 */     if ((Modifier.isSynchronized(need.attribute)) && (need.not)) return !Modifier.isSynchronized(have);
/* 592 */     if ((Modifier.isSynchronized(need.attribute)) && (!need.not)) return Modifier.isSynchronized(have);
/* 593 */     if ((Modifier.isTransient(need.attribute)) && (need.not)) return !Modifier.isTransient(have);
/* 594 */     if ((Modifier.isTransient(need.attribute)) && (!need.not)) return Modifier.isTransient(have);
/* 595 */     if ((Modifier.isVolatile(need.attribute)) && (need.not)) return !Modifier.isVolatile(have);
/* 596 */     if ((Modifier.isVolatile(need.attribute)) && (!need.not)) return Modifier.isVolatile(have);
/*     */ 
/* 598 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean matchExceptions(ArrayList nodeExceptions, CtClass[] foundExceptions)
/*     */   {
/* 607 */     if (nodeExceptions.size() > foundExceptions.length) return false;
/* 608 */     for (Iterator it = nodeExceptions.iterator(); it.hasNext(); )
/*     */     {
/* 610 */       boolean found = false;
/* 611 */       ASTException ex = (ASTException)it.next();
/* 612 */       for (int i = 0; i < foundExceptions.length; i++)
/*     */       {
/* 614 */         if (!ex.getType().matches(foundExceptions[i].getName()))
/*     */           continue;
/* 616 */         found = true;
/* 617 */         break;
/*     */       }
/*     */ 
/* 621 */       if (!found) return false;
/*     */     }
/*     */ 
/* 624 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean matchExceptions(ArrayList nodeExceptions, Class[] foundExceptions)
/*     */   {
/* 633 */     if (nodeExceptions.size() > foundExceptions.length) return false;
/* 634 */     for (Iterator it = nodeExceptions.iterator(); it.hasNext(); )
/*     */     {
/* 636 */       boolean found = false;
/* 637 */       ASTException ex = (ASTException)it.next();
/* 638 */       for (int i = 0; i < foundExceptions.length; i++)
/*     */       {
/* 640 */         if (!ex.getType().matches(foundExceptions[i].getName()))
/*     */           continue;
/* 642 */         found = true;
/* 643 */         break;
/*     */       }
/*     */ 
/* 647 */       if (!found) return false;
/*     */     }
/*     */ 
/* 650 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean matchesParameters(Advisor advisor, ASTMethod node, CtMethod ctMethod)
/*     */   {
/* 655 */     if (node.isAnyParameters()) return true;
/*     */     try
/*     */     {
/* 658 */       return matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), node.getParameters(), ctMethod.getParameterTypes());
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/* 663 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static boolean matchesParameters(Advisor advisor, ASTConstructor node, CtConstructor ctConstructor)
/*     */   {
/* 669 */     int i = 0;
/* 670 */     if (node.isAnyParameters()) return true;
/*     */     try
/*     */     {
/* 673 */       CtClass[] params = ctConstructor.getParameterTypes();
/* 674 */       return matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), node.getParameters(), params);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/* 679 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static boolean matchesParameters(Advisor advisor, ASTMethod node, Method method)
/*     */   {
/* 685 */     if (node.isAnyParameters()) return true;
/* 686 */     return matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), node.getParameters(), method.getParameterTypes());
/*     */   }
/*     */ 
/*     */   public static boolean matchesParameters(Advisor advisor, ASTConstructor node, Constructor con)
/*     */   {
/* 691 */     if (node.isAnyParameters()) return true;
/*     */ 
/* 693 */     Class[] params = con.getParameterTypes();
/*     */ 
/* 695 */     return matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), node.getParameters(), con.getParameterTypes());
/*     */   }
/*     */ 
/*     */   private static boolean matchesParameters(Advisor advisor, boolean hasAnyZeroOrMoreParameters, ArrayList parameters, Class[] params)
/*     */   {
/* 700 */     RefParameterMatcher matcher = new RefParameterMatcher(advisor, parameters, params);
/* 701 */     return matcher.matches();
/*     */   }
/*     */ 
/*     */   private static boolean matchesParameters(Advisor advisor, boolean hasAnyZeroOrMoreParameters, ArrayList parameters, CtClass[] params)
/*     */   {
/* 706 */     CtParameterMatcher matcher = new CtParameterMatcher(advisor, parameters, params);
/* 707 */     return matcher.matches();
/*     */   }
/*     */ 
/*     */   private static class CtParameterMatcher extends Util.ParameterMatcher
/*     */   {
/*     */     CtClass[] params;
/*     */ 
/*     */     public CtParameterMatcher(Advisor advisor, ArrayList parameters, CtClass[] params)
/*     */     {
/* 845 */       super(parameters, params);
/* 846 */       this.params = params;
/*     */     }
/*     */ 
/*     */     boolean doMatch(int astIndex, int actualIndex)
/*     */     {
/* 851 */       ASTParameter ast = (ASTParameter)this.astParameters.get(astIndex);
/* 852 */       ClassExpression exp = ast.getType();
/* 853 */       return Util.matchesClassExpr(exp, this.params[actualIndex], this.advisor);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class RefParameterMatcher extends Util.ParameterMatcher
/*     */   {
/*     */     Class[] params;
/*     */ 
/*     */     public RefParameterMatcher(Advisor advisor, ArrayList parameters, Class[] params)
/*     */     {
/* 817 */       super(parameters, params);
/* 818 */       this.params = params;
/*     */     }
/*     */ 
/*     */     boolean doMatch(int astIndex, int actualIndex)
/*     */     {
/* 823 */       ASTParameter ast = (ASTParameter)this.astParameters.get(astIndex);
/* 824 */       ClassExpression exp = ast.getType();
/*     */ 
/* 826 */       if (exp.isSimple())
/*     */       {
/* 828 */         String asString = ClassExpression.simpleType(this.params[actualIndex]);
/* 829 */         if (!exp.matches(asString)) return false;
/*     */ 
/*     */       }
/* 833 */       else if (!Util.matchesClassExpr(exp, this.params[actualIndex], this.advisor)) { return false;
/*     */       }
/*     */ 
/* 836 */       return true;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ParameterMatcher
/*     */   {
/*     */     Advisor advisor;
/*     */     ArrayList astParameters;
/*     */     final long paramsLength;
/*     */     int asti;
/*     */     int actuali;
/*     */ 
/*     */     ParameterMatcher(Advisor advisor, ArrayList parameters, Object[] params)
/*     */     {
/* 720 */       this.advisor = advisor;
/* 721 */       this.astParameters = parameters;
/* 722 */       this.paramsLength = params.length;
/*     */     }
/*     */ 
/*     */     boolean matches()
/*     */     {
/* 727 */       return matches(0, 0);
/*     */     }
/*     */ 
/*     */     private boolean matches(int ast, int actual)
/*     */     {
/* 732 */       boolean match = true;
/* 733 */       for (; (match) && (ast < this.astParameters.size()) && (actual < this.paramsLength); ast++)
/*     */       {
/* 735 */         if (isAnyZeroOrMoreParameters(ast))
/*     */         {
/* 737 */           this.asti = ast;
/* 738 */           this.actuali = actual;
/* 739 */           match = wildcard();
/* 740 */           ast = this.asti;
/* 741 */           actual = this.actuali;
/* 742 */           ast--;
/*     */         }
/*     */         else
/*     */         {
/* 746 */           match = doMatch(ast, actual);
/* 747 */           actual++;
/*     */         }
/*     */       }
/*     */ 
/* 751 */       while ((match) && (ast < this.astParameters.size()) && (isAnyZeroOrMoreParameters(ast)))
/*     */       {
/* 753 */         ast++;
/*     */       }
/* 755 */       return (match) && (ast == this.astParameters.size()) && (this.paramsLength == actual);
/*     */     }
/*     */ 
/*     */     private boolean isAnyZeroOrMoreParameters(int index)
/*     */     {
/* 760 */       return ((ASTParameter)this.astParameters.get(index)).isAnyZeroOrMoreParameters();
/*     */     }
/*     */ 
/*     */     boolean doMatch(int astIndex, int actualIndex)
/*     */     {
/* 766 */       return false;
/*     */     }
/*     */ 
/*     */     private boolean wildcard()
/*     */     {
/* 771 */       boolean match = true;
/* 772 */       this.asti += 1;
/*     */ 
/* 774 */       while ((this.actuali < this.paramsLength) && (this.asti < this.astParameters.size()) && (isAnyZeroOrMoreParameters(this.asti)))
/*     */       {
/* 776 */         this.asti += 1;
/*     */       }
/*     */ 
/* 779 */       while ((this.asti < this.astParameters.size()) && (isAnyZeroOrMoreParameters(this.asti)))
/*     */       {
/* 781 */         this.asti += 1;
/*     */       }
/*     */ 
/* 784 */       if ((this.actuali == this.paramsLength) && (this.asti < this.astParameters.size()))
/* 785 */         return false;
/* 786 */       if ((this.actuali == this.paramsLength) && (this.asti == this.astParameters.size())) {
/* 787 */         return true;
/*     */       }
/*     */ 
/* 790 */       if (!matches(this.asti, this.actuali))
/*     */       {
/*     */         do
/*     */         {
/* 794 */           this.actuali += 1;
/* 795 */           while ((this.actuali < this.paramsLength) && (this.asti < this.astParameters.size()) && (!doMatch(this.asti, this.actuali)))
/*     */           {
/* 797 */             this.actuali += 1;
/*     */           }
/*     */         }
/* 800 */         while ((this.actuali < this.paramsLength) && (!(match = matches(this.asti, this.actuali))));
/*     */       }
/*     */ 
/* 803 */       if ((this.actuali == this.paramsLength) && (this.asti == this.astParameters.size()))
/*     */       {
/* 805 */         match = true;
/*     */       }
/* 807 */       return match;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.Util
 * JD-Core Version:    0.6.0
 */