/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ 
/*     */ public class ProxyMatcherStrategy extends MatcherStrategy
/*     */ {
/*     */   protected boolean checkIntroductions(Class clazz, ClassExpression instanceOf, Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/*  52 */       if (advisor != null)
/*     */       {
/*  55 */         cl = SecurityActions.getContextClassLoader();
/*  56 */         ArrayList intros = advisor.getInterfaceIntroductions();
/*  57 */         if (intros.size() > 0)
/*     */         {
/*  59 */           for (itIntro = intros.iterator(); itIntro.hasNext(); )
/*     */           {
/*  61 */             InterfaceIntroduction intro = (InterfaceIntroduction)itIntro.next();
/*  62 */             String[] introductions = intro.getInterfaces();
/*  63 */             if (introductions != null)
/*     */             {
/*  65 */               for (int i = 0; i < introductions.length; i++)
/*     */               {
/*  67 */                 Class iface = cl.loadClass(introductions[i]);
/*  68 */                 if (subtypeOf(iface, instanceOf, advisor)) return true;
/*     */               }
/*     */             }
/*  71 */             ArrayList mixins = intro.getMixins();
/*  72 */             if (mixins.size() > 0)
/*     */             {
/*  74 */               for (itMixin = mixins.iterator(); itMixin.hasNext(); )
/*     */               {
/*  76 */                 InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)itMixin.next();
/*  77 */                 String[] mixinInterfaces = mixin.getInterfaces();
/*  78 */                 if (mixinInterfaces != null)
/*     */                 {
/*  80 */                   for (int i = 0; i < mixinInterfaces.length; i++)
/*     */                   {
/*  82 */                     Class iface = cl.loadClass(mixinInterfaces[i]);
/*  83 */                     if (subtypeOf(iface, instanceOf, advisor)) return true;
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*     */       ClassLoader cl;
/*     */       Iterator itIntro;
/*     */       Iterator itMixin;
/*  94 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/*  97 */     return false;
/*     */   }
/*     */ 
/*     */   public Class getDeclaringClass(Advisor advisor, Method m)
/*     */   {
/* 106 */     Class methodClass = m.getDeclaringClass();
/* 107 */     Class advisorClass = advisor.getClazz();
/*     */ 
/* 109 */     if ((advisorClass != null) && (methodClass.isInterface()))
/*     */     {
/* 111 */       return advisorClass;
/*     */     }
/* 113 */     return methodClass;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ProxyMatcherStrategy
 * JD-Core Version:    0.6.0
 */