/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTAll;
/*     */ import org.jboss.aop.pointcut.ast.ASTAllParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTAnd;
/*     */ import org.jboss.aop.pointcut.ast.ASTAndCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTComposite;
/*     */ import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstruction;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTException;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecutionOnly;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTFieldExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTGet;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTNot;
/*     */ import org.jboss.aop.pointcut.ast.ASTNotCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTOr;
/*     */ import org.jboss.aop.pointcut.ast.ASTOrCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTPointcut;
/*     */ import org.jboss.aop.pointcut.ast.ASTSet;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTSub;
/*     */ import org.jboss.aop.pointcut.ast.ASTSubCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ import org.jboss.aop.pointcut.ast.PointcutExpressionParserVisitor;
/*     */ import org.jboss.aop.pointcut.ast.SimpleNode;
/*     */ 
/*     */ public class PointcutStats
/*     */   implements PointcutExpressionParserVisitor
/*     */ {
/*     */   protected ASTStart start;
/*     */   protected AspectManager manager;
/*  74 */   protected boolean execution = false;
/*  75 */   protected boolean construction = false;
/*  76 */   protected boolean call = false;
/*  77 */   protected boolean within = false;
/*  78 */   protected boolean get = false;
/*  79 */   protected boolean set = false;
/*  80 */   protected boolean withincode = false;
/*     */ 
/*     */   public PointcutStats(ASTStart start, AspectManager manager)
/*     */   {
/*  85 */     this.start = start;
/*  86 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public boolean isExecution()
/*     */   {
/*  91 */     return this.execution;
/*     */   }
/*     */ 
/*     */   public boolean isConstruction()
/*     */   {
/*  96 */     return this.construction;
/*     */   }
/*     */ 
/*     */   public boolean isCall()
/*     */   {
/* 101 */     return this.call;
/*     */   }
/*     */ 
/*     */   public boolean isWithin()
/*     */   {
/* 106 */     return this.within;
/*     */   }
/*     */ 
/*     */   public boolean isGet()
/*     */   {
/* 111 */     return this.get;
/*     */   }
/*     */ 
/*     */   public boolean isSet()
/*     */   {
/* 116 */     return this.set;
/*     */   }
/*     */ 
/*     */   public boolean isWithincode()
/*     */   {
/* 121 */     return this.withincode;
/*     */   }
/*     */ 
/*     */   public boolean matches()
/*     */   {
/* 127 */     return ((Boolean)visit(this.start, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/* 132 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecutionOnly node, Object data)
/*     */   {
/* 137 */     throw new RuntimeException("SHOULD NEVER BE CALLED!");
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBoolean node, Object data)
/*     */   {
/* 142 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTComposite node, Object data)
/*     */   {
/* 147 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNot node, Object data)
/*     */   {
/* 153 */     Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
/* 154 */     boolean val = bool.booleanValue();
/* 155 */     return val ? Boolean.FALSE : Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSub node, Object data)
/*     */   {
/* 160 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 162 */       data = node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 164 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnd node, Object left)
/*     */   {
/* 169 */     Node andChild = node.jjtGetChild(0);
/* 170 */     andChild.jjtAccept(this, Boolean.FALSE);
/* 171 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOr node, Object left)
/*     */   {
/* 176 */     Node orChild = node.jjtGetChild(0);
/* 177 */     orChild.jjtAccept(this, Boolean.FALSE);
/* 178 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   private void setAllTrue()
/*     */   {
/* 184 */     this.execution = true;
/* 185 */     this.call = true;
/* 186 */     this.within = true;
/* 187 */     this.get = true;
/* 188 */     this.set = true;
/* 189 */     this.withincode = true;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTPointcut node, Object data)
/*     */   {
/* 194 */     if (this.manager == null)
/*     */     {
/* 196 */       setAllTrue();
/*     */     }
/* 198 */     Pointcut p = this.manager.getPointcut(node.getPointcutName());
/* 199 */     if ((p instanceof PointcutExpression))
/*     */     {
/* 201 */       PointcutExpression expr = (PointcutExpression)p;
/* 202 */       PointcutStats stats = expr.getStats();
/* 203 */       if (stats != null)
/*     */       {
/* 205 */         this.execution |= stats.isExecution();
/* 206 */         this.call |= stats.isCall();
/* 207 */         this.within |= stats.isWithin();
/* 208 */         this.get |= stats.isGet();
/* 209 */         this.set |= stats.isSet();
/* 210 */         this.withincode |= stats.isWithincode();
/*     */       }
/*     */       else
/*     */       {
/* 214 */         setAllTrue();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 219 */       setAllTrue();
/*     */     }
/*     */ 
/* 222 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/* 227 */     this.execution = true;
/* 228 */     this.get = true;
/* 229 */     this.set = true;
/* 230 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowExpression node, Object data)
/*     */   {
/* 235 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/* 241 */     this.call = true;
/* 242 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/* 247 */     this.within = true;
/* 248 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 253 */     this.withincode = true;
/* 254 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecution node, Object data)
/*     */   {
/* 259 */     this.execution = true;
/* 260 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstruction node, Object data)
/*     */   {
/* 265 */     this.construction = true;
/* 266 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTGet node, Object data)
/*     */   {
/* 271 */     this.get = true;
/* 272 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSet node, Object data)
/*     */   {
/* 277 */     this.set = true;
/* 278 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTFieldExecution node, Object data)
/*     */   {
/* 283 */     this.get = (this.set = 1);
/* 284 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/* 292 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowBoolean node, Object data)
/*     */   {
/* 297 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNotCFlow node, Object data)
/*     */   {
/* 302 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCompositeCFlow node, Object data)
/*     */   {
/* 307 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSubCFlow node, Object data)
/*     */   {
/* 312 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAndCFlow node, Object data)
/*     */   {
/* 317 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrCFlow node, Object data)
/*     */   {
/* 322 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlow node, Object data)
/*     */   {
/* 327 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/* 332 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAttribute node, Object data)
/*     */   {
/* 337 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 342 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 347 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAllParameter node, Object data)
/*     */   {
/* 352 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/* 357 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTException node, Object data)
/*     */   {
/* 362 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/* 367 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 372 */     return Boolean.FALSE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.PointcutStats
 * JD-Core Version:    0.6.0
 */