/*    */ package org.jboss.aop.pointcut;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.annotation.AnnotationElement;
/*    */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*    */ import org.jboss.aop.proxy.container.ClassProxyContainer;
/*    */ import org.jboss.aop.util.logging.AOPLogger;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public abstract class MatcherStrategy
/*    */ {
/* 42 */   private static final Logger logger = AOPLogger.getLogger(MatcherStrategy.class);
/*    */ 
/* 44 */   private static final MatcherStrategy ADVISOR_MATCHER_STRATEGY = new AdvisorMatcherStrategy();
/* 45 */   private static final MatcherStrategy PROXY_MATCHER_STRATEGY = new ProxyMatcherStrategy();
/*    */ 
/*    */   public static MatcherStrategy getMatcher(Advisor advisor)
/*    */   {
/* 49 */     if ((advisor instanceof ClassProxyContainer))
/*    */     {
/* 51 */       return PROXY_MATCHER_STRATEGY;
/*    */     }
/*    */ 
/* 54 */     return ADVISOR_MATCHER_STRATEGY;
/*    */   }
/*    */ 
/*    */   public boolean subtypeOf(Class clazz, ClassExpression instanceOf, Advisor advisor)
/*    */   {
/* 60 */     if (clazz == null) return false;
/* 61 */     if (instanceOf.isInstanceOfAnnotated())
/*    */     {
/* 63 */       String sub = instanceOf.getInstanceOfAnnotation().substring(1);
/*    */       try
/*    */       {
/* 67 */         Class annotation = SecurityActions.getContextClassLoader().loadClass(sub);
/* 68 */         if (AnnotationElement.getAnyAnnotation(clazz, annotation) != null)
/*    */         {
/* 70 */           return true;
/*    */         }
/*    */       }
/*    */       catch (ClassNotFoundException e)
/*    */       {
/* 75 */         if (AspectManager.verbose)
/*    */         {
/* 77 */           logger.warn("The annotation @" + sub + " referenced in one of your pointcut expressions can not be found");
/*    */         }
/* 79 */         return false;
/*    */       }
/*    */     }
/* 82 */     else if (instanceOf.matches(clazz.getName()))
/*    */     {
/* 84 */       return true;
/*    */     }
/*    */ 
/* 87 */     Class[] interfaces = clazz.getInterfaces();
/* 88 */     for (int i = 0; i < interfaces.length; i++)
/*    */     {
/* 90 */       if (subtypeOf(interfaces[i], instanceOf, advisor)) return true;
/*    */     }
/* 92 */     if (clazz.isInterface()) return false;
/*    */ 
/* 94 */     if (checkIntroductions(clazz, instanceOf, advisor))
/*    */     {
/* 96 */       return true;
/*    */     }
/*    */ 
/* 99 */     return subtypeOf(clazz.getSuperclass(), instanceOf, advisor);
/*    */   }
/*    */ 
/*    */   protected abstract boolean checkIntroductions(Class paramClass, ClassExpression paramClassExpression, Advisor paramAdvisor);
/*    */ 
/*    */   public abstract Class getDeclaringClass(Advisor paramAdvisor, Method paramMethod);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.MatcherStrategy
 * JD-Core Version:    0.6.0
 */