/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTAll;
/*     */ import org.jboss.aop.pointcut.ast.ASTAllParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTAnd;
/*     */ import org.jboss.aop.pointcut.ast.ASTAndCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTComposite;
/*     */ import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstruction;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTException;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecutionOnly;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTFieldExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTGet;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTNot;
/*     */ import org.jboss.aop.pointcut.ast.ASTNotCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTOr;
/*     */ import org.jboss.aop.pointcut.ast.ASTOrCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTPointcut;
/*     */ import org.jboss.aop.pointcut.ast.ASTSet;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTSub;
/*     */ import org.jboss.aop.pointcut.ast.ASTSubCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ import org.jboss.aop.pointcut.ast.PointcutExpressionParserVisitor;
/*     */ import org.jboss.aop.pointcut.ast.SimpleNode;
/*     */ 
/*     */ public abstract class MatcherHelper
/*     */   implements PointcutExpressionParserVisitor
/*     */ {
/*     */   protected ASTStart start;
/*     */   protected AspectManager manager;
/*     */ 
/*     */   protected MatcherHelper(ASTStart start, AspectManager manager)
/*     */   {
/*  77 */     this.start = start;
/*  78 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public boolean matches()
/*     */   {
/*  83 */     boolean matches = ((Boolean)visit(this.start, null)).booleanValue();
/*  84 */     return matches;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/*  89 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecutionOnly node, Object data)
/*     */   {
/*  94 */     throw new RuntimeException("SHOULD NEVER BE CALLED!");
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBoolean node, Object data)
/*     */   {
/*  99 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTComposite node, Object data)
/*     */   {
/* 104 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNot node, Object data)
/*     */   {
/* 110 */     Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
/* 111 */     boolean val = bool.booleanValue();
/* 112 */     return val ? Boolean.FALSE : Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSub node, Object data)
/*     */   {
/* 117 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 119 */       data = node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 121 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnd node, Object left)
/*     */   {
/* 126 */     Node andChild = node.jjtGetChild(0);
/* 127 */     boolean val = ((Boolean)left).booleanValue();
/* 128 */     return new Boolean((val) && (((Boolean)andChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOr node, Object left)
/*     */   {
/* 133 */     Node orChild = node.jjtGetChild(0);
/* 134 */     boolean val = ((Boolean)left).booleanValue();
/* 135 */     return new Boolean((val) || (((Boolean)orChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   protected abstract Boolean resolvePointcut(Pointcut paramPointcut);
/*     */ 
/*     */   public Object visit(ASTPointcut node, Object data) {
/* 142 */     Pointcut p = this.manager.getPointcut(node.getPointcutName());
/* 143 */     if (p == null) throw new RuntimeException("Unable to resolve pointcut reference: " + node.getPointcutName());
/* 144 */     return resolvePointcut(p);
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/* 150 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/* 155 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowExpression node, Object data)
/*     */   {
/* 160 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowBoolean node, Object data)
/*     */   {
/* 165 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNotCFlow node, Object data)
/*     */   {
/* 170 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCompositeCFlow node, Object data)
/*     */   {
/* 175 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSubCFlow node, Object data)
/*     */   {
/* 180 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAndCFlow node, Object data)
/*     */   {
/* 185 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrCFlow node, Object data)
/*     */   {
/* 190 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlow node, Object data)
/*     */   {
/* 195 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/* 200 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/* 205 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 210 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecution node, Object data)
/*     */   {
/* 215 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstruction node, Object data)
/*     */   {
/* 220 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTGet node, Object data)
/*     */   {
/* 225 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSet node, Object data)
/*     */   {
/* 230 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/* 235 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAttribute node, Object data)
/*     */   {
/* 240 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 245 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 250 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAllParameter node, Object data)
/*     */   {
/* 255 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/* 260 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTException node, Object data)
/*     */   {
/* 265 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTFieldExecution node, Object data)
/*     */   {
/* 270 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/* 275 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 280 */     return Boolean.FALSE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.MatcherHelper
 * JD-Core Version:    0.6.0
 */