/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstruction;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class ConstructionMatcher extends ConstructorMatcher
/*     */ {
/*     */   public ConstructionMatcher(Advisor advisor, CtConstructor con, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  47 */     super(advisor, con, start);
/*     */   }
/*     */ 
/*     */   public ConstructionMatcher(Advisor advisor, Constructor con, ASTStart start)
/*     */   {
/*  52 */     super(advisor, con, start);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstruction node, Object data)
/*     */   {
/*  57 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*  62 */     Node n = node.jjtGetChild(0);
/*  63 */     if ((n instanceof ASTMethod))
/*     */     {
/*  65 */       if (this.ctCon != null)
/*     */       {
/*  67 */         return new Boolean(Util.has(this.ctCon.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/*  71 */       return new Boolean(Util.has(this.refCon.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/*  77 */     if (this.ctCon != null)
/*     */     {
/*  79 */       return new Boolean(Util.has(this.ctCon.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */     }
/*     */ 
/*  83 */     return new Boolean(Util.has(this.refCon.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/*  91 */     ASTField f = (ASTField)node.jjtGetChild(0);
/*  92 */     if (this.ctCon != null)
/*     */     {
/*  94 */       return new Boolean(Util.has(this.ctCon.getDeclaringClass(), f, this.advisor));
/*     */     }
/*     */ 
/*  98 */     return new Boolean(Util.has(this.refCon.getDeclaringClass(), f, this.advisor));
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*     */     try
/*     */     {
/* 107 */       if (this.refCon != null) return new Boolean(p.matchesConstruction(this.advisor, this.refCon));
/* 108 */       return new Boolean(p.matchesConstruction(this.advisor, this.ctCon));
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 112 */     throw new RuntimeException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ConstructionMatcher
 * JD-Core Version:    0.6.0
 */