/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.IdentifierExpression;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
/*     */ import org.jboss.aop.pointcut.ast.SimpleNode;
/*     */ 
/*     */ public class CFlow
/*     */ {
/*  44 */   public static int NOT_FOUND = -2;
/*     */   private String original;
/*     */   private SimpleNode point;
/*     */   private boolean not;
/*     */ 
/*     */   public CFlow(String expr, boolean not)
/*     */   {
/*  52 */     this.original = expr;
/*  53 */     expr = "execution(" + expr + ")";
/*  54 */     ASTExecution exc = null;
/*     */     try
/*     */     {
/*  57 */       exc = new PointcutExpressionParser(new StringReader(expr)).execution();
/*     */     }
/*     */     catch (ParseException e)
/*     */     {
/*  61 */       throw new RuntimeException("Illegal cflow expression: " + this.original, e);
/*     */     }
/*  63 */     this.point = ((SimpleNode)exc.jjtGetChild(0));
/*  64 */     this.not = not;
/*     */   }
/*     */ 
/*     */   public int matches(StackTraceElement[] stack, int index)
/*     */   {
/*  69 */     int found = NOT_FOUND;
/*  70 */     if ((this.point instanceof ASTMethod))
/*     */     {
/*  72 */       found = matches((ASTMethod)this.point, stack, index);
/*     */     }
/*     */     else
/*     */     {
/*  76 */       found = matches((ASTConstructor)this.point, stack, index);
/*     */     }
/*  78 */     if ((found == NOT_FOUND) && (this.not)) return index;
/*  79 */     if ((found > NOT_FOUND) && (this.not)) return NOT_FOUND;
/*  80 */     return found;
/*     */   }
/*     */ 
/*     */   private int matches(ASTMethod method, StackTraceElement[] stack, int index)
/*     */   {
/*  85 */     for (int i = index; i >= 0; i--)
/*     */     {
/*  87 */       ClassExpression expr = method.getClazz();
/*  88 */       if (!matchesClass(expr, stack[i]))
/*     */         continue;
/*  90 */       if (method.getMethodIdentifier().matches(stack[i].getMethodName()))
/*     */       {
/*  92 */         return i - 1;
/*     */       }
/*     */     }
/*  95 */     return -2;
/*     */   }
/*     */ 
/*     */   private int matches(ASTConstructor con, StackTraceElement[] stack, int index)
/*     */   {
/* 100 */     for (int i = index; i >= 0; i--)
/*     */     {
/* 102 */       ClassExpression expr = con.getClazz();
/* 103 */       if (!matchesClass(expr, stack[i]))
/*     */         continue;
/* 105 */       if (stack[i].getMethodName().equals("<init>"))
/*     */       {
/* 107 */         return i - 1;
/*     */       }
/*     */     }
/* 110 */     return -2;
/*     */   }
/*     */ 
/*     */   private boolean matchesClass(ClassExpression expr, StackTraceElement element)
/*     */   {
/* 115 */     if (expr.isSimple())
/*     */     {
/* 117 */       if (!expr.matches(element.getClassName()))
/*     */       {
/* 119 */         return false;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 125 */       Class clazz = loadClass(element.getClassName());
/*     */ 
/* 127 */       if (Untransformable.class.isAssignableFrom(clazz))
/*     */       {
/* 130 */         return false;
/*     */       }
/* 132 */       if (!Util.matchesClassExpr(expr, clazz))
/*     */       {
/* 134 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 138 */     return true;
/*     */   }
/*     */ 
/*     */   private Class loadClass(String name)
/*     */   {
/* 143 */     return SecurityActions.loadClass(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.CFlow
 * JD-Core Version:    0.6.0
 */