/*    */ package org.jboss.aop.microcontainer.lazy;
/*    */ 
/*    */ import java.util.Set;
/*    */ import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
/*    */ import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.plugins.config.Configurator;
/*    */ import org.jboss.kernel.plugins.lazy.AbstractLazyInitializer;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.metadata.spi.MetaData;
/*    */ import org.jboss.metadata.spi.stack.MetaDataStack;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ 
/*    */ public class JBossAOPLazyInitializer extends AbstractLazyInitializer
/*    */ {
/*    */   public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces)
/*    */     throws Throwable
/*    */   {
/* 45 */     KernelControllerContext context = getKernelControllerContext(kernel, bean);
/* 46 */     BeanInfo beanInfo = context.getBeanInfo();
/* 47 */     if (beanInfo == null) {
/* 48 */       throw new IllegalArgumentException("Cannot proxy factory beans.");
/*    */     }
/* 50 */     MetaData metaData = MetaDataStack.peek();
/* 51 */     MetaDataStack.mask();
/*    */     try
/*    */     {
/* 54 */       AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 55 */       params.setMetaData(metaData);
/* 56 */       if (exposeClass)
/*    */       {
/* 58 */         params.setProxiedClass(beanInfo.getClassInfo().getType());
/*    */       }
/* 60 */       if ((interfaces != null) && (!interfaces.isEmpty()))
/*    */       {
/* 62 */         ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 63 */         params.setInterfaces(getClasses(kernel.getConfigurator(), interfaces, cl));
/*    */       }
/* 65 */       GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
/* 66 */       Object localObject1 = factory.createAdvisedProxy(params);
/*    */       return localObject1; } finally { MetaDataStack.unmask(); } throw localObject2;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.lazy.JBossAOPLazyInitializer
 * JD-Core Version:    0.6.0
 */