/*     */ package org.jboss.aop.microcontainer.junit;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.test.kernel.junit.MicrocontainerTestDelegate;
/*     */ 
/*     */ public class AOPMicrocontainerTestDelegate extends MicrocontainerTestDelegate
/*     */ {
/*  41 */   private static final CopyOnWriteArrayList urls = new CopyOnWriteArrayList();
/*     */ 
/*     */   public AOPMicrocontainerTestDelegate(Class clazz)
/*     */     throws Exception
/*     */   {
/*  51 */     super(clazz);
/*     */   }
/*     */ 
/*     */   public void setUp() throws Exception
/*     */   {
/*  56 */     super.setUp();
/*  57 */     this.log.debug("Security enabled: " + this.enableSecurity);
/*     */   }
/*     */ 
/*     */   protected void deploy()
/*     */     throws Exception
/*     */   {
/*  64 */     String testName = this.clazz.getName();
/*  65 */     testName = testName.replace('.', '/') + "-aop.xml";
/*  66 */     URL url = this.clazz.getClassLoader().getResource(testName);
/*  67 */     if (url != null)
/*  68 */       deployAOP(url);
/*     */     else {
/*  70 */       this.log.debug("No test specific deployment " + testName);
/*     */     }
/*  72 */     super.deploy();
/*     */   }
/*     */ 
/*     */   protected void undeploy()
/*     */   {
/*  78 */     super.undeploy();
/*  79 */     for (Iterator i = urls.iterator(); i.hasNext(); )
/*     */     {
/*  81 */       URL url = (URL)i.next();
/*  82 */       undeployAOP(url);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deployAOP(URL url)
/*     */     throws Exception
/*     */   {
/*  94 */     this.log.debug("Deploying " + url);
/*  95 */     urls.add(url);
/*  96 */     AspectXmlLoader.deployXML(url);
/*     */   }
/*     */ 
/*     */   protected void undeployAOP(URL url)
/*     */   {
/*     */     try
/*     */     {
/* 108 */       this.log.debug("Undeploying " + url);
/* 109 */       urls.remove(url);
/* 110 */       AspectXmlLoader.undeployXML(url);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 114 */       this.log.warn("Ignored error undeploying " + url, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.junit.AOPMicrocontainerTestDelegate
 * JD-Core Version:    0.6.0
 */