/*     */ package org.jboss.aop.microcontainer.integration;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*     */ import org.jboss.aop.microcontainer.beans.AspectManagerFactory;
/*     */ import org.jboss.aop.proxy.container.AOPProxyFactory;
/*     */ import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
/*     */ import org.jboss.aop.proxy.container.ContainerCache;
/*     */ import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
/*     */ import org.jboss.joinpoint.plugins.BasicConstructorJoinPoint;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.metadata.spi.stack.MetaDataStack;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class AOPConstructorJoinpoint extends BasicConstructorJoinPoint
/*     */ {
/*  56 */   AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
/*     */ 
/*     */   public AOPConstructorJoinpoint(org.jboss.reflect.spi.ConstructorInfo constructorInfo)
/*     */   {
/*  65 */     super(constructorInfo);
/*     */   }
/*     */ 
/*     */   public Object dispatch() throws Throwable
/*     */   {
/*  70 */     Class clazz = this.constructorInfo.getDeclaringClass().getType();
/*  71 */     MetaData metaData = MetaDataStack.peek();
/*  72 */     AspectManager manager = AspectManagerFactory.getAspectManager(metaData);
/*     */ 
/*  74 */     MetaDataStack.mask();
/*     */     try
/*     */     {
/*  77 */       boolean hasInstanceMetaData = hasInstanceOrJoinpointMetaData(metaData);
/*  78 */       ContainerCache cache = ContainerCache.initialise(manager, clazz, metaData, hasInstanceMetaData);
/*  79 */       AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/*  80 */       Object target = createTarget(cache, params);
/*  81 */       params.setProxiedClass(target.getClass());
/*  82 */       params.setMetaData(metaData);
/*  83 */       params.setTarget(target);
/*  84 */       params.setContainerCache(cache);
/*  85 */       params.setMetaDataHasInstanceLevelData(hasInstanceMetaData);
/*     */ 
/*  87 */       Object localObject1 = this.proxyFactory.createAdvisedProxy(params);
/*     */       return localObject1; } finally { MetaDataStack.unmask(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   private boolean hasInstanceOrJoinpointMetaData(MetaData metaData)
/*     */   {
/*  97 */     if (metaData == null)
/*     */     {
/*  99 */       return false;
/*     */     }
/*     */ 
/* 102 */     MetaData instanceMetaData = metaData.getScopeMetaData(CommonLevels.INSTANCE);
/* 103 */     if ((instanceMetaData != null) && (!instanceMetaData.isEmpty()))
/*     */     {
/* 105 */       return true;
/*     */     }
/*     */ 
/* 108 */     return hasMethodMetaData(metaData);
/*     */   }
/*     */ 
/*     */   private boolean hasMethodMetaData(MetaData metaData)
/*     */   {
/* 114 */     ClassInfo info = this.constructorInfo.getDeclaringClass();
/* 115 */     while (info != null)
/*     */     {
/* 117 */       MethodInfo[] methods = info.getDeclaredMethods();
/* 118 */       if (methods != null)
/*     */       {
/* 120 */         for (MethodInfo mi : methods)
/*     */         {
/* 122 */           if (methodHasAnnotations(metaData, mi))
/*     */           {
/* 124 */             return true;
/*     */           }
/*     */         }
/*     */       }
/* 128 */       info = info.getSuperclass();
/*     */     }
/*     */ 
/* 131 */     return false;
/*     */   }
/*     */ 
/*     */   private boolean methodHasAnnotations(MetaData metaData, MethodInfo mi)
/*     */   {
/* 136 */     MethodSignature sig = new MethodSignature(mi);
/* 137 */     MetaData methodMD = metaData.getComponentMetaData(sig);
/* 138 */     if (methodMD != null)
/*     */     {
/* 140 */       return methodMD.getAnnotations() != MetaData.NO_ANNOTATIONS;
/*     */     }
/* 142 */     return false;
/*     */   }
/*     */ 
/*     */   private Object createTarget(ContainerCache cache, AOPProxyFactoryParameters params) throws Throwable
/*     */   {
/* 147 */     Advisor advisor = cache.getAdvisor();
/* 148 */     if (advisor != null)
/*     */     {
/* 150 */       org.jboss.aop.ConstructorInfo aopinfo = findAopConstructorInfo(advisor);
/*     */ 
/* 152 */       Interceptor[] interceptors = aopinfo != null ? aopinfo.getInterceptors() : null;
/*     */ 
/* 154 */       if (interceptors != null)
/*     */       {
/* 156 */         ConstructorInvocation inv = new ConstructorInvocation(aopinfo, aopinfo.getInterceptors());
/* 157 */         inv.setArguments(getArguments());
/* 158 */         return inv.invokeNext();
/*     */       }
/*     */ 
/* 161 */       if (getConstructorInfo().getParameterTypes().length > 0)
/*     */       {
/* 163 */         Constructor constructor = null;
/* 164 */         if (aopinfo == null)
/*     */         {
/* 167 */           Class clazz = advisor.getClazz();
/* 168 */           Constructor[] ctors = clazz.getConstructors();
/* 169 */           for (Constructor ctor : ctors)
/*     */           {
/* 171 */             if (!matchConstructor(ctor))
/*     */               continue;
/* 173 */             constructor = ctor;
/* 174 */             break;
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 180 */           constructor = aopinfo.getConstructor();
/*     */         }
/* 182 */         params.setCtor(constructor.getParameterTypes(), getArguments());
/*     */       }
/*     */     }
/*     */ 
/* 186 */     return super.dispatch();
/*     */   }
/*     */ 
/*     */   private org.jboss.aop.ConstructorInfo findAopConstructorInfo(Advisor advisor)
/*     */   {
/* 191 */     org.jboss.aop.ConstructorInfo[] infos = advisor.getConstructorInfos();
/* 192 */     for (int i = 0; i < infos.length; i++)
/*     */     {
/* 194 */       if (matchConstructor(infos[i].getConstructor()))
/*     */       {
/* 196 */         return infos[i];
/*     */       }
/*     */     }
/* 199 */     return null;
/*     */   }
/*     */ 
/*     */   private boolean matchConstructor(Constructor ctor)
/*     */   {
/* 204 */     TypeInfo[] params = this.constructorInfo.getParameterTypes();
/* 205 */     Class[] ctorParams = ctor.getParameterTypes();
/* 206 */     if (params.length == ctorParams.length)
/*     */     {
/* 208 */       boolean match = true;
/* 209 */       for (int p = 0; p < params.length; p++)
/*     */       {
/* 211 */         if (params[p].getName().equals(ctorParams[p].getName()))
/*     */           continue;
/* 213 */         match = false;
/* 214 */         break;
/*     */       }
/*     */ 
/* 218 */       if (match)
/*     */       {
/* 220 */         return true;
/*     */       }
/*     */     }
/* 223 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.integration.AOPConstructorJoinpoint
 * JD-Core Version:    0.6.0
 */