/*      */ package org.jboss.aop.microcontainer.beans.xml;
/*      */ 
/*      */ import javax.xml.namespace.NamespaceContext;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.jboss.aop.advice.AdviceType;
/*      */ import org.jboss.aop.microcontainer.beans.AnnotationIntroduction;
/*      */ import org.jboss.aop.microcontainer.beans.AnnotationOverride;
/*      */ import org.jboss.aop.microcontainer.beans.ArrayReplacement;
/*      */ import org.jboss.aop.microcontainer.beans.CFlowStackEntry;
/*      */ import org.jboss.aop.microcontainer.beans.DynamicCFlowDef;
/*      */ import org.jboss.aop.microcontainer.beans.MixinEntry;
/*      */ import org.jboss.aop.microcontainer.beans.NamedPointcut;
/*      */ import org.jboss.aop.microcontainer.beans.Prepare;
/*      */ import org.jboss.aop.microcontainer.beans.TypeDef;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.AdviceData;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.ArrayBindBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.AspectBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.AspectManagerAwareBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.BaseInterceptorData;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.BeanMetaDataUtil;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.BindBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.CFlowStackBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.ConfigureLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.CreateLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.DescribeLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.DomainBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.InstallLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.InstantiateLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.IntroductionBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.LifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.PreInstallLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.PrecedenceBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.StackBeanMetaDataFactory;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.StackRefData;
/*      */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.StartLifecycleBeanMetaDataFactory;
/*      */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*      */ import org.jboss.kernel.plugins.deployment.xml.BeanFactoryHandler;
/*      */ import org.jboss.kernel.plugins.deployment.xml.BeanSchemaBinding20;
/*      */ import org.jboss.kernel.plugins.deployment.xml.BeanSchemaBindingHelper;
/*      */ import org.jboss.util.id.GUID;
/*      */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*      */ import org.xml.sax.Attributes;
/*      */ 
/*      */ public class AOPBeansSchemaInitializer
/*      */   implements SchemaBindingInitializer
/*      */ {
/*      */   private static final String MANAGER_BEAN_NAME = "manager-bean";
/*      */   private static final String MANAGER_PROPERTY_NAME = "manager-property";
/*      */   private static final String AOP_BEANS_NS = "urn:jboss:aop-beans:1.0";
/*   86 */   private static final QName domainTypeQName = new QName("urn:jboss:aop-beans:1.0", "domainType");
/*      */ 
/*   88 */   private static final QName aspectQName = new QName("urn:jboss:aop-beans:1.0", "aspect");
/*      */ 
/*   90 */   private static final QName interceptorQName = new QName("urn:jboss:aop-beans:1.0", "interceptor");
/*      */ 
/*   93 */   private static final QName aspectOrInterceptorTypeQName = new QName("urn:jboss:aop-beans:1.0", "aspectOrInterceptorType");
/*      */ 
/*   95 */   private static final QName bindQName = new QName("urn:jboss:aop-beans:1.0", "bind");
/*      */ 
/*   98 */   private static final QName bindTypeQName = new QName("urn:jboss:aop-beans:1.0", "bindType");
/*      */ 
/*  100 */   private static final QName stackQName = new QName("urn:jboss:aop-beans:1.0", "stack");
/*      */ 
/*  102 */   private static final QName stackTypeQName = new QName("urn:jboss:aop-beans:1.0", "stackType");
/*      */ 
/*  104 */   private static final QName stackRefQName = new QName("urn:jboss:aop-beans:1.0", "stack-ref");
/*      */ 
/*  106 */   private static final QName stackRefTypeQName = new QName("urn:jboss:aop-beans:1.0", "stackRefType");
/*      */ 
/*  108 */   private static final QName interceptorRefQName = new QName("urn:jboss:aop-beans:1.0", "interceptor-ref");
/*      */ 
/*  110 */   private static final QName interceptorRefTypeQName = new QName("urn:jboss:aop-beans:1.0", "interceptorRefType");
/*      */ 
/*  112 */   private static final QName adviceQName = new QName("urn:jboss:aop-beans:1.0", "advice");
/*      */ 
/*  114 */   private static final QName adviceTypeQName = new QName("urn:jboss:aop-beans:1.0", "adviceType");
/*      */ 
/*  116 */   private static final QName aroundQName = new QName("urn:jboss:aop-beans:1.0", "around");
/*      */ 
/*  118 */   private static final QName beforeQName = new QName("urn:jboss:aop-beans:1.0", "before");
/*      */ 
/*  120 */   private static final QName beforeTypeQName = new QName("urn:jboss:aop-beans:1.0", "beforeType");
/*      */ 
/*  122 */   private static final QName afterQName = new QName("urn:jboss:aop-beans:1.0", "after");
/*      */ 
/*  124 */   private static final QName afterTypeQName = new QName("urn:jboss:aop-beans:1.0", "afterType");
/*      */ 
/*  126 */   private static final QName throwingQName = new QName("urn:jboss:aop-beans:1.0", "throwing");
/*      */ 
/*  128 */   private static final QName throwingTypeQName = new QName("urn:jboss:aop-beans:1.0", "throwingType");
/*      */ 
/*  130 */   private static final QName finallyQName = new QName("urn:jboss:aop-beans:1.0", "finally");
/*      */ 
/*  132 */   private static final QName finallyTypeQName = new QName("urn:jboss:aop-beans:1.0", "finallyType");
/*      */ 
/*  134 */   private static final QName typedefQName = new QName("urn:jboss:aop-beans:1.0", "typedef");
/*      */ 
/*  136 */   private static final QName typedefTypeQName = new QName("urn:jboss:aop-beans:1.0", "typedefType");
/*      */ 
/*  138 */   private static final QName cflowStackQName = new QName("urn:jboss:aop-beans:1.0", "cflow-stack");
/*      */ 
/*  140 */   private static final QName cflowStackTypeQName = new QName("urn:jboss:aop-beans:1.0", "cflowStackType");
/*      */ 
/*  142 */   private static final QName cflowStackEntryTypeQName = new QName("urn:jboss:aop-beans:1.0", "cflowStackEntryType");
/*      */ 
/*  144 */   private static final QName calledQName = new QName("urn:jboss:aop-beans:1.0", "called");
/*      */ 
/*  146 */   private static final QName notCalledQName = new QName("urn:jboss:aop-beans:1.0", "not-called");
/*      */ 
/*  148 */   private static final QName dynamicCflowQName = new QName("urn:jboss:aop-beans:1.0", "dynamic-cflow");
/*      */ 
/*  150 */   private static final QName dynamicCflowStackTypeQName = new QName("urn:jboss:aop-beans:1.0", "dynamicCflowStackType");
/*      */ 
/*  152 */   private static final QName pointcutQName = new QName("urn:jboss:aop-beans:1.0", "pointcut");
/*      */ 
/*  154 */   private static final QName pointcutTypeQName = new QName("urn:jboss:aop-beans:1.0", "pointcutType");
/*      */ 
/*  156 */   private static final QName prepareQName = new QName("urn:jboss:aop-beans:1.0", "prepare");
/*      */ 
/*  158 */   private static final QName prepareTypeQName = new QName("urn:jboss:aop-beans:1.0", "prepareType");
/*      */ 
/*  160 */   private static final QName annotationQName = new QName("urn:jboss:aop-beans:1.0", "annotation");
/*      */ 
/*  162 */   private static final QName annotationTypeQName = new QName("urn:jboss:aop-beans:1.0", "annotationType");
/*      */ 
/*  164 */   private static final QName annotationIntroductionQName = new QName("urn:jboss:aop-beans:1.0", "annotation-introduction");
/*      */ 
/*  166 */   private static final QName annotationIntroductionTypeQName = new QName("urn:jboss:aop-beans:1.0", "annotationIntroductionType");
/*      */ 
/*  168 */   private static final QName precedenceQName = new QName("urn:jboss:aop-beans:1.0", "precedence");
/*      */ 
/*  170 */   private static final QName precedenceTypeQName = new QName("urn:jboss:aop-beans:1.0", "precedenceType");
/*      */ 
/*  172 */   private static final QName introductionQName = new QName("urn:jboss:aop-beans:1.0", "introduction");
/*      */ 
/*  174 */   private static final QName introductionTypeQName = new QName("urn:jboss:aop-beans:1.0", "introductionType");
/*      */ 
/*  176 */   private static final QName interfacesQName = new QName("urn:jboss:aop-beans:1.0", "interfaces");
/*      */ 
/*  178 */   private static final QName interfacesTypeQName = new QName("urn:jboss:aop-beans:1.0", "interfacesType");
/*      */ 
/*  180 */   private static final QName mixinQName = new QName("urn:jboss:aop-beans:1.0", "mixin");
/*      */ 
/*  182 */   private static final QName mixinTypeQName = new QName("urn:jboss:aop-beans:1.0", "mixinType");
/*      */ 
/*  184 */   private static final QName classQName = new QName("urn:jboss:aop-beans:1.0", "class");
/*      */ 
/*  186 */   private static final QName classTypeQName = new QName("urn:jboss:aop-beans:1.0", "classType");
/*      */ 
/*  188 */   private static final QName transientQName = new QName("urn:jboss:aop-beans:1.0", "transient");
/*      */ 
/*  190 */   private static final QName transientTypeQName = new QName("urn:jboss:aop-beans:1.0", "transientType");
/*      */ 
/*  192 */   private static final QName constructionQName = new QName("urn:jboss:aop-beans:1.0", "construction");
/*      */ 
/*  194 */   private static final QName constructionTypeQName = new QName("urn:jboss:aop-beans:1.0", "constructionType");
/*      */ 
/*  196 */   private static final QName arrayreplacementQName = new QName("urn:jboss:aop-beans:1.0", "arrayreplacement");
/*      */ 
/*  198 */   private static final QName arrayreplacementTypeQName = new QName("urn:jboss:aop-beans:1.0", "arrayreplacementType");
/*      */ 
/*  200 */   private static final QName arraybindQName = new QName("urn:jboss:aop-beans:1.0", "arraybind");
/*      */ 
/*  202 */   private static final QName arraybindTypeQName = new QName("urn:jboss:aop-beans:1.0", "arraybindType");
/*      */ 
/*  205 */   private static final QName lifecycleTypeQName = new QName("urn:jboss:aop-beans:1.0", "lifecycleType");
/*      */ 
/*      */   public SchemaBinding init(SchemaBinding schema)
/*      */   {
/*  214 */     schema.setReplacePropertyRefs(false);
/*      */ 
/*  216 */     initTopLevelBindings(schema);
/*  217 */     initChildBindings(schema);
/*      */ 
/*  222 */     BeanSchemaBinding20.initArtifacts(schema);
/*      */ 
/*  224 */     return schema;
/*      */   }
/*      */ 
/*      */   private void initTopLevelBindings(SchemaBinding schema)
/*      */   {
/*  229 */     initDomainType(schema);
/*  230 */     initAspectOrInterceptorType(schema);
/*  231 */     initBindType(schema);
/*  232 */     initStackType(schema);
/*  233 */     initTypedefType(schema);
/*  234 */     initCFlowStackType(schema);
/*  235 */     initDynamicCFlowStackType(schema);
/*  236 */     initPrepareType(schema);
/*  237 */     initPointcutType(schema);
/*  238 */     initAnnotationIntroductionType(schema);
/*  239 */     initAnnotationType(schema);
/*  240 */     initPrecedenceType(schema);
/*  241 */     initIntroductionType(schema);
/*  242 */     initArrayBindType(schema);
/*  243 */     initArrayReplacementType(schema);
/*  244 */     initLifecycleType(schema);
/*      */   }
/*      */ 
/*      */   private void initChildBindings(SchemaBinding schema)
/*      */   {
/*  250 */     initInterceptorRefType(schema);
/*  251 */     initStackRefType(schema);
/*  252 */     initAdviceType(schema);
/*  253 */     initBeforeType(schema);
/*  254 */     initAfterType(schema);
/*  255 */     initThrowingType(schema);
/*  256 */     initFinallyType(schema);
/*  257 */     initCFlowStackEntryType(schema);
/*  258 */     initInterfacesType(schema);
/*  259 */     initMixinType(schema);
/*  260 */     initClassType(schema);
/*  261 */     initTransientType(schema);
/*  262 */     initConstructionType(schema);
/*      */   }
/*      */ 
/*      */   private void initDomainType(SchemaBinding schema)
/*      */   {
/*  267 */     TypeBinding type = schema.getType(domainTypeQName);
/*  268 */     type.setHandler(DomainHandler.HANDLER);
/*  269 */     type.pushInterceptor(interceptorQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  270 */     type.pushInterceptor(aspectQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  271 */     type.pushInterceptor(bindQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  272 */     type.pushInterceptor(stackQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  273 */     type.pushInterceptor(typedefQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  274 */     type.pushInterceptor(cflowStackQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  275 */     type.pushInterceptor(dynamicCflowQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  276 */     type.pushInterceptor(prepareQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  277 */     type.pushInterceptor(pointcutQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  278 */     type.pushInterceptor(annotationQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  279 */     type.pushInterceptor(annotationIntroductionQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  280 */     type.pushInterceptor(precedenceQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  281 */     type.pushInterceptor(introductionQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*  282 */     type.pushInterceptor(arrayreplacementQName, DomainBeanMetaDataInterceptor.INTERCEPTOR);
/*  283 */     type.pushInterceptor(arraybindQName, DomainAspectManagerAwareBeanMetaDataFactoryInterceptor.INTERCEPTOR);
/*      */   }
/*      */ 
/*      */   private void initAspectOrInterceptorType(SchemaBinding schema)
/*      */   {
/*  289 */     TypeBinding type = schema.getType(aspectOrInterceptorTypeQName);
/*  290 */     BeanSchemaBindingHelper.initBeanFactoryHandlers(type);
/*  291 */     type.setHandler(new AspectBeanFactoryHandler(null));
/*      */   }
/*      */ 
/*      */   private void initBindType(SchemaBinding schema)
/*      */   {
/*  297 */     TypeBinding type = schema.getType(bindTypeQName);
/*  298 */     type.pushInterceptor(stackRefQName, BindContentInterceptor.INTERCEPTOR);
/*  299 */     type.pushInterceptor(interceptorRefQName, BindContentInterceptor.INTERCEPTOR);
/*  300 */     type.pushInterceptor(adviceQName, BindContentInterceptor.INTERCEPTOR);
/*  301 */     type.pushInterceptor(aroundQName, BindContentInterceptor.INTERCEPTOR);
/*  302 */     type.pushInterceptor(beforeQName, BindContentInterceptor.INTERCEPTOR);
/*  303 */     type.pushInterceptor(afterQName, BindContentInterceptor.INTERCEPTOR);
/*  304 */     type.pushInterceptor(throwingQName, BindContentInterceptor.INTERCEPTOR);
/*  305 */     type.pushInterceptor(finallyQName, BindContentInterceptor.INTERCEPTOR);
/*  306 */     type.setHandler(new BindBeanFactoryHandler(null));
/*      */   }
/*      */ 
/*      */   private void initArrayBindType(SchemaBinding schema)
/*      */   {
/*  311 */     TypeBinding type = schema.getType(arraybindTypeQName);
/*  312 */     type.pushInterceptor(stackRefQName, ArrayBindContentInterceptor.INTERCEPTOR);
/*  313 */     type.pushInterceptor(interceptorRefQName, ArrayBindContentInterceptor.INTERCEPTOR);
/*  314 */     type.pushInterceptor(adviceQName, ArrayBindContentInterceptor.INTERCEPTOR);
/*  315 */     type.pushInterceptor(aroundQName, ArrayBindContentInterceptor.INTERCEPTOR);
/*  316 */     type.setHandler(new ArrayBindBeanFactoryHandler(null));
/*      */   }
/*      */ 
/*      */   private void initStackType(SchemaBinding schema)
/*      */   {
/*  321 */     TypeBinding type = schema.getType(stackTypeQName);
/*  322 */     type.pushInterceptor(stackRefQName, StackContentInterceptor.INTERCEPTOR);
/*  323 */     type.pushInterceptor(interceptorRefQName, StackContentInterceptor.INTERCEPTOR);
/*  324 */     type.pushInterceptor(adviceQName, StackContentInterceptor.INTERCEPTOR);
/*  325 */     type.pushInterceptor(aroundQName, StackContentInterceptor.INTERCEPTOR);
/*  326 */     type.pushInterceptor(beforeQName, StackContentInterceptor.INTERCEPTOR);
/*  327 */     type.pushInterceptor(afterQName, StackContentInterceptor.INTERCEPTOR);
/*  328 */     type.pushInterceptor(throwingQName, StackContentInterceptor.INTERCEPTOR);
/*  329 */     type.pushInterceptor(finallyQName, StackContentInterceptor.INTERCEPTOR);
/*  330 */     type.setHandler(new StackBeanFactoryHandler(null));
/*      */   }
/*      */ 
/*      */   private void initTypedefType(SchemaBinding schema)
/*      */   {
/*  335 */     TypeBinding type = schema.getType(typedefTypeQName);
/*  336 */     type.setHandler(new TypeDefHandler(null));
/*      */   }
/*      */ 
/*      */   private void initCFlowStackType(SchemaBinding schema)
/*      */   {
/*  341 */     TypeBinding type = schema.getType(cflowStackTypeQName);
/*  342 */     type.pushInterceptor(calledQName, CFlowStackCalledInterceptor.INTERCEPTOR);
/*  343 */     type.pushInterceptor(notCalledQName, CFlowStackNotCalledInterceptor.INTERCEPTOR);
/*  344 */     type.setHandler(CFlowStackHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initDynamicCFlowStackType(SchemaBinding schema)
/*      */   {
/*  349 */     TypeBinding type = schema.getType(dynamicCflowStackTypeQName);
/*  350 */     type.setHandler(DynamicCFlowHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initPointcutType(SchemaBinding schema)
/*      */   {
/*  355 */     TypeBinding type = schema.getType(pointcutTypeQName);
/*  356 */     type.setHandler(PointcutHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initPrepareType(SchemaBinding schema)
/*      */   {
/*  361 */     TypeBinding type = schema.getType(prepareTypeQName);
/*  362 */     type.setHandler(PrepareHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initArrayReplacementType(SchemaBinding schema)
/*      */   {
/*  367 */     TypeBinding type = schema.getType(arrayreplacementTypeQName);
/*  368 */     type.setHandler(ArrayReplacementHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initAnnotationIntroductionType(SchemaBinding schema)
/*      */   {
/*  373 */     TypeBinding type = schema.getType(annotationIntroductionTypeQName);
/*  374 */     type.setHandler(AnnotationIntroductionHandler.HANDLER);
/*  375 */     type.setSimpleType(AnnotationCharactersHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initAnnotationType(SchemaBinding schema)
/*      */   {
/*  380 */     TypeBinding type = schema.getType(annotationTypeQName);
/*  381 */     type.setHandler(AnnotationOverrideHandler.HANDLER);
/*  382 */     type.setSimpleType(AnnotationCharactersHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initPrecedenceType(SchemaBinding schema)
/*      */   {
/*  387 */     TypeBinding type = schema.getType(precedenceTypeQName);
/*  388 */     type.setHandler(PrecedenceHandler.HANDLER);
/*  389 */     type.pushInterceptor(adviceQName, PrecedenceInterceptor.INTERCEPTOR);
/*  390 */     type.pushInterceptor(interceptorRefQName, PrecedenceInterceptor.INTERCEPTOR);
/*      */   }
/*      */ 
/*      */   private void initIntroductionType(SchemaBinding schema)
/*      */   {
/*  395 */     TypeBinding type = schema.getType(introductionTypeQName);
/*  396 */     type.pushInterceptor(interfacesQName, IntroductionInterfacesInterceptor.INTERCEPTOR);
/*  397 */     type.pushInterceptor(mixinQName, IntroductionMixinInterceptor.INTERCEPTOR);
/*  398 */     type.setHandler(IntroductionHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initLifecycleType(SchemaBinding schema)
/*      */   {
/*  403 */     TypeBinding type = schema.getType(lifecycleTypeQName);
/*  404 */     BeanSchemaBindingHelper.initBeanFactoryHandlers(type);
/*  405 */     type.setHandler(new LifecycleBeanFactoryHandler(null));
/*      */   }
/*      */ 
/*      */   private void initInterceptorRefType(SchemaBinding schema)
/*      */   {
/*  410 */     TypeBinding type = schema.getType(interceptorRefTypeQName);
/*  411 */     type.setHandler(InterceptorRefHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initStackRefType(SchemaBinding schema)
/*      */   {
/*  416 */     TypeBinding type = schema.getType(stackRefTypeQName);
/*  417 */     type.setHandler(StackRefHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initAdviceType(SchemaBinding schema)
/*      */   {
/*  422 */     TypeBinding type = schema.getType(adviceTypeQName);
/*  423 */     type.setHandler(AdviceHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initBeforeType(SchemaBinding schema)
/*      */   {
/*  428 */     TypeBinding type = schema.getType(beforeTypeQName);
/*  429 */     type.setHandler(BeforeHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initAfterType(SchemaBinding schema)
/*      */   {
/*  434 */     TypeBinding type = schema.getType(afterTypeQName);
/*  435 */     type.setHandler(AfterHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initThrowingType(SchemaBinding schema)
/*      */   {
/*  440 */     TypeBinding type = schema.getType(throwingTypeQName);
/*  441 */     type.setHandler(ThrowingHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initFinallyType(SchemaBinding schema)
/*      */   {
/*  446 */     TypeBinding type = schema.getType(finallyTypeQName);
/*  447 */     type.setHandler(FinallyHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initCFlowStackEntryType(SchemaBinding schema)
/*      */   {
/*  452 */     TypeBinding type = schema.getType(cflowStackEntryTypeQName);
/*  453 */     type.setHandler(CFlowStackEntryHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initInterfacesType(SchemaBinding schema)
/*      */   {
/*  458 */     TypeBinding type = schema.getType(interfacesTypeQName);
/*  459 */     type.setSimpleType(StringBufferCharacterHandler.HANDLER);
/*  460 */     type.setHandler(InterfacesHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initMixinType(SchemaBinding schema)
/*      */   {
/*  465 */     TypeBinding type = schema.getType(mixinTypeQName);
/*  466 */     type.pushInterceptor(classQName, MixinClassInterceptor.INTERCEPTOR);
/*  467 */     type.pushInterceptor(transientQName, MixinTransientInterceptor.INTERCEPTOR);
/*  468 */     type.pushInterceptor(interfacesQName, MixinInterfacesInterceptor.INTERCEPTOR);
/*  469 */     type.pushInterceptor(constructionQName, MixinConstructionInterceptor.INTERCEPTOR);
/*  470 */     type.setHandler(MixinHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initClassType(SchemaBinding schema)
/*      */   {
/*  475 */     TypeBinding type = schema.getType(classTypeQName);
/*  476 */     type.setHandler(StringBufferHandler.HANDLER);
/*  477 */     type.setSimpleType(StringBufferCharacterHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initTransientType(SchemaBinding schema)
/*      */   {
/*  482 */     TypeBinding type = schema.getType(transientTypeQName);
/*  483 */     type.setHandler(StringBufferHandler.HANDLER);
/*  484 */     type.setSimpleType(StringBufferCharacterHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private void initConstructionType(SchemaBinding schema)
/*      */   {
/*  489 */     TypeBinding type = schema.getType(constructionTypeQName);
/*  490 */     type.setHandler(StringBufferHandler.HANDLER);
/*  491 */     type.setSimpleType(StringBufferCharacterHandler.HANDLER);
/*      */   }
/*      */ 
/*      */   private static class StringBufferCharacterHandler extends CharactersHandler
/*      */   {
/* 1451 */     public static final StringBufferCharacterHandler HANDLER = new StringBufferCharacterHandler();
/*      */ 
/*      */     public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*      */     {
/* 1456 */       return value;
/*      */     }
/*      */ 
/*      */     public void setValue(QName qname, ElementBinding element, Object owner, Object value)
/*      */     {
/* 1462 */       ((StringBuffer)owner).append(((String)value).trim());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AnnotationCharactersHandler extends CharactersHandler
/*      */   {
/* 1434 */     public static final AnnotationCharactersHandler HANDLER = new AnnotationCharactersHandler();
/*      */ 
/*      */     public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*      */     {
/* 1439 */       return value;
/*      */     }
/*      */ 
/*      */     public void setValue(QName qname, ElementBinding element, Object owner, Object value)
/*      */     {
/* 1445 */       BeanMetaDataUtil.setSimpleProperty((AbstractBeanMetaData)owner, "annotation", ((String)value).trim());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DomainBeanMetaDataInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1413 */     public static final DomainBeanMetaDataInterceptor INTERCEPTOR = new DomainBeanMetaDataInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1418 */       DomainBeanMetaDataFactory domain = (DomainBeanMetaDataFactory)parent;
/* 1419 */       AbstractBeanMetaData bean = (AbstractBeanMetaData)child;
/*      */ 
/* 1421 */       BeanMetaDataUtil util = new BeanMetaDataUtil();
/* 1422 */       util.setManagerBean(domain.getName());
/* 1423 */       util.setManagerProperty("domain");
/* 1424 */       util.setAspectManagerProperty(bean, "manager");
/*      */ 
/* 1426 */       domain.addChildBean(bean);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DomainAspectManagerAwareBeanMetaDataFactoryInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1397 */     public static final DomainAspectManagerAwareBeanMetaDataFactoryInterceptor INTERCEPTOR = new DomainAspectManagerAwareBeanMetaDataFactoryInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1402 */       DomainBeanMetaDataFactory domain = (DomainBeanMetaDataFactory)parent;
/* 1403 */       AspectManagerAwareBeanMetaDataFactory factory = (AspectManagerAwareBeanMetaDataFactory)child;
/*      */ 
/* 1405 */       factory.setManagerBean(domain.getName());
/* 1406 */       factory.setManagerProperty("domain");
/* 1407 */       domain.addChildBean(factory);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class MixinInterfacesInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1385 */     public static final MixinInterfacesInterceptor INTERCEPTOR = new MixinInterfacesInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1390 */       AbstractBeanMetaData mixin = (AbstractBeanMetaData)parent;
/* 1391 */       IntroductionBeanMetaDataFactory.addInterfaces(mixin, "interfaces", ((StringBuffer)child).toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class MixinConstructionInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1373 */     public static final MixinConstructionInterceptor INTERCEPTOR = new MixinConstructionInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1378 */       AbstractBeanMetaData mixin = (AbstractBeanMetaData)parent;
/* 1379 */       BeanMetaDataUtil.setSimpleProperty(mixin, "construction", ((StringBuffer)child).toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class MixinTransientInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1361 */     public static final MixinTransientInterceptor INTERCEPTOR = new MixinTransientInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1366 */       AbstractBeanMetaData mixin = (AbstractBeanMetaData)parent;
/* 1367 */       BeanMetaDataUtil.setSimpleProperty(mixin, "transient", ((StringBuffer)child).toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class MixinClassInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1349 */     public static final MixinClassInterceptor INTERCEPTOR = new MixinClassInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1354 */       AbstractBeanMetaData mixin = (AbstractBeanMetaData)parent;
/* 1355 */       BeanMetaDataUtil.setSimpleProperty(mixin, "mixin", ((StringBuffer)child).toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class IntroductionMixinInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1337 */     public static final IntroductionMixinInterceptor INTERCEPTOR = new IntroductionMixinInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1342 */       IntroductionBeanMetaDataFactory intro = (IntroductionBeanMetaDataFactory)parent;
/* 1343 */       intro.addMixinEntry((AbstractBeanMetaData)child);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class IntroductionInterfacesInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1325 */     public static final IntroductionInterfacesInterceptor INTERCEPTOR = new IntroductionInterfacesInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1330 */       IntroductionBeanMetaDataFactory intro = (IntroductionBeanMetaDataFactory)parent;
/* 1331 */       intro.setInterfaces(((StringBuffer)child).toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class PrecedenceInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1312 */     public static final PrecedenceInterceptor INTERCEPTOR = new PrecedenceInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1317 */       PrecedenceBeanMetaDataFactory precedence = (PrecedenceBeanMetaDataFactory)parent;
/* 1318 */       BaseInterceptorData interceptorData = (BaseInterceptorData)child;
/* 1319 */       precedence.addEntry(interceptorData);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class CFlowStackCalledInterceptor extends AOPBeansSchemaInitializer.CFlowStackInterceptor
/*      */   {
/* 1301 */     public static final CFlowStackCalledInterceptor INTERCEPTOR = new CFlowStackCalledInterceptor();
/*      */ 
/*      */     private CFlowStackCalledInterceptor()
/*      */     {
/* 1299 */       super();
/*      */     }
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1306 */       super.addEntry(parent, child, name, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class CFlowStackNotCalledInterceptor extends AOPBeansSchemaInitializer.CFlowStackInterceptor
/*      */   {
/* 1290 */     public static final CFlowStackNotCalledInterceptor INTERCEPTOR = new CFlowStackNotCalledInterceptor();
/*      */ 
/*      */     private CFlowStackNotCalledInterceptor()
/*      */     {
/* 1288 */       super();
/*      */     }
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1295 */       super.addEntry(parent, child, name, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class CFlowStackInterceptor extends DefaultElementInterceptor
/*      */   {
/*      */     public void addEntry(Object parent, Object child, QName name, boolean called)
/*      */     {
/* 1281 */       CFlowStackBeanMetaDataFactory cflowStack = (CFlowStackBeanMetaDataFactory)parent;
/* 1282 */       AbstractBeanMetaData entry = (AbstractBeanMetaData)child;
/* 1283 */       BeanMetaDataUtil.setSimpleProperty(entry, "called", Boolean.valueOf(called));
/* 1284 */       cflowStack.addEntry(entry);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class StackContentInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1266 */     public static final StackContentInterceptor INTERCEPTOR = new StackContentInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1271 */       StackBeanMetaDataFactory factory = (StackBeanMetaDataFactory)parent;
/* 1272 */       BaseInterceptorData interceptorData = (BaseInterceptorData)child;
/* 1273 */       factory.addInterceptor(interceptorData);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ArrayBindContentInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1253 */     public static final ArrayBindContentInterceptor INTERCEPTOR = new ArrayBindContentInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1258 */       ArrayBindBeanMetaDataFactory factory = (ArrayBindBeanMetaDataFactory)parent;
/* 1259 */       BaseInterceptorData interceptorData = (BaseInterceptorData)child;
/* 1260 */       factory.addInterceptor(interceptorData);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class BindContentInterceptor extends DefaultElementInterceptor
/*      */   {
/* 1240 */     public static final BindContentInterceptor INTERCEPTOR = new BindContentInterceptor();
/*      */ 
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1245 */       BindBeanMetaDataFactory factory = (BindBeanMetaDataFactory)parent;
/* 1246 */       BaseInterceptorData interceptorData = (BaseInterceptorData)child;
/* 1247 */       factory.addInterceptor(interceptorData);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class StringBufferHandler extends DefaultElementHandler
/*      */   {
/* 1226 */     public static final StringBufferHandler HANDLER = new StringBufferHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1231 */       return new StringBuffer();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class MixinHandler extends DefaultElementHandler
/*      */   {
/* 1215 */     public static final MixinHandler HANDLER = new MixinHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1220 */       return new AbstractBeanMetaData(MixinEntry.class.getName());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class InterfacesHandler extends DefaultElementHandler
/*      */   {
/* 1204 */     public static final InterfacesHandler HANDLER = new InterfacesHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1209 */       return new StringBuffer();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AnnotationOverrideHandler extends AOPBeansSchemaInitializer.AnnotationIntroductionHandler
/*      */   {
/* 1192 */     public static final AnnotationOverrideHandler HANDLER = new AnnotationOverrideHandler();
/*      */ 
/*      */     private AnnotationOverrideHandler()
/*      */     {
/* 1190 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1197 */       return new AbstractBeanMetaData(AnnotationOverride.class.getName());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AnnotationIntroductionHandler extends DefaultElementHandler
/*      */   {
/* 1143 */     public static final AnnotationIntroductionHandler HANDLER = new AnnotationIntroductionHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1148 */       return new AbstractBeanMetaData(AnnotationIntroduction.class.getName());
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/* 1154 */       BeanMetaDataUtil util = new BeanMetaDataUtil();
/* 1155 */       AbstractBeanMetaData annotation = (AbstractBeanMetaData)o;
/*      */ 
/* 1157 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/* 1159 */         String localName = attrs.getLocalName(i);
/* 1160 */         if ("invisible".equals(localName))
/*      */         {
/* 1162 */           BeanMetaDataUtil.setSimpleProperty(annotation, "invisible", attrs.getValue(i));
/*      */         }
/* 1164 */         else if ("expr".equals(localName))
/*      */         {
/* 1166 */           BeanMetaDataUtil.setSimpleProperty(annotation, "expr", attrs.getValue(i));
/*      */         }
/* 1168 */         else if ("manager-bean".equals(localName))
/*      */         {
/* 1170 */           util.setManagerBean(attrs.getValue(i));
/*      */         } else {
/* 1172 */           if (!"manager-property".equals(localName))
/*      */             continue;
/* 1174 */           util.setManagerProperty(attrs.getValue(i));
/*      */         }
/*      */       }
/* 1177 */       util.setAspectManagerProperty(annotation, "manager");
/* 1178 */       annotation.setName(GUID.asString());
/*      */     }
/*      */ 
/*      */     public Object endElement(Object o, QName name, ElementBinding element)
/*      */     {
/* 1184 */       return super.endElement(o, name, element);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class PointcutHandler extends AOPBeansSchemaInitializer.PrepareHandler
/*      */   {
/* 1132 */     public static final PointcutHandler HANDLER = new PointcutHandler();
/*      */ 
/*      */     private PointcutHandler()
/*      */     {
/* 1130 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1137 */       return new AbstractBeanMetaData(NamedPointcut.class.getName());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class PrepareHandler extends DefaultElementHandler
/*      */   {
/* 1085 */     public static final PrepareHandler HANDLER = new PrepareHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1090 */       return new AbstractBeanMetaData(Prepare.class.getName());
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/* 1096 */       BeanMetaDataUtil util = new BeanMetaDataUtil();
/* 1097 */       AbstractBeanMetaData pointcut = (AbstractBeanMetaData)o;
/* 1098 */       String name = null;
/* 1099 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/* 1101 */         String localName = attrs.getLocalName(i);
/* 1102 */         if ("name".equals(localName))
/*      */         {
/* 1104 */           name = attrs.getValue(i);
/*      */         }
/* 1106 */         else if ("expr".equals(localName))
/*      */         {
/* 1108 */           BeanMetaDataUtil.setSimpleProperty(pointcut, "expr", attrs.getValue(i));
/*      */         }
/* 1110 */         else if ("manager-bean".equals(localName))
/*      */         {
/* 1112 */           util.setManagerBean(attrs.getValue(i));
/*      */         } else {
/* 1114 */           if (!"manager-property".equals(localName))
/*      */             continue;
/* 1116 */           util.setManagerProperty(attrs.getValue(i));
/*      */         }
/*      */       }
/* 1119 */       util.setAspectManagerProperty(pointcut, "manager");
/*      */ 
/* 1121 */       if (name == null)
/*      */       {
/* 1123 */         name = GUID.asString();
/*      */       }
/* 1125 */       pointcut.setName(name);
/* 1126 */       BeanMetaDataUtil.setSimpleProperty(pointcut, "name", name);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DynamicCFlowHandler extends DefaultElementHandler
/*      */   {
/* 1044 */     public static final DynamicCFlowHandler HANDLER = new DynamicCFlowHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1049 */       return new AbstractBeanMetaData(DynamicCFlowDef.class.getName());
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/* 1055 */       BeanMetaDataUtil util = new BeanMetaDataUtil();
/* 1056 */       AbstractBeanMetaData dynamicCFlow = (AbstractBeanMetaData)o;
/*      */ 
/* 1058 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/* 1060 */         String localName = attrs.getLocalName(i);
/* 1061 */         if ("name".equals(localName))
/*      */         {
/* 1063 */           dynamicCFlow.setName(attrs.getValue(i));
/* 1064 */           BeanMetaDataUtil.setSimpleProperty(dynamicCFlow, "name", attrs.getValue(i));
/*      */         }
/* 1066 */         else if ("class".equals(localName))
/*      */         {
/* 1068 */           BeanMetaDataUtil.setSimpleProperty(dynamicCFlow, "className", attrs.getValue(i));
/*      */         }
/* 1070 */         else if ("manager-bean".equals(localName))
/*      */         {
/* 1072 */           util.setManagerBean(attrs.getValue(i));
/*      */         } else {
/* 1074 */           if (!"manager-property".equals(localName))
/*      */             continue;
/* 1076 */           util.setManagerProperty(attrs.getValue(i));
/*      */         }
/*      */       }
/* 1079 */       util.setAspectManagerProperty(dynamicCFlow, "manager");
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class CFlowStackEntryHandler extends DefaultElementHandler
/*      */   {
/* 1019 */     public static final CFlowStackEntryHandler HANDLER = new CFlowStackEntryHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/* 1024 */       return new AbstractBeanMetaData(CFlowStackEntry.class.getName());
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/* 1030 */       AbstractBeanMetaData entry = (AbstractBeanMetaData)o;
/* 1031 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/* 1033 */         String localName = attrs.getLocalName(i);
/* 1034 */         if (!"expr".equals(localName))
/*      */           continue;
/* 1036 */         BeanMetaDataUtil.setSimpleProperty(entry, "expr", attrs.getValue(i));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class TypeDefHandler extends DefaultElementHandler
/*      */   {
/*  978 */     public static final TypeDefHandler HANDLER = new TypeDefHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  983 */       return new AbstractBeanMetaData(TypeDef.class.getName());
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  989 */       BeanMetaDataUtil util = new BeanMetaDataUtil();
/*  990 */       AbstractBeanMetaData typedef = (AbstractBeanMetaData)o;
/*      */ 
/*  992 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  994 */         String localName = attrs.getLocalName(i);
/*  995 */         if ("name".equals(localName))
/*      */         {
/*  997 */           typedef.setName(attrs.getValue(i));
/*  998 */           BeanMetaDataUtil.setSimpleProperty(typedef, "name", attrs.getValue(i));
/*      */         }
/* 1000 */         else if ("expr".equals(localName))
/*      */         {
/* 1002 */           BeanMetaDataUtil.setSimpleProperty(typedef, "expr", attrs.getValue(i));
/*      */         }
/* 1004 */         else if ("manager-bean".equals(localName))
/*      */         {
/* 1006 */           util.setManagerBean(attrs.getValue(i));
/*      */         } else {
/* 1008 */           if (!"manager-property".equals(localName))
/*      */             continue;
/* 1010 */           util.setManagerProperty(attrs.getValue(i));
/*      */         }
/*      */       }
/* 1013 */       util.setAspectManagerProperty(typedef, "manager");
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class FinallyHandler extends AOPBeansSchemaInitializer.AdviceHandler
/*      */   {
/*  965 */     public static final FinallyHandler HANDLER = new FinallyHandler();
/*      */ 
/*      */     private FinallyHandler()
/*      */     {
/*  963 */       super();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  970 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*  971 */       AdviceData advice = (AdviceData)o;
/*  972 */       advice.setType(AdviceType.FINALLY);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ThrowingHandler extends AOPBeansSchemaInitializer.AdviceHandler
/*      */   {
/*  952 */     public static final ThrowingHandler HANDLER = new ThrowingHandler();
/*      */ 
/*      */     private ThrowingHandler()
/*      */     {
/*  950 */       super();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  957 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*  958 */       AdviceData advice = (AdviceData)o;
/*  959 */       advice.setType(AdviceType.THROWING);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AfterHandler extends AOPBeansSchemaInitializer.AdviceHandler
/*      */   {
/*  939 */     public static final AfterHandler HANDLER = new AfterHandler();
/*      */ 
/*      */     private AfterHandler()
/*      */     {
/*  937 */       super();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  944 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*  945 */       AdviceData advice = (AdviceData)o;
/*  946 */       advice.setType(AdviceType.AFTER);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class BeforeHandler extends AOPBeansSchemaInitializer.AdviceHandler
/*      */   {
/*  926 */     public static final BeforeHandler HANDLER = new BeforeHandler();
/*      */ 
/*      */     private BeforeHandler()
/*      */     {
/*  924 */       super();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  931 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*  932 */       AdviceData advice = (AdviceData)o;
/*  933 */       advice.setType(AdviceType.BEFORE);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AdviceHandler extends DefaultElementHandler
/*      */   {
/*  896 */     public static final AdviceHandler HANDLER = new AdviceHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  901 */       return new AdviceData();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  907 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*  908 */       AdviceData advice = (AdviceData)o;
/*  909 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  911 */         String localName = attrs.getLocalName(i);
/*  912 */         if ("aspect".equals(localName))
/*      */         {
/*  914 */           advice.setRefName(attrs.getValue(i));
/*      */         } else {
/*  916 */           if (!"name".equals(localName))
/*      */             continue;
/*  918 */           advice.setAdviceMethod(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class StackRefHandler extends DefaultElementHandler
/*      */   {
/*  871 */     public static final StackRefHandler HANDLER = new StackRefHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  876 */       return new StackRefData();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  882 */       BaseInterceptorData interceptorRef = (BaseInterceptorData)o;
/*  883 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  885 */         String localName = attrs.getLocalName(i);
/*  886 */         if (!"name".equals(localName))
/*      */           continue;
/*  888 */         interceptorRef.setRefName(attrs.getValue(i));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ArrayReplacementHandler extends DefaultElementHandler
/*      */   {
/*  818 */     public static final ArrayReplacementHandler HANDLER = new ArrayReplacementHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  823 */       return new AbstractBeanMetaData(ArrayReplacement.class.getName());
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  829 */       AbstractBeanMetaData arrayReplacement = (AbstractBeanMetaData)o;
/*  830 */       BeanMetaDataUtil util = new BeanMetaDataUtil();
/*  831 */       String name = null;
/*  832 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  834 */         String localName = attrs.getLocalName(i);
/*  835 */         if ("name".equals(localName))
/*      */         {
/*  837 */           name = attrs.getValue(i);
/*      */         }
/*  839 */         else if ("class".equals(localName))
/*      */         {
/*  841 */           BeanMetaDataUtil.setSimpleProperty(arrayReplacement, "classes", attrs.getValue(i));
/*      */         }
/*  843 */         else if ("expr".equals(localName))
/*      */         {
/*  845 */           BeanMetaDataUtil.setSimpleProperty(arrayReplacement, "expr", attrs.getValue(i));
/*      */         }
/*  847 */         else if ("manager-bean".equals(localName))
/*      */         {
/*  849 */           util.setManagerBean(attrs.getValue(i));
/*      */         } else {
/*  851 */           if (!"manager-property".equals(localName))
/*      */             continue;
/*  853 */           util.setManagerProperty(attrs.getValue(i));
/*      */         }
/*      */       }
/*  856 */       util.setAspectManagerProperty(arrayReplacement, "manager");
/*      */ 
/*  858 */       if (name == null)
/*      */       {
/*  860 */         name = GUID.asString();
/*      */       }
/*  862 */       arrayReplacement.setName(name);
/*  863 */       BeanMetaDataUtil.setSimpleProperty(arrayReplacement, "name", name);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class InterceptorRefHandler extends DefaultElementHandler
/*      */   {
/*  793 */     public static final InterceptorRefHandler HANDLER = new InterceptorRefHandler();
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  798 */       return new AdviceData();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  804 */       BaseInterceptorData interceptorRef = (BaseInterceptorData)o;
/*  805 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  807 */         String localName = attrs.getLocalName(i);
/*  808 */         if (!"name".equals(localName))
/*      */           continue;
/*  810 */         interceptorRef.setRefName(attrs.getValue(i));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class IntroductionHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*  758 */     public static final IntroductionHandler HANDLER = new IntroductionHandler();
/*      */ 
/*      */     private IntroductionHandler()
/*      */     {
/*  756 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  763 */       return new IntroductionBeanMetaDataFactory();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  769 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*      */ 
/*  771 */       IntroductionBeanMetaDataFactory factory = (IntroductionBeanMetaDataFactory)o;
/*  772 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  774 */         String localName = attrs.getLocalName(i);
/*  775 */         if ("expr".equals(localName))
/*      */         {
/*  777 */           factory.setExpr(attrs.getValue(i));
/*      */         } else {
/*  779 */           if (!"class".equals(localName))
/*      */             continue;
/*  781 */           factory.setClazz(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class PrecedenceHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*  747 */     public static final PrecedenceHandler HANDLER = new PrecedenceHandler();
/*      */ 
/*      */     private PrecedenceHandler()
/*      */     {
/*  745 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  752 */       return new PrecedenceBeanMetaDataFactory();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class CFlowStackHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*  736 */     public static final CFlowStackHandler HANDLER = new CFlowStackHandler();
/*      */ 
/*      */     private CFlowStackHandler()
/*      */     {
/*  734 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  741 */       return new CFlowStackBeanMetaDataFactory();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class StackBeanFactoryHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*      */     private StackBeanFactoryHandler()
/*      */     {
/*  725 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  730 */       return new StackBeanMetaDataFactory();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ArrayBindBeanFactoryHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*      */     private ArrayBindBeanFactoryHandler()
/*      */     {
/*  690 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  695 */       return new ArrayBindBeanMetaDataFactory();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  701 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*      */ 
/*  703 */       ArrayBindBeanMetaDataFactory factory = (ArrayBindBeanMetaDataFactory)o;
/*  704 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  706 */         String localName = attrs.getLocalName(i);
/*  707 */         if ("type".equals(localName))
/*      */         {
/*  709 */           factory.setType(attrs.getValue(i));
/*      */         } else {
/*  711 */           if (!"name".equals(localName))
/*      */             continue;
/*  713 */           factory.setName(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public Object endElement(Object o, QName name, ElementBinding element)
/*      */     {
/*  721 */       return super.endElement(o, name, element);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class BindBeanFactoryHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*      */     private BindBeanFactoryHandler()
/*      */     {
/*  655 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  660 */       return new BindBeanMetaDataFactory();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  666 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*      */ 
/*  668 */       BindBeanMetaDataFactory factory = (BindBeanMetaDataFactory)o;
/*  669 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  671 */         String localName = attrs.getLocalName(i);
/*  672 */         if ("pointcut".equals(localName))
/*      */         {
/*  674 */           factory.setPointcut(attrs.getValue(i));
/*      */         } else {
/*  676 */           if (!"cflow".equals(localName))
/*      */             continue;
/*  678 */           factory.setCflow(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public Object endElement(Object o, QName name, ElementBinding element)
/*      */     {
/*  686 */       return super.endElement(o, name, element);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class LifecycleBeanFactoryHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*      */     private LifecycleBeanFactoryHandler()
/*      */     {
/*  588 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  593 */       String localname = name.getLocalPart();
/*  594 */       if (localname.equals("lifecycle-configure"))
/*      */       {
/*  596 */         return new ConfigureLifecycleBeanMetaDataFactory();
/*      */       }
/*  598 */       if (localname.equals("lifecycle-create"))
/*      */       {
/*  600 */         return new CreateLifecycleBeanMetaDataFactory();
/*      */       }
/*  602 */       if (localname.equals("lifecycle-describe"))
/*      */       {
/*  604 */         return new DescribeLifecycleBeanMetaDataFactory();
/*      */       }
/*  606 */       if (localname.equals("lifecycle-install"))
/*      */       {
/*  608 */         return new InstallLifecycleBeanMetaDataFactory();
/*      */       }
/*  610 */       if (localname.equals("lifecycle-instantiate"))
/*      */       {
/*  612 */         return new InstantiateLifecycleBeanMetaDataFactory();
/*      */       }
/*  614 */       if (localname.equals("lifecycle-preinstall"))
/*      */       {
/*  616 */         return new PreInstallLifecycleBeanMetaDataFactory();
/*      */       }
/*  618 */       if (localname.equals("lifecycle-start"))
/*      */       {
/*  620 */         return new StartLifecycleBeanMetaDataFactory();
/*      */       }
/*      */ 
/*  623 */       throw new IllegalStateException(name + " is not a recognized element");
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  629 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*      */ 
/*  631 */       LifecycleBeanMetaDataFactory factory = (LifecycleBeanMetaDataFactory)o;
/*  632 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  634 */         String localName = attrs.getLocalName(i);
/*  635 */         if ("classes".equals(localName))
/*      */         {
/*  637 */           factory.setClasses(attrs.getValue(i));
/*      */         }
/*  639 */         else if ("expr".equals(localName))
/*      */         {
/*  641 */           factory.setExpr(attrs.getValue(i));
/*      */         }
/*  643 */         else if ("install".equals(localName))
/*      */         {
/*  645 */           factory.setInstallMethod(attrs.getValue(i));
/*      */         } else {
/*  647 */           if (!"uninstall".equals(localName))
/*      */             continue;
/*  649 */           factory.setUninstallMethod(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AspectBeanFactoryHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*      */     private AspectBeanFactoryHandler()
/*      */     {
/*  559 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  564 */       return new AspectBeanMetaDataFactory();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  570 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*      */ 
/*  572 */       AspectBeanMetaDataFactory factory = (AspectBeanMetaDataFactory)o;
/*  573 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  575 */         String localName = attrs.getLocalName(i);
/*  576 */         if ("scope".equals(localName))
/*      */         {
/*  578 */           factory.setScope(attrs.getValue(i));
/*      */         } else {
/*  580 */           if (!"factory".equals(localName))
/*      */             continue;
/*  582 */           factory.setFactory(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DomainHandler extends AOPBeansSchemaInitializer.AspectManagerAwareBeanFactoryHandler
/*      */   {
/*  522 */     public static final DomainHandler HANDLER = new DomainHandler();
/*      */ 
/*      */     private DomainHandler()
/*      */     {
/*  520 */       super();
/*      */     }
/*      */ 
/*      */     public Object startElement(Object parent, QName name, ElementBinding element)
/*      */     {
/*  527 */       return new DomainBeanMetaDataFactory();
/*      */     }
/*      */ 
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  533 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*  534 */       DomainBeanMetaDataFactory bean = (DomainBeanMetaDataFactory)o;
/*  535 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  537 */         String localName = attrs.getLocalName(i);
/*  538 */         if ("parentFirst".equals(localName))
/*      */         {
/*  540 */           bean.setParentFirst(attrs.getValue(i));
/*      */         }
/*  542 */         else if ("inheritDefinitions".equals(localName))
/*      */         {
/*  544 */           bean.setInheritDefinitions(attrs.getValue(i));
/*      */         }
/*  546 */         else if ("inheritBindings".equals(localName))
/*      */         {
/*  548 */           BeanMetaDataUtil.setSimpleProperty(bean, "inheritBindings", attrs.getValue(i));
/*      */         } else {
/*  550 */           if (!"extends".equals(localName))
/*      */             continue;
/*  552 */           BeanMetaDataUtil.setSimpleProperty(bean, "extends", attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AspectManagerAwareBeanFactoryHandler extends BeanFactoryHandler
/*      */   {
/*      */     public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */     {
/*  502 */       super.attributes(o, elementName, element, attrs, nsCtx);
/*      */ 
/*  504 */       AspectManagerAwareBeanMetaDataFactory factory = (AspectManagerAwareBeanMetaDataFactory)o;
/*  505 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  507 */         String localName = attrs.getLocalName(i);
/*  508 */         if ("manager-bean".equals(localName))
/*      */         {
/*  510 */           factory.setManagerBean(attrs.getValue(i));
/*      */         } else {
/*  512 */           if (!"manager-property".equals(localName))
/*      */             continue;
/*  514 */           factory.setManagerProperty(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.xml.AOPBeansSchemaInitializer
 * JD-Core Version:    0.6.0
 */