/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.microcontainer.beans.AspectBinding;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractListMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class BindBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String pointcut;
/*     */   private String cflow;
/*  44 */   private List<BaseInterceptorData> interceptors = new ArrayList();
/*     */ 
/*     */   public BindBeanMetaDataFactory()
/*     */   {
/*  49 */     setBeanClass("IGNORED");
/*     */   }
/*     */ 
/*     */   public void setPointcut(String pointcut)
/*     */   {
/*  54 */     this.pointcut = pointcut;
/*     */   }
/*     */ 
/*     */   public void setCflow(String cflow)
/*     */   {
/*  59 */     this.cflow = cflow;
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/*  65 */     ArrayList result = new ArrayList();
/*     */ 
/*  68 */     AbstractBeanMetaData binding = new AbstractBeanMetaData();
/*  69 */     if (this.name == null)
/*     */     {
/*  71 */       this.name = GUID.asString();
/*     */     }
/*  73 */     binding.setName(this.name);
/*  74 */     BeanMetaDataUtil.setSimpleProperty(binding, "name", this.name);
/*  75 */     binding.setBean(AspectBinding.class.getName());
/*     */ 
/*  77 */     BeanMetaDataUtil.setSimpleProperty(binding, "pointcut", this.pointcut);
/*     */ 
/*  79 */     if (this.cflow != null)
/*     */     {
/*  81 */       BeanMetaDataUtil.setSimpleProperty(binding, "cflow", this.cflow);
/*     */     }
/*  83 */     this.util.setAspectManagerProperty(binding, "manager");
/*  84 */     result.add(binding);
/*     */     AbstractListMetaData almd;
/*     */     int i;
/*  86 */     if (this.interceptors.size() > 0)
/*     */     {
/*  88 */       almd = new AbstractListMetaData();
/*  89 */       i = 0;
/*  90 */       for (BaseInterceptorData interceptor : this.interceptors)
/*     */       {
/*  92 */         AbstractBeanMetaData bmd = new AbstractBeanMetaData(interceptor.getBeanClassName());
/*  93 */         String intName = this.name + "$" + i++;
/*  94 */         bmd.setName(intName);
/*  95 */         this.util.setAspectManagerProperty(bmd, "manager");
/*  96 */         BeanMetaDataUtil.DependencyBuilder builder = new BeanMetaDataUtil.DependencyBuilder(bmd, "binding", this.name).setState("Instantiated");
/*  97 */         BeanMetaDataUtil.setDependencyProperty(builder);
/*     */ 
/*  99 */         if ((interceptor instanceof AdviceData))
/*     */         {
/* 101 */           BeanMetaDataUtil.DependencyBuilder db = new BeanMetaDataUtil.DependencyBuilder(bmd, "aspect", interceptor.getRefName());
/* 102 */           BeanMetaDataUtil.setDependencyProperty(db);
/* 103 */           if (((AdviceData)interceptor).getAdviceMethod() != null)
/*     */           {
/* 105 */             BeanMetaDataUtil.setSimpleProperty(bmd, "aspectMethod", ((AdviceData)interceptor).getAdviceMethod());
/*     */           }
/* 107 */           BeanMetaDataUtil.setSimpleProperty(bmd, "type", ((AdviceData)interceptor).getType());
/*     */         }
/*     */         else
/*     */         {
/* 111 */           BeanMetaDataUtil.DependencyBuilder db = new BeanMetaDataUtil.DependencyBuilder(bmd, "stack", interceptor.getRefName());
/* 112 */           BeanMetaDataUtil.setDependencyProperty(db);
/*     */         }
/* 114 */         result.add(bmd);
/* 115 */         almd.add(new AbstractInjectionValueMetaData(intName));
/* 116 */         BeanMetaDataUtil.setSimpleProperty(binding, "advices", almd);
/*     */       }
/*     */     }
/*     */ 
/* 120 */     return result;
/*     */   }
/*     */ 
/*     */   public void addInterceptor(BaseInterceptorData interceptorData)
/*     */   {
/* 125 */     this.interceptors.add(interceptorData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.BindBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */