/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ 
/*     */ public class BeanMetaDataUtil
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected static final String DEFAULT_ASPECT_MANAGER = "AspectManager";
/*     */   protected String managerBean;
/*     */   protected String managerProperty;
/*     */ 
/*     */   public BeanMetaDataUtil()
/*     */   {
/*  46 */     this.managerBean = "AspectManager";
/*     */   }
/*     */ 
/*     */   public String getManager()
/*     */   {
/*  54 */     return this.managerBean;
/*     */   }
/*     */ 
/*     */   public void setManagerBean(String managerBean)
/*     */   {
/*  59 */     this.managerBean = managerBean;
/*     */   }
/*     */ 
/*     */   public String getManagerProperty()
/*     */   {
/*  64 */     return this.managerProperty;
/*     */   }
/*     */ 
/*     */   public void setManagerProperty(String aspectManagerProperty)
/*     */   {
/*  69 */     this.managerProperty = aspectManagerProperty;
/*     */   }
/*     */ 
/*     */   public static void setSimpleProperty(AbstractBeanMetaData bean, String propertyName, Object value)
/*     */   {
/*  74 */     bean.addProperty(new AbstractPropertyMetaData(propertyName, value));
/*     */   }
/*     */ 
/*     */   public static void setSimpleProperty(AbstractBeanMetaData bean, String propertyName, ValueMetaData value)
/*     */   {
/*  79 */     bean.addProperty(new AbstractPropertyMetaData(propertyName, value));
/*     */   }
/*     */ 
/*     */   public static void setDependencyProperty(DependencyBuilder builder)
/*     */   {
/*  99 */     AbstractDependencyValueMetaData advmd = new AbstractDependencyValueMetaData(builder.getDependencyBean(), builder.getDependencyProperty());
/* 100 */     if (builder.getState() != null)
/*     */     {
/* 102 */       advmd.setDependentState(new ControllerState(builder.getState()));
/*     */     }
/* 104 */     AbstractBeanMetaData bean = builder.getBean();
/* 105 */     AbstractPropertyMetaData existing = (AbstractPropertyMetaData)bean.getProperty(builder.getPropertyName());
/* 106 */     if (existing != null)
/*     */     {
/* 108 */       existing.setValue(advmd);
/*     */     }
/*     */     else
/*     */     {
/* 112 */       bean.addProperty(new AbstractPropertyMetaData(builder.getPropertyName(), advmd));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAspectManagerProperty(AbstractBeanMetaData bean, String propertyName)
/*     */   {
/* 118 */     DependencyBuilder builder = new DependencyBuilder(bean, propertyName, this.managerBean).setDependencyProperty(this.managerProperty);
/* 119 */     setDependencyProperty(builder);
/*     */   }
/*     */   public static class DependencyBuilder { AbstractBeanMetaData bean;
/*     */     String propertyName;
/*     */     String dependencyBean;
/*     */     String dependencyProperty;
/*     */     String state;
/*     */ 
/* 132 */     public DependencyBuilder(AbstractBeanMetaData bean, String propertyName, String dependencyBean) { if (bean == null)
/* 133 */         throw new IllegalArgumentException("Null bean");
/* 134 */       if (propertyName == null)
/* 135 */         throw new IllegalArgumentException("Null property name");
/* 136 */       if (dependencyBean == null)
/* 137 */         throw new IllegalArgumentException("Null dependency bean");
/* 138 */       this.bean = bean;
/* 139 */       this.propertyName = propertyName;
/* 140 */       this.dependencyBean = dependencyBean;
/*     */     }
/*     */ 
/*     */     DependencyBuilder setDependencyProperty(String dependencyProperty)
/*     */     {
/* 145 */       this.dependencyProperty = dependencyProperty;
/* 146 */       return this;
/*     */     }
/*     */ 
/*     */     DependencyBuilder setState(String state)
/*     */     {
/* 151 */       this.state = state;
/* 152 */       return this;
/*     */     }
/*     */ 
/*     */     public AbstractBeanMetaData getBean()
/*     */     {
/* 157 */       return this.bean;
/*     */     }
/*     */ 
/*     */     public String getPropertyName()
/*     */     {
/* 162 */       return this.propertyName;
/*     */     }
/*     */ 
/*     */     public String getDependencyBean()
/*     */     {
/* 167 */       return this.dependencyBean;
/*     */     }
/*     */ 
/*     */     public String getDependencyProperty()
/*     */     {
/* 172 */       return this.dependencyProperty;
/*     */     }
/*     */ 
/*     */     public String getState()
/*     */     {
/* 177 */       return this.state;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.BeanMetaDataUtil
 * JD-Core Version:    0.6.0
 */