/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import java.util.List;
/*    */ import org.jboss.aop.advice.InterceptorFactory;
/*    */ 
/*    */ public class StackEntry extends BindingEntry
/*    */ {
/*    */   Stack stack;
/*    */   List<InterceptorEntry> advices;
/*    */   InterceptorFactory[] factories;
/*    */ 
/*    */   public Stack getStack()
/*    */   {
/* 42 */     return this.stack;
/*    */   }
/*    */ 
/*    */   public void setStack(Stack stack)
/*    */   {
/* 47 */     this.stack = stack;
/*    */   }
/*    */ 
/*    */   public InterceptorFactory[] getInterceptorFactories()
/*    */   {
/* 52 */     return this.factories;
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/* 57 */     if (this.manager == null)
/*    */     {
/* 59 */       throw new IllegalArgumentException("Null manager");
/*    */     }
/* 61 */     if (this.binding == null)
/*    */     {
/* 63 */       throw new IllegalArgumentException("Null aspect binding");
/*    */     }
/* 65 */     if (this.stack == null)
/*    */     {
/* 67 */       throw new IllegalArgumentException("Null stack");
/*    */     }
/* 69 */     this.advices = this.stack.getClonedAdvices(this.binding);
/* 70 */     if (this.advices == null)
/*    */     {
/* 72 */       throw new IllegalArgumentException("Null advices");
/*    */     }
/*    */ 
/* 76 */     this.factories = new InterceptorFactory[this.advices.size()];
/* 77 */     int i = 0;
/* 78 */     for (InterceptorEntry entry : this.advices)
/*    */     {
/* 80 */       entry.start();
/* 81 */       this.factories[(i++)] = entry.getInterceptorFactory();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 87 */     this.advices = null;
/* 88 */     this.factories = null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.StackEntry
 * JD-Core Version:    0.6.0
 */