/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.pointcut.Pointcut;
/*    */ import org.jboss.aop.pointcut.PointcutExpression;
/*    */ import org.jboss.aop.pointcut.ast.ParseException;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class Prepare
/*    */ {
/*    */   protected AspectManager manager;
/* 39 */   protected String name = GUID.asString();
/*    */   protected String expr;
/*    */ 
/*    */   public AspectManager getManager()
/*    */   {
/* 45 */     return this.manager;
/*    */   }
/*    */ 
/*    */   public void setManager(AspectManager manager)
/*    */   {
/* 50 */     this.manager = manager;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 55 */     return this.name;
/*    */   }
/*    */ 
/*    */   public void setName(String name)
/*    */   {
/* 60 */     this.name = name;
/*    */   }
/*    */ 
/*    */   public String getExpr()
/*    */   {
/* 65 */     return this.expr;
/*    */   }
/*    */ 
/*    */   public void setExpr(String pointcut)
/*    */   {
/* 70 */     this.expr = pointcut;
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/* 75 */     if (this.manager == null)
/*    */     {
/* 77 */       throw new IllegalArgumentException("Null manager");
/*    */     }
/* 79 */     if ((this.expr == null) || (this.expr.length() == 0))
/*    */     {
/* 81 */       throw new IllegalArgumentException("No pointcut");
/*    */     }
/* 83 */     Pointcut p = null;
/*    */     try
/*    */     {
/* 86 */       p = new PointcutExpression(this.name, this.expr);
/*    */     }
/*    */     catch (ParseException ex)
/*    */     {
/* 90 */       throw new RuntimeException("<pointcut name='" + this.name + "' expr='" + this.expr + "'/> failed", ex);
/*    */     }
/* 92 */     this.manager.addPointcut(p);
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 97 */     this.manager.removePointcut(this.name);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.Prepare
 * JD-Core Version:    0.6.0
 */