/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ import org.jboss.aop.pointcut.PointcutExpression;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ 
/*     */ public class NamedPointcut
/*     */ {
/*     */   AspectManager manager;
/*     */   String name;
/*     */   String expr;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  45 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  50 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  55 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  60 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  65 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public void setExpr(String expr)
/*     */   {
/*  70 */     this.expr = expr;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  75 */     if (this.manager == null)
/*     */     {
/*  77 */       throw new IllegalArgumentException("Null manager");
/*     */     }
/*  79 */     if ((this.name == null) || (this.name.length() == 0))
/*     */     {
/*  81 */       throw new IllegalArgumentException("No name");
/*     */     }
/*  83 */     if ((this.expr == null) || (this.expr.length() == 0))
/*     */     {
/*  85 */       throw new IllegalArgumentException("No expr");
/*     */     }
/*     */ 
/*  88 */     Pointcut p = null;
/*     */     try
/*     */     {
/*  91 */       p = new PointcutExpression(this.name, this.expr);
/*  92 */       this.manager.addPointcut(p);
/*     */     }
/*     */     catch (ParseException ex)
/*     */     {
/*  96 */       throw new RuntimeException("<pointcut name='" + this.name + "' expr='" + this.expr + "'/> failed", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 102 */     this.manager.removePointcut(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.NamedPointcut
 * JD-Core Version:    0.6.0
 */