/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.Domain;
/*    */ import org.jboss.metadata.plugins.scope.ApplicationScope;
/*    */ import org.jboss.metadata.plugins.scope.DeploymentScope;
/*    */ import org.jboss.metadata.spi.MetaData;
/*    */ import org.jboss.metadata.spi.stack.MetaDataStack;
/*    */ import org.jboss.util.JBossStringBuilder;
/*    */ 
/*    */ public class AspectManagerFactory
/*    */ {
/*    */   public static AspectManager getAspectManager()
/*    */   {
/* 41 */     return getAspectManager(MetaDataStack.peek());
/*    */   }
/*    */ 
/*    */   public static AspectManager getAspectManager(MetaData md)
/*    */   {
/* 46 */     AspectManager manager = AspectManager.instance();
/* 47 */     if (md != null)
/*    */     {
/* 49 */       ApplicationScope app = (ApplicationScope)md.getMetaData(ApplicationScope.class);
/* 50 */       DeploymentScope dep = (DeploymentScope)md.getMetaData(DeploymentScope.class);
/* 51 */       if ((app != null) && (dep != null))
/*    */       {
/* 53 */         JBossStringBuilder fqn = new JBossStringBuilder("/");
/* 54 */         AspectManager sub = null;
/* 55 */         if (app != null)
/*    */         {
/* 57 */           String name = "APPLICATION=" + app.value();
/* 58 */           fqn.append(name);
/* 59 */           fqn.append("/");
/* 60 */           sub = manager.findManagerByName(fqn.toString());
/* 61 */           if (sub == null)
/*    */           {
/* 63 */             sub = createNewDomain(manager, name);
/*    */           }
/*    */         }
/*    */ 
/* 67 */         if (dep != null)
/*    */         {
/* 69 */           String name = "DEPLOYMENT=" + dep.value();
/* 70 */           fqn.append(name);
/* 71 */           fqn.append("/");
/* 72 */           AspectManager parent = sub;
/* 73 */           sub = manager.findManagerByName(fqn.toString());
/* 74 */           if (sub == null)
/*    */           {
/* 76 */             sub = createNewDomain(parent, name);
/*    */           }
/*    */         }
/* 79 */         return sub;
/*    */       }
/*    */     }
/* 82 */     return manager;
/*    */   }
/*    */ 
/*    */   private static AspectManager createNewDomain(AspectManager parent, String name)
/*    */   {
/* 87 */     Domain domain = new Domain(parent, name, true);
/* 88 */     domain.setInheritsBindings(true);
/* 89 */     domain.setInheritsDeclarations(true);
/* 90 */     return domain;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.AspectManagerFactory
 * JD-Core Version:    0.6.0
 */