/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*    */ 
/*    */ public abstract class AbstractAnnotation
/*    */ {
/*    */   protected AspectManager manager;
/*    */   private String expr;
/*    */   private String annotation;
/* 37 */   private boolean invisible = false;
/*    */   protected AnnotationIntroduction intro;
/*    */ 
/*    */   public AspectManager getManager()
/*    */   {
/* 42 */     return this.manager;
/*    */   }
/*    */ 
/*    */   public void setManager(AspectManager manager)
/*    */   {
/* 47 */     this.manager = manager;
/*    */   }
/*    */ 
/*    */   public String getExpr()
/*    */   {
/* 52 */     return this.expr;
/*    */   }
/*    */ 
/*    */   public void setExpr(String expr)
/*    */   {
/* 57 */     this.expr = expr;
/*    */   }
/*    */ 
/*    */   public String getAnnotation()
/*    */   {
/* 62 */     return this.annotation;
/*    */   }
/*    */ 
/*    */   public void setAnnotation(String annotation)
/*    */   {
/* 67 */     this.annotation = annotation;
/*    */   }
/*    */ 
/*    */   public boolean isInvisible()
/*    */   {
/* 72 */     return this.invisible;
/*    */   }
/*    */ 
/*    */   public void setInvisible(boolean invisible)
/*    */   {
/* 77 */     this.invisible = invisible;
/*    */   }
/*    */ 
/*    */   public abstract void start();
/*    */ 
/*    */   protected AnnotationIntroduction validateAndCreate() {
/* 84 */     if (this.manager == null)
/*    */     {
/* 86 */       throw new IllegalArgumentException("Null manager");
/*    */     }
/* 88 */     if (this.expr == null)
/*    */     {
/* 90 */       throw new IllegalArgumentException("Null expr");
/*    */     }
/* 92 */     if (this.annotation == null)
/*    */     {
/* 94 */       throw new IllegalArgumentException("Null annotation");
/*    */     }
/*    */ 
/* 97 */     this.intro = AnnotationIntroduction.createComplexAnnotationIntroduction(this.expr, this.annotation, this.invisible);
/* 98 */     return this.intro;
/*    */   }
/*    */ 
/*    */   public abstract void stop();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.AbstractAnnotation
 * JD-Core Version:    0.6.0
 */