/*     */ package org.jboss.aop.microcontainer.aspects.jndi;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Properties;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class JndiLifecycleCallback
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(JndiLifecycleCallback.class);
/*     */   private Properties env;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  48 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Properties getEnv()
/*     */   {
/*  57 */     return this.env;
/*     */   }
/*     */ 
/*     */   public void setEnv(Properties env)
/*     */   {
/*  66 */     this.env = env;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  79 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  80 */     KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
/*     */ 
/*  82 */     boolean trace = log.isTraceEnabled();
/*  83 */     JndiBinding bindingInfo = (JndiBinding)invocation.resolveClassAnnotation(JndiBinding.class);
/*  84 */     if (trace) {
/*  85 */       log.trace("Checking method: " + mi.getMethod() + ", bindingInfo: " + bindingInfo);
/*     */     }
/*  87 */     if (("setKernelControllerContext".equals(mi.getMethod().getName())) && (bindingInfo != null))
/*     */     {
/*  89 */       InitialContext ctx = new InitialContext(this.env);
/*  90 */       Object target = context.getTarget();
/*  91 */       Util.bind(ctx, bindingInfo.name(), target);
/*  92 */       if (trace)
/*  93 */         log.trace("Bound to: " + bindingInfo.name());
/*  94 */       String[] aliases = bindingInfo.aliases();
/*  95 */       if (aliases != null)
/*     */       {
/*  97 */         for (String name : aliases)
/*     */         {
/*  99 */           Util.bind(ctx, name, target);
/* 100 */           if (trace) {
/* 101 */             log.trace("Bound to alias: " + bindingInfo.name());
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 106 */     else if (bindingInfo != null)
/*     */     {
/* 108 */       InitialContext ctx = new InitialContext(this.env);
/* 109 */       Util.unbind(ctx, bindingInfo.name());
/* 110 */       if (trace)
/* 111 */         log.trace("Unbound: " + bindingInfo.name());
/* 112 */       String[] aliases = bindingInfo.aliases();
/* 113 */       if (aliases != null)
/*     */       {
/* 115 */         for (String name : aliases)
/*     */         {
/* 117 */           Util.unbind(ctx, name);
/* 118 */           if (trace)
/* 119 */             log.trace("Unbound alias: " + bindingInfo.name());
/*     */         }
/*     */       }
/*     */     }
/* 123 */     else if (trace)
/*     */     {
/* 125 */       log.trace("Ignoring null binding info");
/*     */     }
/*     */ 
/* 128 */     return null;
/*     */   }
/*     */ 
/*     */   public void install(ControllerContext context) throws Exception
/*     */   {
/* 133 */     JndiBinding bindingInfo = readJndiAnnotation(context);
/* 134 */     boolean trace = log.isTraceEnabled();
/* 135 */     if (trace) {
/* 136 */       log.trace("Binding into JNDI: " + context.getName() + ", bindingInfo: " + bindingInfo);
/*     */     }
/* 138 */     InitialContext ctx = new InitialContext(this.env);
/* 139 */     Object target = context.getTarget();
/* 140 */     Util.bind(ctx, bindingInfo.name(), target);
/* 141 */     if (trace)
/* 142 */       log.trace("Bound to: " + bindingInfo.name());
/* 143 */     String[] aliases = bindingInfo.aliases();
/* 144 */     if (aliases != null)
/*     */     {
/* 146 */       for (String name : aliases)
/*     */       {
/* 148 */         Util.bind(ctx, name, target);
/* 149 */         if (trace)
/* 150 */           log.trace("Bound to alias: " + bindingInfo.name());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerContext context) throws Exception
/*     */   {
/* 157 */     JndiBinding bindingInfo = readJndiAnnotation(context);
/* 158 */     boolean trace = log.isTraceEnabled();
/* 159 */     InitialContext ctx = new InitialContext(this.env);
/* 160 */     Util.unbind(ctx, bindingInfo.name());
/* 161 */     if (trace)
/* 162 */       log.trace("Unbound: " + bindingInfo.name());
/* 163 */     String[] aliases = bindingInfo.aliases();
/* 164 */     if (aliases != null)
/*     */     {
/* 166 */       for (String name : aliases)
/*     */       {
/* 168 */         Util.unbind(ctx, name);
/* 169 */         if (trace)
/* 170 */           log.trace("Unbound alias: " + bindingInfo.name());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private JndiBinding readJndiAnnotation(ControllerContext context)
/*     */   {
/* 177 */     MetaData metaData = context.getScopeInfo().getMetaData();
/* 178 */     if (metaData != null)
/* 179 */       return (JndiBinding)metaData.getAnnotation(JndiBinding.class);
/* 180 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.aspects.jndi.JndiLifecycleCallback
 * JD-Core Version:    0.6.0
 */