/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.util.MarshalledValue;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ 
/*     */ public class SimpleMetaData
/*     */   implements MetaDataResolver, Externalizable
/*     */ {
/*     */   static final long serialVersionUID = -3873275588469743345L;
/*     */   protected HashMap metaData;
/*     */ 
/*     */   public SimpleMetaData()
/*     */   {
/*  39 */     this.metaData = new HashMap();
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/*  77 */     return this.metaData.size();
/*     */   }
/*     */ 
/*     */   public synchronized HashSet tags()
/*     */   {
/*  82 */     return new HashSet(this.metaData.keySet());
/*     */   }
/*     */ 
/*     */   public synchronized HashMap tag(String name)
/*     */   {
/*  87 */     HashMap map = (HashMap)this.metaData.get(name);
/*  88 */     if (map == null) return null;
/*  89 */     return (HashMap)map.clone();
/*     */   }
/*     */ 
/*     */   public synchronized boolean hasTag(String name)
/*     */   {
/*  94 */     return this.metaData.get(name) != null;
/*     */   }
/*     */ 
/*     */   public void tag(Object tag)
/*     */   {
/* 105 */     addMetaData(tag, "$tagged$", new Object(), PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public void addMetaData(Object tag, Object attr, Object value)
/*     */   {
/* 110 */     addMetaData(tag, attr, value, PayloadKey.MARSHALLED);
/*     */   }
/*     */ 
/*     */   public synchronized void addMetaData(Object tag, Object attr, Object value, PayloadKey type)
/*     */   {
/* 115 */     HashMap groupData = (HashMap)this.metaData.get(tag);
/* 116 */     if (groupData == null)
/*     */     {
/* 118 */       groupData = new HashMap();
/* 119 */       this.metaData.put(tag, groupData);
/*     */     }
/* 121 */     MetaDataValue val = new MetaDataValue(type, value);
/* 122 */     groupData.put(attr, val);
/*     */   }
/*     */ 
/*     */   public synchronized Object getMetaData(Object tag, Object attr)
/*     */   {
/*     */     try
/*     */     {
/* 129 */       HashMap groupData = (HashMap)this.metaData.get(tag);
/* 130 */       if (groupData == null) return null;
/* 131 */       MetaDataValue val = (MetaDataValue)groupData.get(attr);
/* 132 */       if (val == null) return null;
/* 133 */       return val.get();
/*     */     }
/*     */     catch (IOException ioex)
/*     */     {
/* 137 */       throw new RuntimeException("failed on MarshalledValue", ioex);
/*     */     }
/*     */     catch (ClassNotFoundException ex) {
/*     */     }
/* 141 */     throw new RuntimeException("failed on MarshalledValue", ex);
/*     */   }
/*     */ 
/*     */   public synchronized void removeMetaData(Object tag, Object attr)
/*     */   {
/* 147 */     HashMap groupData = (HashMap)this.metaData.get(tag);
/* 148 */     if (groupData != null)
/*     */     {
/* 150 */       groupData.remove(attr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void removeGroupData(Object group)
/*     */   {
/* 156 */     this.metaData.remove(group);
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 161 */     this.metaData.clear();
/*     */   }
/*     */ 
/*     */   public synchronized void mergeIn(SimpleMetaData data)
/*     */   {
/* 169 */     Iterator it = data.metaData.keySet().iterator();
/* 170 */     while (it.hasNext())
/*     */     {
/* 172 */       Object tag = it.next();
/* 173 */       HashMap attrs = (HashMap)data.metaData.get(tag);
/* 174 */       HashMap map = (HashMap)this.metaData.get(tag);
/* 175 */       if (map == null)
/*     */       {
/* 177 */         map = new HashMap();
/* 178 */         this.metaData.put(tag, map);
/*     */       }
/* 180 */       map.putAll(attrs);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized Object resolve(Invocation invocation, Object tag, Object attr)
/*     */   {
/* 186 */     return getMetaData(tag, attr);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getAllMetaData(Invocation invocation)
/*     */   {
/* 191 */     return this;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 198 */     Iterator it = this.metaData.keySet().iterator();
/* 199 */     while (it.hasNext())
/*     */     {
/* 201 */       Object group = it.next();
/* 202 */       HashMap map = (HashMap)this.metaData.get(group);
/*     */ 
/* 204 */       if ((map != null) && (map.size() > 0))
/*     */       {
/* 206 */         boolean groupWritten = false;
/* 207 */         Iterator attrs = map.keySet().iterator();
/* 208 */         while (attrs.hasNext())
/*     */         {
/* 210 */           Object attr = attrs.next();
/*     */ 
/* 212 */           MetaDataValue value = (MetaDataValue)map.get(attr);
/* 213 */           if (value.type != PayloadKey.TRANSIENT) {
/* 214 */             if (!groupWritten)
/*     */             {
/* 216 */               groupWritten = true;
/* 217 */               out.writeObject(group);
/*     */             }
/* 219 */             out.writeObject(attr);
/* 220 */             if (value.type == PayloadKey.AS_IS)
/*     */             {
/* 222 */               out.writeObject(value.value);
/*     */             }
/*     */             else
/*     */             {
/* 226 */               out.writeObject(new MarshalledValue(value.value));
/*     */             }
/*     */           }
/*     */         }
/* 229 */         if (groupWritten) out.writeObject(null);
/*     */       }
/*     */     }
/* 232 */     out.writeObject(null);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 239 */     this.metaData = new HashMap();
/*     */     Object group;
/* 241 */     while ((group = in.readObject()) != null)
/*     */     {
/* 244 */       HashMap map = new HashMap();
/* 245 */       this.metaData.put(group, map);
/*     */       Object attr;
/* 247 */       while ((attr = in.readObject()) != null)
/*     */       {
/* 250 */         Object obj = in.readObject();
/* 251 */         if ((obj instanceof MarshalledValue))
/*     */         {
/* 253 */           map.put(attr, new MetaDataValue(PayloadKey.MARSHALLED, obj));
/*     */         }
/*     */         else
/*     */         {
/* 257 */           map.put(attr, new MetaDataValue(PayloadKey.AS_IS, obj));
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 265 */     StringBuffer sb = new StringBuffer(100);
/* 266 */     sb.append("[");
/* 267 */     sb.append("metaData=").append(this.metaData);
/* 268 */     sb.append("]");
/* 269 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public class MetaDataValue
/*     */     implements Serializable
/*     */   {
/*     */     static final long serialVersionUID = -8024138149680591337L;
/*     */     public final PayloadKey type;
/*     */     public Object value;
/*     */ 
/*     */     public MetaDataValue(PayloadKey type, Object value)
/*     */     {
/*  49 */       this.type = type;
/*  50 */       this.value = value;
/*     */     }
/*     */ 
/*     */     public Object get()
/*     */       throws IOException, ClassNotFoundException
/*     */     {
/*  56 */       if ((this.value instanceof MarshalledValue))
/*     */       {
/*  58 */         this.value = ((MarshalledValue)this.value).get();
/*     */       }
/*  60 */       return this.value;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/*  65 */       StringBuffer sb = new StringBuffer(100);
/*  66 */       sb.append("[");
/*  67 */       sb.append("type=").append(this.type);
/*  68 */       sb.append("value=").append(this.value);
/*  69 */       sb.append("]");
/*  70 */       return sb.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.SimpleMetaData
 * JD-Core Version:    0.6.0
 */