/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.expressions.ConstructorExpression;
/*     */ import org.jboss.aop.expressions.MethodExpression;
/*     */ import org.jboss.aop.util.XmlHelper;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class SimpleClassMetaDataLoader
/*     */   implements ClassMetaDataLoader
/*     */ {
/*  51 */   public static final SimpleClassMetaDataLoader singleton = new SimpleClassMetaDataLoader();
/*     */ 
/*     */   public ClassMetaDataBinding importMetaData(Element element, String name, String tag, String classExpr)
/*     */     throws Exception
/*     */   {
/*  56 */     SimpleClassMetaDataBinding data = new SimpleClassMetaDataBinding(this, name, tag, classExpr);
/*  57 */     Element defaultElement = XmlHelper.getOptionalChild(element, "default");
/*  58 */     if (defaultElement != null)
/*     */     {
/*  60 */       NodeList children = defaultElement.getChildNodes();
/*  61 */       boolean hasTag = false;
/*  62 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/*  64 */         if (children.item(i).getNodeType() != 1)
/*     */           continue;
/*  66 */         Element child = (Element)children.item(i);
/*  67 */         String attr = child.getTagName();
/*  68 */         String val = XmlHelper.getElementContent(child, "");
/*  69 */         data.addDefaultMetaData(tag, attr, val);
/*  70 */         hasTag = true;
/*     */       }
/*     */ 
/*  73 */       if (!hasTag) data.addDefaultMetaData(tag, "$tagged$", new Object());
/*     */     }
/*     */ 
/*  76 */     Element classElement = XmlHelper.getOptionalChild(element, "class");
/*  77 */     if (classElement != null)
/*     */     {
/*  79 */       NodeList children = classElement.getChildNodes();
/*  80 */       boolean hasTag = false;
/*  81 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/*  83 */         if (children.item(i).getNodeType() != 1)
/*     */           continue;
/*  85 */         Element child = (Element)children.item(i);
/*  86 */         String attr = child.getTagName();
/*  87 */         String val = XmlHelper.getElementContent(child, "");
/*  88 */         data.addClassMetaData(tag, attr, val);
/*  89 */         hasTag = true;
/*     */       }
/*     */ 
/*  92 */       if (!hasTag)
/*     */       {
/*  94 */         data.addClassMetaData(tag, "$tagged$", new Object());
/*     */       }
/*     */     }
/*     */ 
/*  98 */     Iterator it = XmlHelper.getChildrenByTagName(element, "method");
/*  99 */     while (it.hasNext())
/*     */     {
/* 101 */       Element method = (Element)it.next();
/* 102 */       String methodName = method.getAttribute("name");
/* 103 */       String expr = method.getAttribute("expr");
/* 104 */       if ((methodName != null) && (methodName.equals("")))
/*     */       {
/* 106 */         methodName = null;
/*     */       }
/* 108 */       if ((expr != null) && (expr.equals("")))
/*     */       {
/* 110 */         expr = null;
/*     */       }
/* 112 */       if ((expr == null) && (methodName == null)) throw new RuntimeException("neither a name or expr attribute has been defined");
/* 113 */       if ((expr != null) && (methodName != null)) throw new RuntimeException("cannot specify a name and expr in same place");
/*     */ 
/* 115 */       if ((expr == null) && (methodName != null))
/*     */       {
/* 117 */         expr = "* " + methodName + "(..)";
/*     */       }
/*     */ 
/* 120 */       NodeList children = method.getChildNodes();
/* 121 */       boolean hadTag = false;
/* 122 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/* 124 */         if (children.item(i).getNodeType() != 1)
/*     */           continue;
/* 126 */         Element child = (Element)children.item(i);
/* 127 */         String attr = child.getTagName();
/* 128 */         String val = XmlHelper.getElementContent(child, "");
/* 129 */         data.queueMethodMetaData(expr, tag, attr, val);
/* 130 */         hadTag = true;
/*     */       }
/*     */ 
/* 133 */       if (!hadTag)
/*     */       {
/* 136 */         data.queueMethodMetaData(expr, tag, "$tagged$", new Object());
/*     */       }
/*     */     }
/*     */ 
/* 140 */     it = XmlHelper.getChildrenByTagName(element, "field");
/* 141 */     while (it.hasNext())
/*     */     {
/* 143 */       Element field = (Element)it.next();
/* 144 */       String fieldName = field.getAttribute("name");
/* 145 */       NodeList children = field.getChildNodes();
/* 146 */       boolean hadTag = false;
/* 147 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/* 149 */         if (children.item(i).getNodeType() != 1)
/*     */           continue;
/* 151 */         Element child = (Element)children.item(i);
/* 152 */         String attr = child.getTagName();
/* 153 */         String val = XmlHelper.getElementContent(child, "");
/* 154 */         data.queueFieldMetaData(fieldName, tag, attr, val);
/* 155 */         hadTag = true;
/*     */       }
/*     */ 
/* 158 */       if (!hadTag)
/*     */       {
/* 161 */         data.queueFieldMetaData(fieldName, tag, "$tagged$", new Object());
/*     */       }
/*     */     }
/* 164 */     it = XmlHelper.getChildrenByTagName(element, "constructor");
/* 165 */     while (it.hasNext())
/*     */     {
/* 167 */       Element field = (Element)it.next();
/* 168 */       String expr = field.getAttribute("expr");
/* 169 */       NodeList children = field.getChildNodes();
/* 170 */       boolean hadTag = false;
/* 171 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/* 173 */         if (children.item(i).getNodeType() != 1)
/*     */           continue;
/* 175 */         Element child = (Element)children.item(i);
/* 176 */         String attr = child.getTagName();
/* 177 */         String val = XmlHelper.getElementContent(child, "");
/* 178 */         data.queueConstructorMetaData(expr, tag, attr, val);
/* 179 */         hadTag = true;
/*     */       }
/*     */ 
/* 182 */       if (!hadTag)
/*     */       {
/* 185 */         data.queueConstructorMetaData(expr, tag, "$tagged$", new Object());
/*     */       }
/*     */     }
/* 188 */     return data;
/*     */   }
/*     */ 
/*     */   public void bind(Advisor advisor, ClassMetaDataBinding data, Method[] methods, Field[] fields, Constructor[] constructors) throws Exception
/*     */   {
/* 193 */     SimpleClassMetaDataBinding meta = (SimpleClassMetaDataBinding)data;
/* 194 */     SimpleMetaData defaultData = advisor.getDefaultMetaData();
/* 195 */     defaultData.mergeIn(meta.getDefaultMetaData());
/* 196 */     SimpleMetaData classData = advisor.getClassMetaData();
/* 197 */     classData.mergeIn(meta.getClassMetaData());
/*     */ 
/* 200 */     if (methods != null)
/*     */     {
/* 202 */       MethodMetaData methodData = advisor.getMethodMetaData();
/* 203 */       bindMethodMetaData(advisor, meta, methodData, methods);
/*     */     }
/*     */ 
/* 206 */     if (fields != null)
/*     */     {
/* 208 */       FieldMetaData fieldData = advisor.getFieldMetaData();
/* 209 */       bindFieldMetaData(meta, fieldData, fields);
/*     */     }
/* 211 */     if (constructors != null)
/*     */     {
/* 213 */       ConstructorMetaData condata = advisor.getConstructorMetaData();
/* 214 */       bindConstructorMetaData(meta, condata, constructors);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindMethodMetaData(Advisor advisor, SimpleClassMetaDataBinding data, MethodMetaData methodMetaData, Method[] advisedMethods)
/*     */   {
/* 220 */     if (advisor.getClazz() == null)
/*     */     {
/* 224 */       return;
/*     */     }
/*     */ 
/* 227 */     boolean exactMatch = data.matches(advisor, advisor.getClazz());
/* 228 */     ArrayList queuedData = data.getQueuedMethodMetaData();
/* 229 */     for (int i = 0; i < queuedData.size(); i++)
/*     */     {
/* 231 */       SimpleClassMetaDataBinding.QueuedMethodMetaData queued = (SimpleClassMetaDataBinding.QueuedMethodMetaData)queuedData.get(i);
/* 232 */       for (int j = 0; j < advisedMethods.length; j++)
/*     */       {
/* 234 */         if (!queued.expr.matches(advisedMethods[j]))
/*     */           continue;
/* 236 */         boolean add = true;
/* 237 */         if (advisor.chainOverridingForInheritedMethods())
/*     */         {
/* 241 */           if (!exactMatch)
/*     */           {
/* 244 */             add = advisor.getClazz() != advisedMethods[j].getDeclaringClass();
/*     */ 
/* 246 */             if (add)
/*     */             {
/* 248 */               if (methodMetaData.getMethodMetaData(advisedMethods[j], queued.tag, queued.attr) != null)
/*     */               {
/* 250 */                 add = methodMetaData.tagWasMatchedInexactly(advisedMethods[j], queued.tag, queued.attr);
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 256 */         if (!add)
/*     */           continue;
/* 258 */         methodMetaData.addMethodMetaData(advisedMethods[j], queued.tag, queued.attr, queued.value, exactMatch);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindFieldMetaData(SimpleClassMetaDataBinding data, FieldMetaData fieldMetaData, Field[] advisedFields)
/*     */   {
/* 267 */     ArrayList queuedData = data.getQueuedFieldMetaData();
/* 268 */     for (int i = 0; i < queuedData.size(); i++)
/*     */     {
/* 270 */       SimpleClassMetaDataBinding.QueuedMetaData queued = (SimpleClassMetaDataBinding.QueuedMetaData)queuedData.get(i);
/* 271 */       for (int j = 0; j < advisedFields.length; j++)
/*     */       {
/* 273 */         String fieldName = advisedFields[j].getName();
/* 274 */         if (!queued.matches(fieldName))
/*     */           continue;
/* 276 */         fieldMetaData.addFieldMetaData(advisedFields[j], queued.tag, queued.attr, queued.value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindConstructorMetaData(SimpleClassMetaDataBinding data, ConstructorMetaData conMetaData, Constructor[] advisedCons)
/*     */   {
/* 284 */     ArrayList queuedData = data.getQueuedConstructorMetaData();
/* 285 */     for (int i = 0; i < queuedData.size(); i++)
/*     */     {
/* 287 */       SimpleClassMetaDataBinding.QueuedConstructorMetaData queued = (SimpleClassMetaDataBinding.QueuedConstructorMetaData)queuedData.get(i);
/* 288 */       ConstructorExpression expression = queued.expr;
/* 289 */       for (int j = 0; j < advisedCons.length; j++)
/*     */       {
/* 291 */         if (!expression.matchParamsOnly(advisedCons[j]))
/*     */           continue;
/* 293 */         conMetaData.addConstructorMetaData(advisedCons[j], queued.tag, queued.attr, queued.value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void bind(Advisor advisor, ClassMetaDataBinding data, CtMethod[] methods, CtField[] fields, CtConstructor[] constructors)
/*     */     throws Exception
/*     */   {
/* 301 */     SimpleClassMetaDataBinding meta = (SimpleClassMetaDataBinding)data;
/* 302 */     SimpleMetaData defaultData = advisor.getDefaultMetaData();
/* 303 */     defaultData.mergeIn(meta.getDefaultMetaData());
/* 304 */     SimpleMetaData classData = advisor.getClassMetaData();
/* 305 */     classData.mergeIn(meta.getClassMetaData());
/* 306 */     if (methods != null)
/*     */     {
/* 308 */       MethodMetaData methodData = advisor.getMethodMetaData();
/* 309 */       bindMethodMetaData(meta, methodData, methods);
/*     */     }
/*     */ 
/* 312 */     if (fields != null)
/*     */     {
/* 314 */       FieldMetaData fieldData = advisor.getFieldMetaData();
/* 315 */       bindFieldMetaData(meta, fieldData, fields);
/*     */     }
/* 317 */     if (constructors != null)
/*     */     {
/* 319 */       ConstructorMetaData condata = advisor.getConstructorMetaData();
/* 320 */       bindConstructorMetaData(meta, condata, constructors);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindMethodMetaData(SimpleClassMetaDataBinding data, MethodMetaData methodMetaData, CtMethod[] advisedMethods)
/*     */     throws NotFoundException
/*     */   {
/* 327 */     ArrayList queuedData = data.getQueuedMethodMetaData();
/* 328 */     for (int i = 0; i < queuedData.size(); i++)
/*     */     {
/* 330 */       SimpleClassMetaDataBinding.QueuedMethodMetaData queued = (SimpleClassMetaDataBinding.QueuedMethodMetaData)queuedData.get(i);
/* 331 */       for (int j = 0; j < advisedMethods.length; j++)
/*     */       {
/* 333 */         if (!queued.expr.matches(advisedMethods[j]))
/*     */           continue;
/* 335 */         methodMetaData.addMethodMetaData(advisedMethods[j], queued.tag, queued.attr, queued.value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindFieldMetaData(SimpleClassMetaDataBinding data, FieldMetaData fieldMetaData, CtField[] advisedFields)
/*     */   {
/* 343 */     ArrayList queuedData = data.getQueuedFieldMetaData();
/* 344 */     for (int i = 0; i < queuedData.size(); i++)
/*     */     {
/* 346 */       SimpleClassMetaDataBinding.QueuedMetaData queued = (SimpleClassMetaDataBinding.QueuedMetaData)queuedData.get(i);
/* 347 */       for (int j = 0; j < advisedFields.length; j++)
/*     */       {
/* 349 */         String fieldName = advisedFields[j].getName();
/* 350 */         if (!queued.matches(fieldName))
/*     */           continue;
/* 352 */         fieldMetaData.addFieldMetaData(advisedFields[j].getName(), queued.tag, queued.attr, queued.value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindConstructorMetaData(SimpleClassMetaDataBinding data, ConstructorMetaData conMetaData, CtConstructor[] advisedCons)
/*     */     throws NotFoundException
/*     */   {
/* 360 */     ArrayList queuedData = data.getQueuedConstructorMetaData();
/* 361 */     for (int i = 0; i < queuedData.size(); i++)
/*     */     {
/* 363 */       SimpleClassMetaDataBinding.QueuedConstructorMetaData queued = (SimpleClassMetaDataBinding.QueuedConstructorMetaData)queuedData.get(i);
/* 364 */       ConstructorExpression expression = queued.expr;
/* 365 */       for (int j = 0; j < advisedCons.length; j++)
/*     */       {
/* 367 */         if (!expression.matchParamsOnly(advisedCons[j]))
/*     */           continue;
/* 369 */         conMetaData.addConstructorMetaData(advisedCons[j], queued.tag, queued.attr, queued.value);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.SimpleClassMetaDataLoader
 * JD-Core Version:    0.6.0
 */