/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import org.jboss.aop.expressions.ConstructorExpression;
/*     */ import org.jboss.aop.expressions.MethodExpression;
/*     */ 
/*     */ public class SimpleClassMetaDataBinding extends ClassMetaDataBinding
/*     */ {
/*  96 */   protected SimpleMetaData defaultMetaData = new SimpleMetaData();
/*  97 */   protected SimpleMetaData classMetaData = new SimpleMetaData();
/*  98 */   protected ArrayList queuedMethodMetaData = new ArrayList();
/*  99 */   protected ArrayList queuedFieldMetaData = new ArrayList();
/* 100 */   protected ArrayList queuedConstructorMetaData = new ArrayList();
/*     */ 
/*     */   public SimpleClassMetaDataBinding(ClassMetaDataLoader loader, String name, String tag, String expr)
/*     */   {
/* 104 */     super(loader, name, tag, expr);
/*     */   }
/*     */ 
/*     */   public void addDefaultMetaData(String tag, String attr, Object value)
/*     */   {
/* 109 */     this.defaultMetaData.addMetaData(tag, attr, value);
/*     */   }
/*     */ 
/*     */   public void addClassMetaData(String tag, String attr, Object value)
/*     */   {
/* 114 */     this.classMetaData.addMetaData(tag, attr, value);
/*     */   }
/*     */ 
/*     */   public void queueMethodMetaData(String methodExpr, String tag, String attr, Object value)
/*     */   {
/* 122 */     this.queuedMethodMetaData.add(new QueuedMethodMetaData(methodExpr, tag, attr, value));
/*     */   }
/*     */ 
/*     */   public ArrayList getQueuedMethodMetaData()
/*     */   {
/* 127 */     return this.queuedMethodMetaData;
/*     */   }
/*     */ 
/*     */   public void queueFieldMetaData(String fieldExpr, String tag, String attr, Object value)
/*     */   {
/* 135 */     this.queuedFieldMetaData.add(new QueuedMetaData(fieldExpr, tag, attr, value));
/*     */   }
/*     */ 
/*     */   public ArrayList getQueuedFieldMetaData()
/*     */   {
/* 140 */     return this.queuedFieldMetaData;
/*     */   }
/*     */ 
/*     */   public void queueConstructorMetaData(String constructorExpr, String tag, String attr, Object value)
/*     */   {
/* 148 */     this.queuedConstructorMetaData.add(new QueuedConstructorMetaData(constructorExpr, tag, attr, value));
/*     */   }
/*     */ 
/*     */   public ArrayList getQueuedConstructorMetaData()
/*     */   {
/* 153 */     return this.queuedConstructorMetaData;
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getDefaultMetaData()
/*     */   {
/* 158 */     return this.defaultMetaData;
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getClassMetaData()
/*     */   {
/* 163 */     return this.classMetaData;
/*     */   }
/*     */ 
/*     */   public class QueuedConstructorMetaData
/*     */   {
/*     */     public ConstructorExpression expr;
/*     */     public String tag;
/*     */     public String attr;
/*     */     public Object value;
/*     */ 
/*     */     public QueuedConstructorMetaData(String expr, String tag, String attr, Object value)
/*     */     {
/*  89 */       this.expr = new ConstructorExpression(expr);
/*  90 */       this.tag = tag;
/*  91 */       this.attr = attr;
/*  92 */       this.value = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public class QueuedMethodMetaData
/*     */   {
/*     */     public MethodExpression expr;
/*     */     public String tag;
/*     */     public String attr;
/*     */     public Object value;
/*     */ 
/*     */     public QueuedMethodMetaData(String expr, String tag, String attr, Object value)
/*     */     {
/*  73 */       this.expr = new MethodExpression(expr);
/*  74 */       this.tag = tag;
/*  75 */       this.attr = attr;
/*  76 */       this.value = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public class QueuedMetaData
/*     */   {
/*     */     protected Pattern expr;
/*     */     public String tag;
/*     */     public String attr;
/*     */     public Object value;
/*     */ 
/*     */     public QueuedMetaData(String exp, String tag, String attr, Object value)
/*     */     {
/*  48 */       exp = exp.replaceAll("\\.", "\\\\.");
/*  49 */       exp = exp.replaceAll("\\*", ".*");
/*  50 */       this.expr = Pattern.compile(exp);
/*  51 */       this.tag = tag;
/*  52 */       this.attr = attr;
/*  53 */       this.value = value;
/*     */     }
/*     */     public String getExpr() {
/*  56 */       return this.expr.toString();
/*     */     }
/*     */     public boolean matches(String match) {
/*  59 */       Matcher m = this.expr.matcher(match);
/*  60 */       return m.matches();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.SimpleClassMetaDataBinding
 * JD-Core Version:    0.6.0
 */