/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Iterator;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.util.XmlHelper;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class MethodConfig
/*     */ {
/*  54 */   String methodName = null;
/*  55 */   String signature = null;
/*     */ 
/*     */   public boolean patternMatches(Method method)
/*     */   {
/*  66 */     if (this.methodName.equals("*"))
/*     */     {
/*  68 */       return true;
/*     */     }
/*     */ 
/*  71 */     if (!this.methodName.equals(method.getName()))
/*     */     {
/*  74 */       return false;
/*     */     }
/*  76 */     if (this.signature == null) return true;
/*     */ 
/*  78 */     String sig = getSignature(method.getParameterTypes());
/*  79 */     return sig.equals(this.signature);
/*     */   }
/*     */ 
/*     */   public boolean patternMatches(CtMethod method)
/*     */     throws NotFoundException
/*     */   {
/*  85 */     if (this.methodName.equals("*"))
/*     */     {
/*  87 */       return true;
/*     */     }
/*     */ 
/*  90 */     if (!this.methodName.equals(method.getName()))
/*     */     {
/*  93 */       return false;
/*     */     }
/*  95 */     if (this.signature == null) return true;
/*     */ 
/*  97 */     String sig = getSignature(method.getParameterTypes());
/*  98 */     return sig.equals(this.signature);
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws Exception
/*     */   {
/* 104 */     this.methodName = XmlHelper.getElementContent(XmlHelper.getUniqueChild(element, "method-name"));
/* 105 */     this.signature = "(";
/* 106 */     Element paramsElement = XmlHelper.getOptionalChild(element, "method-params");
/* 107 */     if (paramsElement != null)
/*     */     {
/* 109 */       Iterator paramsIterator = XmlHelper.getChildrenByTagName(paramsElement, "method-param");
/*     */ 
/* 111 */       while (paramsIterator.hasNext())
/*     */       {
/* 113 */         this.signature += XmlHelper.getElementContent((Element)paramsIterator.next());
/* 114 */         this.signature += " ";
/*     */       }
/*     */     }
/* 117 */     this.signature += ")";
/*     */   }
/*     */ 
/*     */   public static String toGenericString(Method method)
/*     */   {
/* 122 */     StringBuffer buf = new StringBuffer();
/* 123 */     buf.append(method.getName());
/* 124 */     buf.append("(");
/* 125 */     getSignature(method.getParameterTypes());
/* 126 */     buf.append(")");
/* 127 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public static String getSignature(Class[] source)
/*     */   {
/* 132 */     StringBuffer sig = new StringBuffer("(");
/* 133 */     for (int i = 0; i < source.length; i++)
/*     */     {
/* 135 */       String brackets = "";
/* 136 */       Class cls = source[i];
/* 137 */       while (cls.isArray())
/*     */       {
/* 139 */         brackets = brackets + "[]";
/* 140 */         cls = cls.getComponentType();
/*     */       }
/* 142 */       sig.append(cls.getName());
/* 143 */       sig.append(brackets);
/* 144 */       sig.append(" ");
/*     */     }
/* 146 */     sig.append(")");
/* 147 */     return sig.toString();
/*     */   }
/*     */ 
/*     */   public static String getSignature(CtClass[] source)
/*     */   {
/* 152 */     StringBuffer sig = new StringBuffer("(");
/* 153 */     for (int i = 0; i < source.length; i++)
/*     */     {
/* 155 */       CtClass cls = source[i];
/* 156 */       sig.append(cls.getName());
/* 157 */       sig.append(" ");
/*     */     }
/* 159 */     sig.append(")");
/* 160 */     return sig.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.MethodConfig
 * JD-Core Version:    0.6.0
 */