/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.joinpoint.FieldInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ 
/*     */ public class FieldMetaData
/*     */   implements MetaDataResolver
/*     */ {
/*  38 */   HashMap fieldMetaData = new HashMap();
/*     */ 
/*     */   public boolean hasTag(String tag)
/*     */   {
/*  42 */     Iterator values = this.fieldMetaData.values().iterator();
/*  43 */     while (values.hasNext())
/*     */     {
/*  45 */       SimpleMetaData map = (SimpleMetaData)values.next();
/*  46 */       if (map.hasTag(tag)) return true;
/*     */     }
/*  48 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean hasTag(Field field, String tag) {
/*  52 */     return hasTag(field.getName(), tag);
/*     */   }
/*     */ 
/*     */   public synchronized boolean hasTag(String fieldName, String tag)
/*     */   {
/*  59 */     SimpleMetaData meta = getFieldMetaData(fieldName);
/*  60 */     if (meta == null) return false;
/*  61 */     return meta.hasTag(tag);
/*     */   }
/*     */ 
/*     */   public void tagField(Field field, Object tag)
/*     */   {
/*  66 */     addFieldMetaData(field, tag, "$tagged$", new Object(), PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public void tagField(String field, Object tag)
/*     */   {
/*  71 */     addFieldMetaData(field, tag, "$tagged$", new Object(), PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public void addFieldMetaData(Field field, Object tag, Object attr, Object value)
/*     */   {
/*  76 */     addFieldMetaData(field, tag, attr, value, PayloadKey.MARSHALLED);
/*     */   }
/*     */ 
/*     */   public void addFieldMetaData(Field field, Object tag, Object attr, Object value, PayloadKey type)
/*     */   {
/*  81 */     addFieldMetaData(field.getName(), tag, attr, value, type);
/*     */   }
/*     */ 
/*     */   public void addFieldMetaData(String key, Object tag, Object attr, Object value) {
/*  85 */     addFieldMetaData(key, tag, attr, value, PayloadKey.MARSHALLED);
/*     */   }
/*     */ 
/*     */   public synchronized void addFieldMetaData(String key, Object tag, Object attr, Object value, PayloadKey type) {
/*  89 */     String fieldName = key;
/*  90 */     SimpleMetaData fieldData = (SimpleMetaData)this.fieldMetaData.get(fieldName);
/*  91 */     if (fieldData == null)
/*     */     {
/*  93 */       fieldData = new SimpleMetaData();
/*  94 */       this.fieldMetaData.put(fieldName, fieldData);
/*     */     }
/*  96 */     fieldData.addMetaData(tag, attr, value, type);
/*     */   }
/*     */ 
/*     */   public Object getFieldMetaData(Field field, Object tag, Object attr)
/*     */   {
/* 101 */     SimpleMetaData data = getFieldMetaData(field.getName());
/* 102 */     if (data == null) return null;
/* 103 */     return data.getMetaData(tag, attr);
/*     */   }
/*     */ 
/*     */   public synchronized Object getFieldMetaData(String fieldName, Object tag, Object attr)
/*     */   {
/* 108 */     SimpleMetaData fieldData = (SimpleMetaData)this.fieldMetaData.get(fieldName);
/* 109 */     if (fieldData == null) return null;
/* 110 */     return fieldData.getMetaData(tag, attr);
/*     */   }
/*     */ 
/*     */   public synchronized Iterator getFields()
/*     */   {
/* 115 */     return this.fieldMetaData.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public synchronized SimpleMetaData getFieldMetaData(String field)
/*     */   {
/* 120 */     return (SimpleMetaData)this.fieldMetaData.get(field);
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 125 */     this.fieldMetaData.clear();
/*     */   }
/*     */ 
/*     */   public Object resolve(Invocation invocation, Object tag, Object attr)
/*     */   {
/* 130 */     Field field = ((FieldInvocation)invocation).getField();
/* 131 */     return getFieldMetaData(field, tag, attr);
/*     */   }
/*     */ 
/*     */   public synchronized SimpleMetaData getAllMetaData(Invocation invocation)
/*     */   {
/* 136 */     Field field = ((FieldInvocation)invocation).getField();
/* 137 */     return (SimpleMetaData)this.fieldMetaData.get(field);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.FieldMetaData
 * JD-Core Version:    0.6.0
 */