/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.Util;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ 
/*     */ public abstract class ClassMetaDataBinding
/*     */ {
/*     */   protected ClassExpression classExpr;
/*     */   protected String expr;
/*     */   protected String name;
/*     */   protected String tag;
/*  44 */   protected ArrayList advisors = new ArrayList();
/*     */   protected ClassMetaDataLoader loader;
/*     */ 
/*     */   public ClassMetaDataBinding(ClassMetaDataLoader loader, String name, String tag, String exp)
/*     */   {
/*  49 */     this.name = name;
/*  50 */     this.tag = tag;
/*  51 */     this.loader = loader;
/*  52 */     this.expr = exp;
/*  53 */     this.classExpr = new ClassExpression(this.expr);
/*     */   }
/*     */ 
/*     */   public ClassMetaDataLoader getLoader()
/*     */   {
/*  58 */     return this.loader;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  63 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getTag()
/*     */   {
/*  68 */     return this.tag;
/*     */   }
/*     */ 
/*     */   public void addAdvisor(Advisor advisor)
/*     */   {
/*  75 */     synchronized (this.advisors)
/*     */     {
/*  77 */       Iterator it = this.advisors.iterator();
/*  78 */       while (it.hasNext())
/*     */       {
/*  80 */         WeakReference ref = (WeakReference)it.next();
/*  81 */         Object obj = ref.get();
/*  82 */         if (obj == null) it.remove();
/*     */       }
/*  84 */       this.advisors.add(new WeakReference(advisor));
/*     */     }
/*  86 */     advisor.addClassMetaData(this);
/*     */   }
/*     */ 
/*     */   public void clearAdvisors()
/*     */   {
/*  91 */     synchronized (this.advisors)
/*     */     {
/*  93 */       for (int i = 0; i < this.advisors.size(); i++)
/*     */       {
/*  95 */         WeakReference ref = (WeakReference)this.advisors.get(i);
/*  96 */         Advisor advisor = (Advisor)ref.get();
/*  97 */         if (advisor != null)
/*  98 */           advisor.removeClassMetaData(this);
/*     */       }
/* 100 */       this.advisors.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 106 */     if (obj == this) return true;
/* 107 */     if (!(obj instanceof ClassMetaDataBinding)) return false;
/* 108 */     return ((ClassMetaDataBinding)obj).getName().equals(this.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 113 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Class clazz)
/*     */   {
/* 118 */     return Util.matchesClassExpr(this.classExpr, clazz, advisor);
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtClass clazz) throws NotFoundException
/*     */   {
/* 123 */     return Util.matchesClassExpr(this.classExpr, clazz, advisor);
/*     */   }
/*     */ 
/*     */   public String getClassExpr()
/*     */   {
/* 128 */     return this.expr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.ClassMetaDataBinding
 * JD-Core Version:    0.6.0
 */