/*    */ package org.jboss.aop.joinpoint;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.Method;
/*    */ 
/*    */ public class MethodCalledByConstructorJoinpoint
/*    */   implements Joinpoint
/*    */ {
/*    */   private final Constructor calling;
/*    */   private final Method called;
/*    */   int hashCode;
/*    */ 
/*    */   public MethodCalledByConstructorJoinpoint(Constructor calling, Method called)
/*    */   {
/* 41 */     this.calling = calling;
/* 42 */     this.called = called;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 47 */     if (o == null) return false;
/* 48 */     if (o == this) return true;
/* 49 */     if (!(o instanceof MethodCalledByConstructorJoinpoint)) return false;
/* 50 */     MethodCalledByConstructorJoinpoint jp = (MethodCalledByConstructorJoinpoint)o;
/* 51 */     if (!jp.calling.equals(this.calling)) return false;
/* 52 */     return jp.called.equals(this.called);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 58 */     if (this.hashCode == 0)
/*    */     {
/* 60 */       this.hashCode = (this.calling.hashCode() + this.called.hashCode());
/*    */     }
/* 62 */     return this.hashCode;
/*    */   }
/*    */ 
/*    */   public Constructor getCalling()
/*    */   {
/* 67 */     return this.calling;
/*    */   }
/*    */ 
/*    */   public Method getCalled()
/*    */   {
/* 72 */     return this.called;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 77 */     return this.called + " called by " + this.calling;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint
 * JD-Core Version:    0.6.0
 */