/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ConstructorInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class ConstructorInvocation extends InvocationBase
/*     */ {
/*     */   private static final long serialVersionUID = -7880020293056198584L;
/*  42 */   protected Object[] arguments = null;
/*  43 */   protected transient Constructor constructor = null;
/*     */ 
/*     */   public ConstructorInvocation(Interceptor[] interceptors)
/*     */   {
/*  47 */     super(interceptors);
/*     */   }
/*     */ 
/*     */   public ConstructorInvocation(ConstructorInfo info, Interceptor[] interceptors)
/*     */   {
/*  52 */     super(interceptors);
/*  53 */     this.advisor = info.getAdvisor();
/*  54 */     this.constructor = info.getConstructor();
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  65 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  69 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  78 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/*  89 */       Constructor con = getConstructor();
/*  90 */       Object[] args = getArguments();
/*  91 */       setTargetObject(con.newInstance(args));
/*  92 */       return getTargetObject();
/*     */     }
/*     */     catch (InstantiationException in)
/*     */     {
/*  96 */       throw new RuntimeException("failed to call constructor", in);
/*     */     }
/*     */     catch (IllegalAccessException ill)
/*     */     {
/* 100 */       throw new RuntimeException("illegal access", ill);
/*     */     }
/*     */     catch (InvocationTargetException ite)
/*     */     {
/* 104 */       throw ite.getCause();
/*     */     }
/*     */     catch (IllegalArgumentException iae)
/*     */     {
/*     */     }
/* 109 */     throw iae;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 120 */     Object val = super.resolveAnnotation(annotation);
/* 121 */     if (val != null) return val;
/*     */ 
/* 123 */     if (getAdvisor() != null)
/*     */     {
/* 125 */       val = getAdvisor().resolveAnnotation(this.constructor, annotation);
/* 126 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 129 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 143 */     Object val = super.getMetaData(group, attr);
/* 144 */     if (val != null) return val;
/*     */ 
/* 146 */     if (getAdvisor() != null)
/*     */     {
/* 148 */       val = getAdvisor().getConstructorMetaData().resolve(this, group, attr);
/* 149 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 152 */     if (getAdvisor() != null)
/*     */     {
/* 154 */       val = getAdvisor().getDefaultMetaData().resolve(this, group, attr);
/* 155 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 158 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 172 */     ConstructorInvocationWrapper wrapper = new ConstructorInvocationWrapper(this, newchain);
/* 173 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 183 */     ConstructorInvocation wrapper = new ConstructorInvocation(this.interceptors);
/* 184 */     wrapper.arguments = this.arguments;
/* 185 */     wrapper.constructor = this.constructor;
/* 186 */     wrapper.setAdvisor(getAdvisor());
/* 187 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 188 */     wrapper.metadata = this.metadata;
/* 189 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 208 */     return this.arguments;
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/* 227 */     this.arguments = arguments;
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/* 232 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/* 237 */     this.constructor = constructor;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorInvocation
 * JD-Core Version:    0.6.0
 */