/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ConByConInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ 
/*     */ public class ConstructorCalledByConstructorInvocation extends CallerInvocation
/*     */ {
/*     */   private static final long serialVersionUID = -1569257745454443521L;
/*     */   protected Constructor calling;
/*     */   protected Constructor constructor;
/*     */   protected Method wrappingMethod;
/*     */ 
/*     */   public ConstructorCalledByConstructorInvocation(ConByConInfo info, Object callingObject, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  52 */     this(info.getAdvisor(), info.getCallingConstructor(), info.getConstructor(), info.getWrappingMethod(), callingObject, args, interceptors);
/*     */   }
/*     */ 
/*     */   public ConstructorCalledByConstructorInvocation(ConByConInfo info, Object callingObject, Interceptor[] interceptors)
/*     */   {
/*  57 */     this(info.getAdvisor(), info.getCallingConstructor(), info.getConstructor(), info.getWrappingMethod(), callingObject, null, interceptors);
/*     */   }
/*     */ 
/*     */   public ConstructorCalledByConstructorInvocation(Advisor advisor, Constructor calling, Constructor constructor, Method wrappingMethod, Object callingObject, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  62 */     super(advisor, callingObject, interceptors);
/*  63 */     this.calling = calling;
/*  64 */     this.constructor = constructor;
/*  65 */     this.wrappingMethod = wrappingMethod;
/*  66 */     this.arguments = args;
/*     */   }
/*     */ 
/*     */   public ConstructorCalledByConstructorInvocation(Object callingObject, Interceptor[] interceptors)
/*     */   {
/*  71 */     super(callingObject, interceptors);
/*     */   }
/*     */ 
/*     */   public Constructor getCallingConstructor()
/*     */   {
/*  80 */     return this.calling;
/*     */   }
/*     */ 
/*     */   public Constructor getCalledConstructor()
/*     */   {
/*  86 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public boolean isWrapped()
/*     */   {
/*  94 */     return this.wrappingMethod != null;
/*     */   }
/*     */ 
/*     */   public Method getWrappingMethod()
/*     */   {
/* 103 */     return this.wrappingMethod;
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/* 112 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/* 116 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/* 125 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/* 134 */     if (this.wrappingMethod != null)
/*     */     {
/*     */       try
/*     */       {
/* 138 */         setTargetObject(this.wrappingMethod.invoke(null, this.arguments));
/* 139 */         return getTargetObject();
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 143 */         throw e.getTargetException();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 150 */       return this.constructor.newInstance(this.arguments);
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 154 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 158 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 162 */     throw e.getCause();
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 178 */     Object val = super.getMetaData(group, attr);
/* 179 */     if (val != null) return val;
/*     */ 
/* 182 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 196 */     ConstructorCalledByConstructorInvocationWrapper wrapper = new ConstructorCalledByConstructorInvocationWrapper(this, newchain);
/* 197 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 207 */     ConstructorCalledByConstructorInvocation wrapper = new ConstructorCalledByConstructorInvocation(this.advisor, this.calling, this.constructor, this.wrappingMethod, this.callingObject, this.arguments, this.interceptors);
/* 208 */     wrapper.setAdvisor(getAdvisor());
/* 209 */     wrapper.setTargetObject(getTargetObject());
/* 210 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 211 */     wrapper.instanceResolver = this.instanceResolver;
/* 212 */     wrapper.metadata = this.metadata;
/* 213 */     return wrapper;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation
 * JD-Core Version:    0.6.0
 */