/*     */ package org.jboss.aop.introduction;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.ArrayList;
/*     */ import javassist.CtClass;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.TypeMatcher;
/*     */ import org.jboss.aop.pointcut.Util;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*     */ 
/*     */ public class InterfaceIntroduction
/*     */ {
/*     */   protected String name;
/* 103 */   protected ArrayList<WeakReference<Advisor>> advisors = new ArrayList();
/*     */   protected String[] interfaces;
/* 105 */   protected ArrayList<Mixin> mixins = new ArrayList();
/*     */   protected ClassExpression classExpr;
/*     */   protected ASTStart ast;
/*     */   protected String constructorClass;
/*     */   protected String constructorMethod;
/*     */ 
/*     */   public InterfaceIntroduction()
/*     */   {
/*     */   }
/*     */ 
/*     */   public InterfaceIntroduction(String name, String exp, String[] interfaces)
/*     */   {
/* 119 */     this.name = name;
/* 120 */     this.interfaces = interfaces;
/* 121 */     this.classExpr = new ClassExpression(exp);
/*     */   }
/*     */ 
/*     */   public InterfaceIntroduction(String name, String exp, String[] interfaces, String constructorClass, String constructorMethod)
/*     */   {
/* 129 */     this(name, exp, interfaces);
/* 130 */     this.constructorClass = constructorClass;
/* 131 */     this.constructorMethod = constructorMethod;
/*     */   }
/*     */ 
/*     */   public InterfaceIntroduction(String name, ASTStart ast, String[] interfaces)
/*     */   {
/* 136 */     this.name = name;
/* 137 */     this.ast = ast;
/* 138 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public InterfaceIntroduction(String name, ASTStart ast, String[] interfaces, String constructorClass, String constructorMethod)
/*     */   {
/* 146 */     this(name, ast, interfaces);
/* 147 */     this.constructorClass = constructorClass;
/* 148 */     this.constructorMethod = constructorMethod;
/*     */   }
/*     */ 
/*     */   public void setClassExpression(String exp)
/*     */   {
/* 153 */     this.classExpr = new ClassExpression(exp);
/*     */   }
/*     */ 
/*     */   public void setTypeExpression(String exp)
/*     */   {
/*     */     try
/*     */     {
/* 160 */       this.ast = new TypeExpressionParser(new StringReader(exp)).Start();
/*     */     }
/*     */     catch (ParseException e)
/*     */     {
/* 164 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMixins(ArrayList<Mixin> mixins)
/*     */   {
/* 170 */     this.mixins = mixins;
/*     */   }
/*     */ 
/*     */   public void addMixin(Mixin mixin)
/*     */   {
/* 175 */     this.mixins.add(mixin);
/*     */   }
/*     */ 
/*     */   public void setInterfaces(String[] interfaces)
/*     */   {
/* 180 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 185 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 190 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String[] getInterfaces()
/*     */   {
/* 195 */     return this.interfaces;
/*     */   }
/*     */ 
/*     */   public ArrayList<Mixin> getMixins()
/*     */   {
/* 200 */     return this.mixins;
/*     */   }
/*     */ 
/*     */   public String getConstructorClass()
/*     */   {
/* 207 */     return this.constructorClass;
/*     */   }
/*     */ 
/*     */   public String getConstructorMethod()
/*     */   {
/* 214 */     return this.constructorMethod;
/*     */   }
/*     */ 
/*     */   public void addAdvisor(Advisor advisor)
/*     */   {
/* 219 */     this.advisors.add(new WeakReference(advisor));
/* 220 */     advisor.addInterfaceIntroduction(this);
/*     */   }
/*     */ 
/*     */   public void clearAdvisors()
/*     */   {
/* 225 */     for (int i = 0; i < this.advisors.size(); i++)
/*     */     {
/* 227 */       Advisor advisor = (Advisor)((WeakReference)this.advisors.get(i)).get();
/* 228 */       if (advisor != null)
/* 229 */         advisor.removeInterfaceIntroduction(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 235 */     if (obj == this) return true;
/* 236 */     if (!(obj instanceof InterfaceIntroduction)) return false;
/* 237 */     return ((InterfaceIntroduction)obj).getName().equals(this.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 242 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public String getClassExpr()
/*     */   {
/* 247 */     if (this.classExpr == null) return null;
/* 248 */     return this.classExpr.getOriginal();
/*     */   }
/*     */ 
/*     */   public ASTStart getAst()
/*     */   {
/* 253 */     return this.ast;
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtClass clazz) throws Exception
/*     */   {
/* 258 */     if (this.classExpr != null) {
/* 259 */       return Util.matchesClassExpr(this.classExpr, clazz, advisor);
/*     */     }
/*     */ 
/* 262 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/* 263 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Class clazz)
/*     */   {
/* 269 */     if (this.classExpr != null) {
/* 270 */       return Util.matchesClassExpr(this.classExpr, clazz, advisor);
/*     */     }
/*     */ 
/* 273 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/* 274 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public static class Mixin
/*     */   {
/*     */     protected String classname;
/*     */     protected String[] interfaces;
/*     */     protected String construction;
/*     */     protected boolean trans;
/*     */ 
/*     */     public Mixin()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Mixin(String classname, String[] interfaces, String construction, boolean trans)
/*     */     {
/*  53 */       this.classname = classname;
/*  54 */       this.interfaces = interfaces;
/*  55 */       this.construction = construction;
/*  56 */       this.trans = trans;
/*     */     }
/*     */ 
/*     */     public String getClassName()
/*     */     {
/*  61 */       return this.classname;
/*     */     }
/*     */ 
/*     */     public String[] getInterfaces()
/*     */     {
/*  66 */       return this.interfaces;
/*     */     }
/*     */ 
/*     */     public String getConstruction()
/*     */     {
/*  71 */       return this.construction;
/*     */     }
/*     */ 
/*     */     public boolean isTransient()
/*     */     {
/*  76 */       return this.trans;
/*     */     }
/*     */ 
/*     */     public void setClassname(String classname)
/*     */     {
/*  81 */       this.classname = classname;
/*     */     }
/*     */ 
/*     */     public void setInterfaces(String[] interfaces)
/*     */     {
/*  86 */       this.interfaces = interfaces;
/*     */     }
/*     */ 
/*     */     public void setConstruction(String construction)
/*     */     {
/*  91 */       this.construction = construction;
/*     */     }
/*     */ 
/*     */     public void setTrans(boolean trans)
/*     */     {
/*  96 */       this.trans = trans;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.introduction.InterfaceIntroduction
 * JD-Core Version:    0.6.0
 */