/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.util.JavassistToReflect;
/*     */ 
/*     */ public class OptimizedFieldInvocations extends OptimizedInvocations
/*     */ {
/*     */   protected static String getOptimizedInvocationClassName(CtClass clazz, CtField field, boolean get)
/*     */     throws Exception
/*     */   {
/*  47 */     StringBuffer sb = new StringBuffer(clazz.getName());
/*  48 */     sb.append(".").append(field.getName());
/*     */ 
/*  51 */     if (get)
/*     */     {
/*  53 */       sb.append("_Get");
/*     */     }
/*     */     else
/*     */     {
/*  57 */       sb.append("_Set");
/*     */     }
/*     */ 
/*  60 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   protected static void addCopy(ClassPool pool, CtClass invocation, boolean isStatic, boolean isGet) throws Exception
/*     */   {
/*  65 */     CtClass fieldInvocation = isGet ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
/*     */ 
/*  69 */     CtMethod template = fieldInvocation.getDeclaredMethod("copy");
/*     */ 
/*  71 */     String newExpr = invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.value, this.interceptors); ";
/*     */ 
/*  82 */     String code = "{    " + newExpr + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; ";
/*     */ 
/*  89 */     if (!isStatic)
/*     */     {
/*  91 */       code = code + "   wrapper.typedTargetObject = this.typedTargetObject; ";
/*  92 */       code = code + "   wrapper.targetObject = this.targetObject; ";
/*     */     }
/*     */ 
/*  95 */     code = code + "   return wrapper; }";
/*     */ 
/*  97 */     CtMethod copy = CtNewMethod.make(template.getReturnType(), "copy", template.getParameterTypes(), template.getExceptionTypes(), code, invocation);
/*     */ 
/* 104 */     copy.setModifiers(template.getModifiers());
/* 105 */     invocation.addMethod(copy);
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtField field, boolean get)
/*     */     throws Exception
/*     */   {
/* 111 */     AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
/* 112 */     CtClass fieldInvocation = get ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
/*     */ 
/* 117 */     String className = getOptimizedInvocationClassName(clazz, field, get);
/* 118 */     boolean makeInnerClass = true;
/*     */     try
/*     */     {
/* 124 */       CtClass existing = pool.get(className);
/* 125 */       if (existing.isFrozen())
/*     */       {
/* 127 */         existing.defrost();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/*     */ 
/* 135 */     CtClass invocation = makeInvocationClass(pool, makeInnerClass, clazz, className, fieldInvocation);
/* 136 */     invocation.stopPruning(true);
/*     */ 
/* 138 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/* 139 */     if (!isStatic)
/*     */     {
/* 141 */       CtField target = new CtField(field.getDeclaringClass(), "typedTargetObject", invocation);
/* 142 */       target.setModifiers(1);
/* 143 */       invocation.addField(target);
/*     */     }
/* 145 */     addCopy(pool, invocation, isStatic, get);
/*     */ 
/* 147 */     setInvocationInvokeCode(invocation, field, get);
/*     */ 
/* 149 */     TransformerCommon.compileOrLoadClass(field.getDeclaringClass(), invocation);
/*     */ 
/* 152 */     return invocation.getName();
/*     */   }
/*     */ 
/*     */   private static void setInvocationInvokeCode(CtClass invocation, CtField field, boolean get)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 165 */     CtMethod in = invocation.getSuperclass().getDeclaredMethod("invokeTarget");
/*     */ 
/* 167 */     String code = "{";
/*     */ 
/* 169 */     String ref = Modifier.isStatic(field.getModifiers()) ? field.getDeclaringClass().getName() + "." : " typedTargetObject.";
/*     */ 
/* 171 */     if (get)
/*     */     {
/* 173 */       code = code + "return ($w) " + ref + field.getName() + ";";
/*     */     }
/*     */     else
/*     */     {
/* 178 */       CtClass type = field.getType();
/* 179 */       code = code + ref + field.getName() + " = " + JavassistToReflect.castInvocationValueToTypeString(type) + ";   return null;";
/*     */     }
/*     */ 
/* 182 */     code = code + "}";
/* 183 */     CtMethod invokeTarget = CtNewMethod.make(in.getReturnType(), in.getName(), in.getParameterTypes(), in.getExceptionTypes(), code, invocation);
/*     */ 
/* 190 */     invokeTarget.setModifiers(in.getModifiers());
/* 191 */     invocation.addMethod(invokeTarget);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedFieldInvocations
 * JD-Core Version:    0.6.0
 */