/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.FieldAccess;
/*     */ 
/*     */ public class OptimizedFieldAccessTransformer extends FieldAccessTransformer
/*     */ {
/*     */   public OptimizedFieldAccessTransformer(Instrumentor instrumentor)
/*     */   {
/*  43 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected void doBuildFieldWrappers(CtClass clazz, CtField field, int fieldIndex, boolean shouldReplaceArrayAccess, JoinpointClassification classificationGet, JoinpointClassification classificationSet) throws NotFoundException, CannotCompileException
/*     */   {
/*  48 */     this.instrumentor.setupBasics(clazz);
/*  49 */     boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
/*  50 */     boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
/*  51 */     int mod = getStaticModifiers(field);
/*     */ 
/*  58 */     buildWrapperPlaceHolders(clazz, field, isPrepared(classificationGet), isPrepared(classificationSet), mod);
/*     */     try {
/*  60 */       if (isPrepared(classificationGet))
/*     */       {
/*  62 */         addFieldReadInfoFieldWithAccessors(10, clazz, field);
/*  63 */         OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, true);
/*     */ 
/*  65 */         wrapper.prepareForWrapping(field, 0);
/*     */       }
/*     */ 
/*  68 */       if (isPrepared(classificationSet))
/*     */       {
/*  70 */         addFieldWriteInfoField(10, clazz, field);
/*  71 */         OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, false);
/*     */ 
/*  73 */         wrapper.prepareForWrapping(field, 1);
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/*  77 */       throw new CannotCompileException(e);
/*     */     }
/*     */ 
/*  81 */     if (wrappedGet)
/*     */     {
/*  83 */       wrapper.wrap(field, 0);
/*  84 */       if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED))
/*     */       {
/*  86 */         this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
/*     */       }
/*     */     }
/*  89 */     if (wrappedSet)
/*     */     {
/*  91 */       wrapper.wrap(field, 1);
/*  92 */       if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED))
/*     */       {
/*  94 */         this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  99 */     replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
/* 100 */     buildWrappers(clazz, field, shouldReplaceArrayAccess, wrappedGet, wrappedSet, fieldIndex);
/*     */   }
/*     */ 
/*     */   protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 115 */     if (get)
/*     */     {
/* 117 */       return getReadWrapperBody(clazz, field, index);
/*     */     }
/*     */ 
/* 120 */     return getWriteWrapperBody(clazz, field, false, index);
/*     */   }
/*     */ 
/*     */   private String getReadWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException
/*     */   {
/* 133 */     String wrappedName = field.getName();
/*     */     String optimizedInvocation;
/*     */     try
/*     */     {
/* 138 */       optimizedInvocation = OptimizedFieldInvocations.getOptimizedInvocationClassName(clazz, field, true);
/* 139 */       optimizedInvocation = optimizedInvocation.substring(optimizedInvocation.lastIndexOf('.') + 1);
/* 140 */       optimizedInvocation = clazz.getName() + "$" + optimizedInvocation;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 144 */       e.printStackTrace();
/* 145 */       throw new CannotCompileException(e);
/*     */     }
/*     */ 
/* 148 */     String infoName = getFieldReadInfoFieldName(field.getName());
/* 149 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/*     */     String code;
/*     */     String code;
/* 153 */     if (!isStatic)
/*     */     {
/* 155 */       code = "{    " + fieldInfoFromWeakReference("info", infoName) + "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor();" + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null || (instAdv != null && instAdv.hasInstanceAspects))" + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return ((" + clazz.getName() + ")$1)." + wrappedName + ";" + "    }" + "}";
/*     */     }
/*     */     else
/*     */     {
/* 180 */       code = "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getFieldReadInfos()[" + index + "].getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "    " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return " + clazz.getName() + "." + wrappedName + ";" + "    }" + "}";
/*     */     }
/*     */ 
/* 196 */     return code;
/*     */   }
/*     */ 
/*     */   private String getWriteWrapperBody(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, int index) throws NotFoundException, CannotCompileException
/*     */   {
/* 209 */     String wrappedName = field.getName();
/*     */     String optimizedInvocation;
/*     */     try
/*     */     {
/* 214 */       optimizedInvocation = OptimizedFieldInvocations.getOptimizedInvocationClassName(clazz, field, false);
/* 215 */       optimizedInvocation = optimizedInvocation.substring(optimizedInvocation.lastIndexOf('.') + 1);
/* 216 */       optimizedInvocation = clazz.getName() + "$" + optimizedInvocation;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 220 */       throw new CannotCompileException(e);
/*     */     }
/*     */ 
/* 223 */     String infoName = getFieldWriteInfoFieldName(field.getName());
/* 224 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/*     */     String code;
/*     */     String code;
/* 226 */     if (!isStatic)
/*     */     {
/* 228 */       String targetString = "((" + clazz.getName() + ")$1)";
/* 229 */       String fieldString = targetString + "." + field.getName();
/* 230 */       code = "{    " + getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "   " + fieldInfoFromWeakReference("info", infoName) + "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor();" + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors();" + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null || (instAdv != null && instAdv.hasInstanceAspects)) " + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       ((" + clazz.getName() + ")$1)." + wrappedName + "=$2" + ";" + "    }" + "}";
/*     */     }
/*     */     else
/*     */     {
/* 256 */       String targetString = "java.lang.Class.forName(\"" + clazz.getName() + "\")";
/* 257 */       String fieldString = clazz.getName() + "." + field.getName();
/* 258 */       code = "{     " + getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "    org.jboss.aop.advice.Interceptor[] interceptors = " + "aop$classAdvisor$aop" + ".getFieldWriteInfos()[" + index + "].getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + clazz.getName() + "." + wrappedName + "=$2" + ";" + "    }" + "}";
/*     */     }
/*     */ 
/* 275 */     return code;
/*     */   }
/*     */ 
/*     */   private void buildWrappers(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, boolean doGet, boolean doSet, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 281 */     if (doGet)
/*     */     {
/* 283 */       String code = getReadWrapperBody(clazz, field, index);
/* 284 */       CtMethod method = clazz.getDeclaredMethod(fieldRead(field.getName()));
/* 285 */       method.setBody(code);
/*     */     }
/* 287 */     if (doSet)
/*     */     {
/* 289 */       String code = getWriteWrapperBody(clazz, field, shouldReplaceArrayAccess, index);
/* 290 */       CtMethod method = clazz.getDeclaredMethod(fieldWrite(field.getName()));
/* 291 */       method.setBody(code);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index)
/*     */     throws CannotCompileException
/*     */   {
/* 299 */     OptimizedFieldAccessExprEditor expr = new OptimizedFieldAccessExprEditor(clazz, field, doGet, doSet, index);
/* 300 */     clazz.instrument(expr);
/*     */   }
/*     */ 
/*     */   protected class OptimizedFieldAccessExprEditor extends FieldAccessTransformer.FieldAccessExprEditor
/*     */   {
/*     */     public OptimizedFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index)
/*     */     {
/* 307 */       super(clazz, field, doGet, doSet, index);
/*     */     }
/*     */ 
/*     */     protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 312 */       if (fieldAccess.isStatic())
/*     */       {
/* 314 */         String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
/*     */ 
/* 319 */         fieldAccess.replace(code);
/*     */       }
/*     */       else
/*     */       {
/* 323 */         String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
/*     */ 
/* 328 */         fieldAccess.replace(code);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 334 */       String fieldWrite = FieldAccessTransformer.fieldWrite(this.field.getName());
/* 335 */       if (fieldAccess.isStatic())
/*     */       {
/* 337 */         String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
/*     */ 
/* 342 */         fieldAccess.replace(code);
/*     */       }
/*     */       else
/*     */       {
/* 347 */         String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
/*     */ 
/* 352 */         fieldAccess.replace(code);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedFieldAccessTransformer
 * JD-Core Version:    0.6.0
 */