/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ 
/*     */ public class NonOptimizedMethodExecutionTransformer extends MethodExecutionTransformer
/*     */ {
/*     */   public NonOptimizedMethodExecutionTransformer(Instrumentor instrumentor)
/*     */   {
/*  42 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected void transformMethod(MethodExecutionTransformer.MethodTransformation trans, boolean wrap) throws NotFoundException, CannotCompileException
/*     */   {
/*  47 */     String methodInfoField = addMethodInfoField(10, trans.getClazz(), trans);
/*     */ 
/*  49 */     String wrappedName = ClassAdvisor.notAdvisedMethodName(trans.getClazzName(), trans.getMethod().getName());
/*     */ 
/*  51 */     CtMethod wmethod = CtNewMethod.copy(trans.getMethod(), trans.getClazz(), null);
/*     */ 
/*  53 */     String originalName = trans.getOriginalName();
/*  54 */     wmethod.setName(wrappedName);
/*  55 */     trans.getClazz().addMethod(wmethod);
/*  56 */     moveAnnotationsAndCopySignature(trans.getMethod(), wmethod);
/*  57 */     trans.getMethod().setName(wrappedName);
/*  58 */     wmethod.setName(originalName);
/*     */ 
/*  60 */     trans.setWMethod(wmethod, wrappedName);
/*     */ 
/*  63 */     getWrapper().prepareForWrapping(wmethod, 0);
/*     */ 
/*  66 */     if (wrap)
/*     */     {
/*  69 */       getWrapper().wrap(wmethod, 0);
/*     */ 
/*  72 */       setWrapperBody(trans, methodInfoField);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void doWrap(MethodExecutionTransformer.MethodTransformation trans, String methodInfoFieldName) throws NotFoundException, Exception
/*     */   {
/*  78 */     setWrapperBody(trans, methodInfoFieldName);
/*     */   }
/*     */ 
/*     */   protected void setWrapperBody(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField)
/*     */     throws NotFoundException
/*     */   {
/*  87 */     boolean isStatic = Modifier.isStatic(trans.getMethod().getModifiers());
/*  88 */     String code = null;
/*  89 */     if (!isStatic)
/*     */     {
/*  91 */       code = "{     " + methodInfoFromWeakReference("info", methodInfoField) + "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)_getInstanceAdvisor();" + "    if (info.getInterceptors() != (Object[])null || (instAdv != null && instAdv.hasInstanceAspects)) " + "    { " + "       Object[] ags = $args; " + "       " + getAopReturnStr(trans.getMethod()) + "aop$classAdvisor$aop" + ".invokeMethod(instAdv, this, " + trans.getHash() + "L, ags, info); " + "    } " + "    else " + "    {" + "       " + getReturnStr(trans.getMethod()) + " " + trans.getWrappedName() + "($$); " + "    }" + "}";
/*     */     }
/*     */     else
/*     */     {
/* 108 */       code = "{     " + methodInfoFromWeakReference("info", methodInfoField) + "    if (info.getInterceptors() != (Object[])null) " + "    { " + "       org.jboss.aop.ClassInstanceAdvisor ia = null; " + "       Object[] ags = $args; " + "       Object target = null; " + "       " + getAopReturnStr(trans.getMethod()) + "aop$classAdvisor$aop" + ".invokeMethod(ia, target, " + trans.getHash() + "L, ags, info); " + "    } " + "    else " + "    {" + "       " + getReturnStr(trans.getMethod()) + " " + trans.getWrappedName() + "($$); " + "    }" + "}";
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 126 */       trans.setWMethodBody(code);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 130 */       e.printStackTrace();
/* 131 */       throw new RuntimeException("code was: " + code + " for method " + trans.getOriginalName());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.NonOptimizedMethodExecutionTransformer
 * JD-Core Version:    0.6.0
 */