/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.CtMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ParameterAnnotationsAttribute;
/*     */ import javassist.bytecode.SignatureAttribute;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.util.Advisable;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ 
/*     */ public abstract class MethodExecutionTransformer
/*     */ {
/*     */   public static final String METHOD_INFO_CLASS_NAME = "org.jboss.aop.MethodInfo";
/*  55 */   private static final WrapperTransformer wrapper = new WrapperTransformer(WrapperTransformer.SINGLE_TRANSFORMATION);
/*     */   protected Instrumentor instrumentor;
/*     */   private JoinpointClassifier classifier;
/*     */ 
/*     */   protected MethodExecutionTransformer(Instrumentor instrumentor)
/*     */   {
/*  61 */     this.instrumentor = instrumentor;
/*  62 */     this.classifier = instrumentor.joinpointClassifier;
/*     */   }
/*     */ 
/*     */   protected static WrapperTransformer getWrapper()
/*     */   {
/*  67 */     return wrapper;
/*     */   }
/*     */ 
/*     */   protected JoinpointClassifier getClassifier()
/*     */   {
/*  72 */     return this.classifier;
/*     */   }
/*     */ 
/*     */   protected String addMethodInfoField(int modifiers, CtClass addTo, MethodTransformation trans)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  80 */     return addMethodInfoField(modifiers, addTo, trans, null);
/*     */   }
/*     */ 
/*     */   protected String addMethodInfoField(int modifiers, CtClass addTo, MethodTransformation trans, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  88 */     String name = getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
/*  89 */     TransformerCommon.addInfoField(this.instrumentor, "org.jboss.aop.MethodInfo", name, modifiers, addTo, addInfoAsWeakReference(), init);
/*     */ 
/*  91 */     return name;
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/*  96 */     return true;
/*     */   }
/*     */ 
/*     */   public static String getMethodNameHash(String methodName, long methodHash)
/*     */   {
/*     */     String hash;
/*     */     String hash;
/* 102 */     if (methodHash < 0L)
/* 103 */       hash = "_N_" + -1L * methodHash;
/*     */     else
/* 105 */       hash = "" + methodHash;
/* 106 */     return methodName + hash;
/*     */   }
/*     */ 
/*     */   public static String getMethodInfoFieldName(String methodName, long methodHash)
/*     */   {
/* 111 */     String name = "aop$MethodInfo_" + getMethodNameHash(methodName, methodHash);
/* 112 */     return name;
/*     */   }
/*     */ 
/*     */   protected static String methodInfoFromWeakReference(String localName, String methodInfoName)
/*     */   {
/* 117 */     return TransformerCommon.infoFromWeakReference("org.jboss.aop.MethodInfo", localName, methodInfoName);
/*     */   }
/*     */ 
/*     */   public void instrument(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException
/*     */   {
/* 122 */     CtMethod[] methods = clazz.getDeclaredMethods();
/* 123 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 125 */       if ((!Modifier.isNative(methods[i].getModifiers())) && 
/* 129 */         (!Advisable.isAdvisable(methods[i])))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 134 */       JoinpointClassification classification = this.classifier.classifyMethodExecution(methods[i], advisor);
/* 135 */       if (classification == JoinpointClassification.NOT_INSTRUMENTED)
/*     */       {
/*     */         continue;
/*     */       }
/* 139 */       this.instrumentor.setupBasics(clazz);
/* 140 */       MethodTransformation trans = new MethodTransformation(this.instrumentor, clazz, methods[i]);
/* 141 */       boolean wrap = classification.equals(JoinpointClassification.WRAPPED);
/* 142 */       transformMethod(trans, wrap);
/*     */ 
/* 144 */       int modifier = trans.getWMethod().getModifiers();
/* 145 */       if (!Modifier.isNative(modifier))
/*     */         continue;
/* 147 */       modifier &= -257;
/* 148 */       trans.getWMethod().setModifiers(modifier);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void wrap(CtClass clazz, Collection methodInfos)
/*     */     throws Exception
/*     */   {
/* 162 */     for (Iterator iterator = methodInfos.iterator(); iterator.hasNext(); )
/*     */     {
/* 164 */       org.jboss.aop.MethodInfo methodInfo = (org.jboss.aop.MethodInfo)iterator.next();
/* 165 */       Method method = methodInfo.getMethod();
/* 166 */       AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
/* 167 */       Class[] parameterTypes = method.getParameterTypes();
/* 168 */       CtClass[] javassistParameterTypes = new CtClass[parameterTypes.length];
/* 169 */       for (int i = 0; i < parameterTypes.length; i++)
/*     */       {
/* 171 */         classPool.getLocally(parameterTypes[i].getName());
/*     */       }
/* 173 */       if (method.getName().indexOf("access$") >= 0)
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 178 */       String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
/* 179 */       CtMethod wmethod = clazz.getDeclaredMethod(method.getName(), javassistParameterTypes);
/* 180 */       if (wrapper.isNotPrepared(wmethod, 0))
/*     */       {
/*     */         continue;
/*     */       }
/* 184 */       MethodTransformation trans = new MethodTransformation(this.instrumentor, clazz, clazz.getDeclaredMethod(wrappedName, javassistParameterTypes), method.getName(), clazz.getDeclaredMethod(method.getName(), javassistParameterTypes), wrappedName);
/*     */ 
/* 193 */       wrapper.wrap(trans.getWMethod(), 0);
/*     */ 
/* 195 */       String methodInfoFieldName = getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
/* 196 */       doWrap(trans, methodInfoFieldName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unwrap(CtClass clazz, Collection methodInfos)
/*     */     throws Exception
/*     */   {
/* 209 */     for (Iterator iterator = methodInfos.iterator(); iterator.hasNext(); )
/*     */     {
/* 211 */       org.jboss.aop.MethodInfo methodInfo = (org.jboss.aop.MethodInfo)iterator.next();
/* 212 */       Method method = methodInfo.getMethod();
/* 213 */       AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
/* 214 */       Class[] parameterTypes = method.getParameterTypes();
/* 215 */       CtClass[] javassistParameterTypes = new CtClass[parameterTypes.length];
/* 216 */       for (int i = 0; i < parameterTypes.length; i++)
/*     */       {
/* 218 */         classPool.getLocally(parameterTypes[i].getName());
/*     */       }
/* 220 */       CtMethod javassistWMethod = clazz.getDeclaredMethod(method.getName(), javassistParameterTypes);
/* 221 */       if (wrapper.isNotPrepared(javassistWMethod, 0))
/*     */       {
/*     */         continue;
/*     */       }
/* 225 */       CtMethod javassistMethod = clazz.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName()), javassistParameterTypes);
/*     */ 
/* 228 */       wrapper.unwrap(javassistWMethod, 0);
/*     */ 
/* 230 */       javassistWMethod.setBody(javassistMethod, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void moveAnnotationsAndCopySignature(CtMethod src, CtMethod dest) throws NotFoundException
/*     */   {
/* 236 */     javassist.bytecode.MethodInfo mi = src.getMethodInfo2();
/* 237 */     javassist.bytecode.MethodInfo wmi = dest.getMethodInfo2();
/*     */ 
/* 239 */     moveAnnotations(mi, wmi, "RuntimeInvisibleAnnotations");
/* 240 */     moveAnnotations(mi, wmi, "RuntimeVisibleAnnotations");
/* 241 */     int numParams = src.getParameterTypes().length;
/* 242 */     moveParameterAnnotations(numParams, mi, wmi, "RuntimeVisibleParameterAnnotations");
/* 243 */     moveParameterAnnotations(numParams, mi, wmi, "RuntimeInvisibleParameterAnnotations");
/* 244 */     copySignature(mi, wmi);
/*     */   }
/*     */ 
/*     */   private void moveAnnotations(javassist.bytecode.MethodInfo src, javassist.bytecode.MethodInfo dest, String annotationTag)
/*     */   {
/* 249 */     AnnotationsAttribute attribute = (AnnotationsAttribute)src.getAttribute(annotationTag);
/* 250 */     if (attribute != null)
/*     */     {
/* 252 */       dest.addAttribute(attribute.copy(dest.getConstPool(), new HashMap()));
/* 253 */       src.addAttribute(new AnnotationsAttribute(src.getConstPool(), annotationTag));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void moveParameterAnnotations(int numParams, javassist.bytecode.MethodInfo src, javassist.bytecode.MethodInfo dest, String paramsTag)
/*     */   {
/* 259 */     ParameterAnnotationsAttribute params = (ParameterAnnotationsAttribute)src.getAttribute(paramsTag);
/* 260 */     if (params != null)
/*     */     {
/* 262 */       dest.addAttribute(params.copy(dest.getConstPool(), new HashMap()));
/* 263 */       ParameterAnnotationsAttribute srcParams = new ParameterAnnotationsAttribute(src.getConstPool(), paramsTag);
/* 264 */       Annotation[][] emptyParamAnnotations = new Annotation[numParams][];
/* 265 */       for (int i = 0; i < numParams; i++)
/*     */       {
/* 267 */         emptyParamAnnotations[i] = new Annotation[0];
/*     */       }
/* 269 */       srcParams.setAnnotations(emptyParamAnnotations);
/* 270 */       src.addAttribute(srcParams);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void copySignature(javassist.bytecode.MethodInfo src, javassist.bytecode.MethodInfo dest)
/*     */   {
/* 276 */     SignatureAttribute attribute = (SignatureAttribute)src.getAttribute("Signature");
/* 277 */     if (attribute != null)
/*     */     {
/* 279 */       dest.addAttribute(attribute.copy(dest.getConstPool(), new HashMap()));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static String getAopReturnStr(CtMethod method) throws NotFoundException
/*     */   {
/* 285 */     return getAopReturnStr(method.getReturnType().equals(CtClass.voidType));
/*     */   }
/*     */ 
/*     */   protected static String getAopReturnStr(boolean isVoid) throws NotFoundException
/*     */   {
/* 290 */     return isVoid ? "" : "return ($r)";
/*     */   }
/*     */ 
/*     */   protected static String getReturnStr(CtMethod method) throws NotFoundException
/*     */   {
/* 295 */     return getReturnStr(method.getReturnType().equals(CtClass.voidType));
/*     */   }
/*     */ 
/*     */   protected static String getReturnStr(boolean isVoid) throws NotFoundException
/*     */   {
/* 300 */     return isVoid ? "" : "return "; } 
/*     */   protected abstract void transformMethod(MethodTransformation paramMethodTransformation, boolean paramBoolean) throws CannotCompileException, NotFoundException;
/*     */ 
/*     */   protected abstract void doWrap(MethodTransformation paramMethodTransformation, String paramString) throws NotFoundException, Exception;
/*     */ 
/*     */   protected class MethodTransformation { Instrumentor instrumentor;
/*     */     CtClass clazz;
/*     */     CtMethod method;
/*     */     String originalName;
/*     */     CtMethod wmethod;
/*     */     String wrappedName;
/*     */     long hash;
/*     */ 
/* 318 */     public MethodTransformation(Instrumentor instrumentor, CtClass clazz, CtMethod method) { this.instrumentor = instrumentor;
/* 319 */       this.clazz = clazz;
/* 320 */       this.method = method;
/* 321 */       this.originalName = method.getName();
/* 322 */       this.hash = JavassistMethodHashing.methodHash(method);
/*     */     }
/*     */ 
/*     */     public MethodTransformation(Instrumentor instrumentor, CtClass clazz, CtMethod method, String originalName, CtMethod wmethod, String wrappedName)
/*     */     {
/* 332 */       this.instrumentor = instrumentor;
/* 333 */       this.clazz = clazz;
/* 334 */       this.method = method;
/* 335 */       this.originalName = originalName;
/* 336 */       this.wmethod = wmethod;
/* 337 */       this.wrappedName = wrappedName;
/* 338 */       this.hash = JavassistMethodHashing.methodHash(wmethod);
/*     */     }
/*     */ 
/*     */     public MethodTransformation(Instrumentor instrumentor, CtClass clazz, CtMethod method, String originalName, CtMethod wmethod, String wrappedName, long hash)
/*     */     {
/* 349 */       this.instrumentor = instrumentor;
/* 350 */       this.clazz = clazz;
/* 351 */       this.method = method;
/* 352 */       this.originalName = originalName;
/* 353 */       this.wmethod = wmethod;
/* 354 */       this.wrappedName = wrappedName;
/* 355 */       this.hash = hash;
/*     */     }
/*     */ 
/*     */     public void setWMethod(CtMethod wmethod, String wrappedName)
/*     */     {
/* 361 */       this.wmethod = wmethod;
/* 362 */       this.wrappedName = wrappedName;
/*     */     }
/*     */ 
/*     */     public void setWMethodBody(String code) throws CannotCompileException
/*     */     {
/* 367 */       this.wmethod.setBody(code);
/*     */     }
/*     */ 
/*     */     public String getOriginalName()
/*     */     {
/* 372 */       return this.originalName;
/*     */     }
/*     */ 
/*     */     public String getWrappedName()
/*     */     {
/* 377 */       return this.wrappedName;
/*     */     }
/*     */ 
/*     */     public CtClass getClazz()
/*     */     {
/* 382 */       return this.clazz;
/*     */     }
/*     */ 
/*     */     public String getClazzName()
/*     */     {
/* 387 */       return this.clazz.getName();
/*     */     }
/*     */ 
/*     */     public CtMethod getMethod()
/*     */     {
/* 392 */       return this.method;
/*     */     }
/*     */ 
/*     */     public CtMethod getWMethod()
/*     */     {
/* 397 */       return this.wmethod;
/*     */     }
/*     */ 
/*     */     public long getHash()
/*     */     {
/* 402 */       return this.hash;
/*     */     }
/*     */ 
/*     */     public Instrumentor getInstrumentor()
/*     */     {
/* 407 */       return this.instrumentor;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.MethodExecutionTransformer
 * JD-Core Version:    0.6.0
 */