/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodByConInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.joinpoint.MethodCallByConstructor;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class MethodByConJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*     */   public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_MByC_";
/*     */   public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_MByC_";
/*  50 */   private static final Class INVOCATION_TYPE = MethodCalledByConstructorInvocation.class;
/*  51 */   private static final Class JOINPOINT_TYPE = MethodCallByConstructor.class;
/*     */   private static final CtClass INVOCATION_CT_TYPE;
/*     */   boolean hasTargetObject;
/*     */   WeakReference<Class<?>> returnType;
/*     */ 
/*     */   public MethodByConJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info)
/*     */   {
/*  71 */     super(advisor, info, getParameters((MethodByConInfo)info), ((MethodByConInfo)info).getMethod().getParameterTypes().length, false);
/*     */ 
/*  73 */     if (!((MethodByConInfo)info).getMethod().getReturnType().equals(Void.TYPE))
/*     */     {
/*  75 */       this.returnType = new WeakReference(((MethodByConInfo)info).getMethod().getReturnType());
/*     */     }
/*  77 */     this.hasTargetObject = (!java.lang.reflect.Modifier.isStatic(((MethodByConInfo)info).getMethod().getModifiers()));
/*     */   }
/*     */ 
/*     */   private static JoinPointGenerator.JoinPointParameters getParameters(MethodByConInfo info)
/*     */   {
/*  82 */     if (javassist.Modifier.isStatic(info.getMethod().getModifiers()))
/*     */     {
/*  84 */       return JoinPointGenerator.JoinPointParameters.CALLER_ARGS;
/*     */     }
/*  86 */     return JoinPointGenerator.JoinPointParameters.TARGET_CALLER_ARGS;
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/*  91 */     MethodByConInfo minfo = (MethodByConInfo)info;
/*  92 */     this.joinpointClassName = getGeneratedJoinPointClassName(callingIndex(minfo), calledClass(minfo), calledMethodHash(minfo));
/*     */ 
/*  97 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(callingIndex(minfo), calledClass(minfo), calledMethodHash(minfo));
/*     */   }
/*     */ 
/*     */   private int callingIndex(MethodByConInfo info)
/*     */   {
/* 105 */     return info.getCallingIndex();
/*     */   }
/*     */ 
/*     */   private String calledClass(MethodByConInfo info)
/*     */   {
/* 110 */     return info.getCalledClass().getName();
/*     */   }
/*     */ 
/*     */   private long calledMethodHash(MethodByConInfo info)
/*     */   {
/* 115 */     return info.getCalledMethodHash();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 121 */     return getReturnClassType() == null;
/*     */   }
/*     */ 
/*     */   protected Class getReturnClassType()
/*     */   {
/* 126 */     if (this.returnType == null)
/*     */     {
/* 128 */       return null;
/*     */     }
/* 130 */     return (Class)this.returnType.get();
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 135 */     Method method = ((MethodCallByConstructor)joinPoint).getMethod();
/* 136 */     return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, method.getGenericReturnType(), method.getGenericParameterTypes(), method.getParameterTypes(), method.getGenericExceptionTypes(), method.getDeclaringClass(), hasTargetObject(), ((MethodCallByConstructor)joinPoint).getCallingClass(), hasCallingObject());
/*     */   }
/*     */ 
/*     */   protected boolean isCaller()
/*     */   {
/* 154 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean hasCallingObject()
/*     */   {
/* 159 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 164 */     return this.hasTargetObject;
/*     */   }
/*     */ 
/*     */   protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, int callingIndex, CtClass callingClass, CtMethod targetMethod, String classname, long calledHash, String ciname)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 176 */     BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingIndex, classname, targetMethod, calledHash, ciname);
/* 177 */     return generator.generate();
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointClassName(int callingIndex, String classname, long calledHash)
/*     */   {
/* 182 */     return "JoinPoint_MByC_" + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(int callingIndex, String classname, long calledHash)
/*     */   {
/* 187 */     return "joinpoint_MByC_" + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  58 */       INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  62 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass callingClass;
/*     */     int callingIndex;
/*     */     CtField callingField;
/*     */     CtClass targetClass;
/*     */     String classname;
/*     */     CtMethod targetMethod;
/*     */     long calledHash;
/*     */     String ciname;
/*     */     boolean hasTargetObject;
/*     */     CtClass jp;
/*     */     CtClass[] params;
/*     */     CtClass methodInfoClass;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, int callingIndex, String classname, CtMethod targetMethod, long calledHash, String ciname)
/*     */       throws NotFoundException
/*     */     {
/* 216 */       this.instrumentor = instrumentor;
/* 217 */       this.callingClass = callingClass;
/* 218 */       this.callingIndex = callingIndex;
/* 219 */       this.classname = classname;
/* 220 */       this.targetClass = instrumentor.forName(classname);
/* 221 */       this.targetMethod = targetMethod;
/* 222 */       this.calledHash = calledHash;
/* 223 */       this.ciname = ciname;
/* 224 */       this.params = targetMethod.getParameterTypes();
/* 225 */       this.methodInfoClass = instrumentor.forName(CallerTransformer.METHOD_BY_CON_INFO_CLASS_NAME);
/* 226 */       this.hasTargetObject = (!javassist.Modifier.isStatic(targetMethod.getModifiers()));
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 231 */       this.jp = setupClass();
/* 232 */       OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
/*     */ 
/* 234 */       if (this.hasTargetObject)
/*     */       {
/* 236 */         addTypedTargetField();
/*     */       }
/* 238 */       addTypedCallingField();
/* 239 */       addInvokeJoinpointMethod();
/* 240 */       addMethodInfoField();
/* 241 */       addPublicConstructor();
/* 242 */       addProtectedConstructors();
/* 243 */       addDispatchMethods();
/*     */ 
/* 245 */       TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
/* 246 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 252 */       String className = MethodByConJoinPointGenerator.getGeneratedJoinPointClassName(this.callingIndex, this.targetClass.getName(), this.calledHash);
/*     */ 
/* 255 */       this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true);
/* 256 */       int mod = this.jp.getModifiers();
/* 257 */       this.jp.setModifiers(mod | 0x1);
/*     */ 
/* 259 */       CtClass invocation = MethodByConJoinPointGenerator.INVOCATION_CT_TYPE;
/* 260 */       this.jp.setSuperclass(invocation);
/* 261 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/* 262 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private void addTypedTargetField() throws CannotCompileException
/*     */     {
/* 267 */       CtField targetField = new CtField(this.targetClass, "typedTargetObject", this.jp);
/* 268 */       this.jp.addField(targetField);
/* 269 */       targetField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addTypedCallingField() throws CannotCompileException
/*     */     {
/* 274 */       this.callingField = new CtField(this.callingClass, "typedCallingObject", this.jp);
/* 275 */       this.jp.addField(this.callingField);
/* 276 */       this.callingField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 286 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.methodInfoClass }, new CtClass[0], "{super($1, null, null, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 292 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException
/*     */     {
/* 301 */       int offset = this.hasTargetObject ? 3 : 2;
/* 302 */       CtClass[] ctorParams1 = new CtClass[this.params.length + offset];
/* 303 */       CtClass[] ctorParams2 = new CtClass[offset];
/*     */       CtClass tmp37_34 = this.jp; ctorParams2[0] = tmp37_34; ctorParams1[0] = tmp37_34;
/* 305 */       if (this.hasTargetObject)
/*     */       {
/*     */         CtClass tmp55_52 = this.targetClass; ctorParams2[1] = tmp55_52; ctorParams1[1] = tmp55_52;
/*     */         CtClass tmp66_63 = this.callingClass; ctorParams2[2] = tmp66_63; ctorParams1[2] = tmp66_63;
/*     */       }
/*     */       else
/*     */       {
/*     */         CtClass tmp80_77 = this.callingClass; ctorParams2[1] = tmp80_77; ctorParams1[1] = tmp80_77;
/*     */       }
/* 314 */       System.arraycopy(this.params, 0, ctorParams1, offset, this.params.length);
/*     */ 
/* 316 */       StringBuffer body = new StringBuffer();
/* 317 */       body.append("{");
/* 318 */       body.append("   this($1.info);");
/*     */ 
/* 321 */       if (this.hasTargetObject)
/*     */       {
/* 323 */         body.append("   super.").append("targetObject").append("=$2;");
/* 324 */         body.append("   this.").append("typedTargetObject").append("=$2;");
/* 325 */         body.append("   super.").append("callingObject").append("=$3;");
/* 326 */         body.append("   this.").append(this.callingField.getName()).append("=$3;");
/*     */       }
/*     */       else
/*     */       {
/* 330 */         body.append("   super.").append("callingObject").append("=$2;");
/* 331 */         body.append("   this.").append(this.callingField.getName()).append("=$2;");
/*     */       }
/*     */ 
/* 334 */       StringBuffer setArguments = new StringBuffer();
/* 335 */       for (int i = offset; i < ctorParams1.length; i++)
/*     */       {
/* 337 */         setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
/*     */       }
/* 339 */       setArguments.append("}");
/*     */ 
/* 342 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
/*     */ 
/* 347 */       protectedConstructor.setModifiers(4);
/* 348 */       this.jp.addConstructor(protectedConstructor);
/* 349 */       if (this.params.length > 0)
/*     */       {
/* 351 */         protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 356 */         protectedConstructor.setModifiers(4);
/* 357 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */     }
/*     */ 
/*     */     private CtClass[] getInvokeJoinPointParameters()
/*     */     {
/* 364 */       if (this.hasTargetObject)
/*     */       {
/* 366 */         CtClass[] invokeParams = new CtClass[this.params.length + 2];
/* 367 */         invokeParams[0] = this.targetClass;
/* 368 */         invokeParams[1] = this.callingClass;
/* 369 */         System.arraycopy(this.params, 0, invokeParams, 2, this.params.length);
/* 370 */         return invokeParams;
/*     */       }
/* 372 */       CtClass[] invokeParams = new CtClass[this.params.length + 1];
/* 373 */       invokeParams[0] = this.callingClass;
/* 374 */       System.arraycopy(this.params, 0, invokeParams, 1, this.params.length);
/* 375 */       return invokeParams;
/*     */     }
/*     */ 
/*     */     private CtMethod addInvokeJoinpointMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 384 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(this.targetMethod.getReturnType(), "invokeJoinpoint", getInvokeJoinPointParameters(), JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 391 */       invokeJoinpointMethod.setModifiers(4);
/* 392 */       this.jp.addMethod(invokeJoinpointMethod);
/* 393 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     private void addMethodInfoField() throws CannotCompileException
/*     */     {
/* 398 */       CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
/* 399 */       infoField.setModifiers(4);
/* 400 */       this.jp.addField(infoField);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 405 */       OptimizedMethodInvocations.addDispatch(this.jp, "dispatch", this.targetMethod, !this.hasTargetObject);
/*     */ 
/* 407 */       addInvokeJoinPointDispatchMethod();
/* 408 */       addInvokeTargetMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeJoinPointDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 414 */       boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
/*     */ 
/* 416 */       int offset = this.hasTargetObject ? 2 : 1;
/* 417 */       StringBuffer parameters = new StringBuffer();
/* 418 */       for (int i = 0; i < this.params.length; i++)
/*     */       {
/* 420 */         if (i > 0) parameters.append(", ");
/* 421 */         parameters.append("$" + (i + offset + 1));
/*     */       }
/*     */ 
/* 424 */       StringBuffer body = new StringBuffer("{");
/*     */ 
/* 426 */       if (javassist.Modifier.isStatic(this.targetMethod.getModifiers()))
/*     */       {
/* 428 */         body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
/*     */       }
/*     */       else
/*     */       {
/* 432 */         body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "$1." + this.targetMethod.getName() + "(" + parameters + ");");
/*     */       }
/*     */ 
/* 435 */       body.append("}");
/*     */       try
/*     */       {
/* 438 */         CtMethod dispatch = CtNewMethod.make(isVoid ? CtClass.voidType : this.targetMethod.getReturnType(), "dispatch", getInvokeJoinPointParameters(), this.targetMethod.getExceptionTypes(), body.toString(), this.jp);
/*     */ 
/* 445 */         dispatch.setModifiers(4);
/* 446 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 450 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", getInvokeJoinPointParameters()), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 456 */       CtMethod template = MethodByConJoinPointGenerator.INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
/*     */ 
/* 458 */       boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
/* 459 */       String body = isVoid ? "{dispatch(); return null;}" : "{return ($w)dispatch();}";
/*     */ 
/* 461 */       CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
/*     */ 
/* 468 */       this.jp.addMethod(invokeTarget);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.MethodByConJoinPointGenerator
 * JD-Core Version:    0.6.0
 */