/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMember;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ 
/*     */ public abstract class JoinpointClassifier
/*     */ {
/*  73 */   private Matcher fieldGetMatcher = new Matcher()
/*     */   {
/*     */     public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException
/*     */     {
/*  77 */       return pointcut.matchesGet(advisor, (CtField)member);
/*     */     }
/*  73 */   };
/*     */ 
/*  84 */   private Matcher fieldSetMatcher = new Matcher()
/*     */   {
/*     */     public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException
/*     */     {
/*  88 */       return pointcut.matchesSet(advisor, (CtField)member);
/*     */     }
/*  84 */   };
/*     */ 
/*  95 */   private Matcher constructorMatcher = new Matcher()
/*     */   {
/*     */     public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException
/*     */     {
/*  99 */       return pointcut.matchesExecution(advisor, (CtConstructor)member);
/*     */     }
/*  95 */   };
/*     */ 
/* 106 */   private Matcher methodMatcher = new Matcher()
/*     */   {
/*     */     public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException
/*     */     {
/* 110 */       return pointcut.matchesExecution(advisor, (CtMethod)member);
/*     */     }
/* 106 */   };
/*     */ 
/*     */   protected abstract JoinpointClassification classifyJoinpoint(CtMember paramCtMember, Advisor paramAdvisor, Matcher paramMatcher)
/*     */     throws NotFoundException;
/*     */ 
/*     */   public JoinpointClassification classifyFieldGet(CtField field, Advisor advisor)
/*     */     throws NotFoundException
/*     */   {
/* 136 */     return classifyJoinpoint(field, advisor, this.fieldGetMatcher);
/*     */   }
/*     */ 
/*     */   public JoinpointClassification classifyFieldSet(CtField field, Advisor advisor)
/*     */     throws NotFoundException
/*     */   {
/* 148 */     return classifyJoinpoint(field, advisor, this.fieldSetMatcher);
/*     */   }
/*     */ 
/*     */   public JoinpointClassification classifyConstructorExecution(CtConstructor cons, Advisor advisor)
/*     */     throws NotFoundException
/*     */   {
/* 160 */     return classifyJoinpoint(cons, advisor, this.constructorMatcher);
/*     */   }
/*     */ 
/*     */   public JoinpointClassification classifyMethodExecution(CtMethod method, Advisor advisor)
/*     */     throws NotFoundException
/*     */   {
/* 172 */     return classifyJoinpoint(method, advisor, this.methodMatcher);
/*     */   }
/*     */ 
/*     */   protected static abstract interface Matcher
/*     */   {
/*     */     public abstract boolean matches(Pointcut paramPointcut, Advisor paramAdvisor, CtMember paramCtMember)
/*     */       throws NotFoundException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.JoinpointClassifier
 * JD-Core Version:    0.6.0
 */