/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class InstrumentorFactory
/*     */ {
/*  39 */   private static final Logger logger = AOPLogger.getLogger(InstrumentorFactory.class);
/*     */   protected static InstrumentorEnum instrumentor;
/*     */   protected static Constructor otherInstrumentorConstructor;
/*  45 */   private static final Class[] CONSTRUCTOR_SIG = { AOPClassPool.class, AspectManager.class, JoinpointClassifier.class, DynamicTransformationObserver.class };
/*     */ 
/*     */   public static void initialise(String property)
/*     */   {
/*  49 */     if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */     {
/*  51 */       logger.debug("Passed in instrumentor: " + property);
/*     */     }
/*     */ 
/*  54 */     if (property != null)
/*     */     {
/*  56 */       if (property.equals(ClassicInstrumentor.class.getName()))
/*     */       {
/*  58 */         instrumentor = InstrumentorEnum.CLASSIC;
/*     */       }
/*  60 */       else if (property.equals(GeneratedAdvisorInstrumentor.class.getName()))
/*     */       {
/*  62 */         instrumentor = InstrumentorEnum.GENERATED_ADVISOR;
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/*  70 */           Class otherInstrumentorClass = SecurityActions.getContextClassLoader().loadClass(property);
/*  71 */           otherInstrumentorConstructor = otherInstrumentorClass.getConstructor(CONSTRUCTOR_SIG);
/*  72 */           instrumentor = InstrumentorEnum.OTHER_INSTRUMENTOR;
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/*  76 */           throw new RuntimeException("Invalid instrumentor " + property + " was used");
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/*  80 */           throw new RuntimeException(property + " does not have a constructor with the expected signature");
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  86 */       instrumentor = InstrumentorEnum.GENERATED_ADVISOR;
/*  87 */       if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */       {
/*  89 */         logger.debug("Defaulting instrumentor to: " + getInstrumentorName());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static InstrumentorEnum getInstrumentor()
/*     */   {
/*  96 */     return instrumentor;
/*     */   }
/*     */ 
/*     */   public static Instrumentor getInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer)
/*     */   {
/* 101 */     if (instrumentor == InstrumentorEnum.CLASSIC)
/*     */     {
/* 103 */       return new ClassicInstrumentor(pool, manager, joinpointClassifier, observer);
/*     */     }
/* 105 */     if (instrumentor == InstrumentorEnum.GENERATED_ADVISOR)
/*     */     {
/* 107 */       return new GeneratedAdvisorInstrumentor(pool, manager, joinpointClassifier, observer);
/*     */     }
/* 109 */     if (otherInstrumentorConstructor != null)
/*     */     {
/*     */       try
/*     */       {
/* 113 */         return (Instrumentor)otherInstrumentorConstructor.newInstance(new Object[] { pool, manager, joinpointClassifier, observer });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 117 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 122 */     throw new RuntimeException("Instrumentor is not set");
/*     */   }
/*     */ 
/*     */   public static Instrumentor getInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier)
/*     */   {
/* 129 */     if (instrumentor == InstrumentorEnum.CLASSIC)
/*     */     {
/* 131 */       return new ClassicInstrumentor(manager, joinpointClassifier);
/*     */     }
/* 133 */     if (instrumentor == InstrumentorEnum.GENERATED_ADVISOR)
/*     */     {
/* 135 */       return new GeneratedAdvisorInstrumentor(manager, joinpointClassifier);
/*     */     }
/*     */ 
/* 139 */     throw new RuntimeException("Instrumentor is not set");
/*     */   }
/*     */ 
/*     */   public static String getInstrumentorName()
/*     */   {
/* 145 */     if (instrumentor == InstrumentorEnum.CLASSIC)
/*     */     {
/* 147 */       return ClassicInstrumentor.class.getName();
/*     */     }
/* 149 */     if (instrumentor == InstrumentorEnum.GENERATED_ADVISOR)
/*     */     {
/* 151 */       return GeneratedAdvisorInstrumentor.class.getName();
/*     */     }
/* 153 */     if (instrumentor == InstrumentorEnum.OTHER_INSTRUMENTOR)
/*     */     {
/* 155 */       return otherInstrumentorConstructor.getName();
/*     */     }
/*     */ 
/* 159 */     throw new RuntimeException("Instrumentor is not set");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.InstrumentorFactory
 * JD-Core Version:    0.6.0
 */