/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ 
/*     */ public class GeneratedAdvisorMethodExecutionTransformer extends MethodExecutionTransformer
/*     */ {
/*     */   public GeneratedAdvisorMethodExecutionTransformer(GeneratedAdvisorInstrumentor instrumentor)
/*     */   {
/*  46 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   private String addMethodInfoFieldToGenAdvisor(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException, CannotCompileException
/*     */   {
/*  51 */     GeneratedAdvisorInstrumentor instrumentor = (GeneratedAdvisorInstrumentor)trans.getInstrumentor();
/*  52 */     CtClass genadvisor = instrumentor.getGenadvisor();
/*  53 */     String miname = addMethodInfoField(4, genadvisor, trans);
/*     */ 
/*  58 */     addJoinpoint(miname, trans);
/*     */ 
/*  60 */     instrumentor.initaliseMethodInfo(miname, trans.getHash(), JavassistMethodHashing.methodHash(trans.getMethod()));
/*  61 */     return miname;
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/*  66 */     return false;
/*     */   }
/*     */ 
/*     */   public static String getJoinPointFieldName(MethodExecutionTransformer.MethodTransformation trans)
/*     */   {
/*  71 */     return MethodJoinPointGenerator.getGeneratedJoinPointFieldName(trans.getOriginalName(), trans.getHash());
/*     */   }
/*     */ 
/*     */   private void addJoinpoint(String miname, MethodExecutionTransformer.MethodTransformation trans) throws CannotCompileException, NotFoundException
/*     */   {
/*  76 */     CtClass joinpoint = createJoinpointClass(miname, trans);
/*  77 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)trans.getInstrumentor()).getGenadvisor();
/*  78 */     CtField field = new CtField(joinpoint, getJoinPointFieldName(trans), genadvisor);
/*     */ 
/*  82 */     field.setModifiers(4);
/*  83 */     genadvisor.addField(field);
/*     */   }
/*     */ 
/*     */   private CtClass createJoinpointClass(String miname, MethodExecutionTransformer.MethodTransformation trans) throws CannotCompileException, NotFoundException
/*     */   {
/*  88 */     return MethodJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)trans.getInstrumentor(), trans.getClazz(), trans.getMethod(), trans.getWMethod(), miname, trans.getOriginalName(), trans.getWrappedName(), trans.getHash());
/*     */   }
/*     */ 
/*     */   public CtMethod addMixinWrappersAndInfo(GeneratedAdvisorInstrumentor instrumentor, CtClass clazz, CtClass mixinClass, String initializer, CtClass genadvisor, CtMethod mixinMethod)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 107 */     String originalName = mixinMethod.getName();
/* 108 */     String originalBody = "{   " + getReturnStr(mixinMethod) + " " + Instrumentor.mixinFieldName(mixinClass) + "." + mixinMethod.getName() + "($$);" + "}";
/*     */ 
/* 113 */     CtMethod original = CtNewMethod.make(1, mixinMethod.getReturnType(), mixinMethod.getName(), mixinMethod.getParameterTypes(), mixinMethod.getExceptionTypes(), originalBody, clazz);
/*     */ 
/* 121 */     clazz.addMethod(original);
/* 122 */     long hash = JavassistMethodHashing.methodHash(original);
/* 123 */     moveAnnotationsAndCopySignature(mixinMethod, original);
/*     */ 
/* 125 */     String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), originalName);
/* 126 */     CtMethod wmethod = CtNewMethod.copy(original, clazz, null);
/*     */ 
/* 128 */     wmethod.setName(wrappedName);
/* 129 */     clazz.addMethod(wmethod);
/* 130 */     moveAnnotationsAndCopySignature(original, wmethod);
/*     */ 
/* 132 */     original.setName(wrappedName);
/* 133 */     wmethod.setName(originalName);
/*     */ 
/* 135 */     MethodExecutionTransformer.MethodTransformation trans = new MethodExecutionTransformer.MethodTransformation(this, instrumentor, clazz, original, originalName, wmethod, wrappedName, hash);
/*     */ 
/* 137 */     String methodInfoField = addMethodInfoFieldToGenAdvisor(trans);
/* 138 */     addMethodToGeneratedAdvisor(trans, methodInfoField);
/*     */ 
/* 140 */     String wrapperBody = "{   if (" + Instrumentor.mixinFieldName(mixinClass) + " == null)" + "   {" + "      " + Instrumentor.mixinFieldName(mixinClass) + " = " + initializer + ";" + "   }" + "   " + getReturnStr(trans.getMethod()) + " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz()) + ")" + "getCurrentAdvisor$aop()" + ")." + getAdvisorMethodName(trans) + "(this,$$);" + "}";
/*     */ 
/* 148 */     wmethod.setBody(wrapperBody);
/* 149 */     return wmethod;
/*     */   }
/*     */ 
/*     */   protected void transformMethod(MethodExecutionTransformer.MethodTransformation trans, boolean wrap)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 156 */     String wrappedName = ClassAdvisor.notAdvisedMethodName(trans.getClazzName(), trans.getMethod().getName());
/*     */ 
/* 158 */     CtMethod wmethod = CtNewMethod.copy(trans.getMethod(), trans.getClazz(), null);
/*     */ 
/* 160 */     String originalName = trans.getOriginalName();
/* 161 */     wmethod.setName(wrappedName);
/* 162 */     trans.getClazz().addMethod(wmethod);
/* 163 */     moveAnnotationsAndCopySignature(trans.getMethod(), wmethod);
/* 164 */     trans.getMethod().setName(wrappedName);
/* 165 */     wmethod.setName(originalName);
/*     */ 
/* 167 */     trans.setWMethod(wmethod, wrappedName);
/*     */ 
/* 169 */     String methodInfoField = addMethodInfoFieldToGenAdvisor(trans);
/* 170 */     addMethodToGeneratedAdvisor(trans, methodInfoField);
/*     */ 
/* 173 */     getWrapper().prepareForWrapping(wmethod, 0);
/*     */ 
/* 176 */     if (wrap)
/*     */     {
/* 179 */       getWrapper().wrap(wmethod, 0);
/*     */ 
/* 182 */       setWrapperBody(trans, methodInfoField);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void doWrap(MethodExecutionTransformer.MethodTransformation trans, String methodInfoFieldName)
/*     */     throws NotFoundException, Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   private void setWrapperBody(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField)
/*     */     throws NotFoundException
/*     */   {
/* 195 */     String code = null;
/* 196 */     String className = GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz());
/*     */     try
/*     */     {
/* 201 */       if (Modifier.isStatic(trans.getMethod().getModifiers()))
/*     */       {
/* 203 */         code = "{   " + getReturnStr(trans.getMethod()) + " ((" + className + ")" + "aop$classAdvisor$aop" + ")." + getAdvisorMethodName(trans) + "($$);" + "}";
/*     */ 
/* 207 */         trans.setWMethodBody(code);
/*     */       }
/*     */       else
/*     */       {
/* 211 */         code = "{   " + getReturnStr(trans.getMethod()) + " ((" + className + ")" + "getCurrentAdvisor$aop()" + ")." + getAdvisorMethodName(trans) + "(this,$$);" + "}";
/*     */ 
/* 216 */         trans.setWMethodBody(code);
/*     */       }
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 221 */       e.printStackTrace();
/* 222 */       throw new RuntimeException("code was: " + code + " for method " + trans.getOriginalName());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static CtClass[] addTargetToParamsForNonStaticMethod(CtClass outer, CtMethod method) throws NotFoundException
/*     */   {
/* 228 */     CtClass[] params = method.getParameterTypes();
/*     */ 
/* 230 */     if (!Modifier.isStatic(method.getModifiers()))
/*     */     {
/* 232 */       CtClass[] tempParams = params;
/* 233 */       params = new CtClass[params.length + 1];
/* 234 */       params[0] = outer;
/* 235 */       System.arraycopy(tempParams, 0, params, 1, tempParams.length);
/*     */     }
/*     */ 
/* 238 */     return params;
/*     */   }
/*     */ 
/*     */   private String getAdvisorMethodName(MethodExecutionTransformer.MethodTransformation trans)
/*     */   {
/* 249 */     if (trans.getHash() >= 0L)
/*     */     {
/* 251 */       return trans.getOriginalName() + trans.getHash();
/*     */     }
/*     */ 
/* 255 */     return trans.getOriginalName() + "_N_" + Math.abs(trans.getHash());
/*     */   }
/*     */ 
/*     */   private void addMethodToGeneratedAdvisor(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 261 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)trans.getInstrumentor()).getGenadvisor();
/*     */ 
/* 263 */     CtClass[] params = addTargetToParamsForNonStaticMethod(trans.getClazz(), trans.getWMethod());
/*     */ 
/* 265 */     String code = createAdvisorMethodBody(trans);
/*     */     try
/*     */     {
/* 268 */       CtMethod advisorMethod = CtNewMethod.make(4, trans.getWMethod().getReturnType(), getAdvisorMethodName(trans), params, trans.getWMethod().getExceptionTypes(), code, genadvisor);
/*     */ 
/* 277 */       genadvisor.addMethod(advisorMethod);
/* 278 */       advisorMethod.setModifiers(Modifier.setProtected(advisorMethod.getModifiers()));
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 282 */       throw new RuntimeException("code was: " + code + " for method " + getAdvisorMethodName(trans), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String createAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException
/*     */   {
/* 288 */     if (Modifier.isStatic(trans.getWMethod().getModifiers()))
/*     */     {
/* 290 */       return createStaticAdvisorMethodBody(trans);
/*     */     }
/*     */ 
/* 294 */     return createNonStaticAdvisorMethodBody(trans);
/*     */   }
/*     */ 
/*     */   private String createStaticAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans)
/*     */     throws NotFoundException
/*     */   {
/* 300 */     String joinpointName = getJoinPointFieldName(trans);
/* 301 */     String infoName = getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
/*     */ 
/* 303 */     String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "       super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      " + getReturnStr(trans.getWMethod()) + trans.getClazzName() + "." + trans.getWrappedName() + "($$);" + "   }" + "   else" + "   {" + "    " + getAopReturnStr(trans.getWMethod()) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */ 
/* 319 */     return code;
/*     */   }
/*     */ 
/*     */   private String createNonStaticAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException
/*     */   {
/* 324 */     String joinpointName = getJoinPointFieldName(trans);
/* 325 */     String infoName = getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
/*     */ 
/* 327 */     String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "       super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      " + getAopReturnStr(trans.getWMethod()) + "$1." + trans.getWrappedName() + "(" + getNonStaticJavasistParamString(trans.getWMethod().getParameterTypes().length) + ");" + "   }" + "   else" + "   {" + "    " + getAopReturnStr(trans.getWMethod()) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */ 
/* 343 */     return code;
/*     */   }
/*     */ 
/*     */   public static String getNonStaticJavasistParamString(long parameterLength) throws NotFoundException
/*     */   {
/* 348 */     StringBuffer str = new StringBuffer();
/*     */ 
/* 350 */     for (int i = 0; i < parameterLength; i++)
/*     */     {
/* 352 */       if (i > 0)
/*     */       {
/* 354 */         str.append(", ");
/*     */       }
/* 356 */       str.append("$" + (i + 2));
/*     */     }
/*     */ 
/* 359 */     return str.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.GeneratedAdvisorMethodExecutionTransformer
 * JD-Core Version:    0.6.0
 */