/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ 
/*     */ public class GeneratedAdvisorConstructionTransformer extends ConstructionTransformer
/*     */ {
/*     */   public GeneratedAdvisorConstructionTransformer(Instrumentor instrumentor)
/*     */   {
/*  47 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected void generateConstructionInfoField(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException
/*     */   {
/*  52 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
/*  53 */     String ciname = addConstructionInfoField(4, genadvisor, constructor, index);
/*     */ 
/*  59 */     addJoinpoint(constructor, ciname, index);
/*     */ 
/*  61 */     long constructorHash = JavassistMethodHashing.constructorHash(constructor);
/*  62 */     ((GeneratedAdvisorInstrumentor)this.instrumentor).initialiseConstructionInfoField(ciname, index, constructorHash);
/*     */   }
/*     */ 
/*     */   private void addJoinpoint(CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException
/*     */   {
/*  67 */     CtClass clazz = constructor.getDeclaringClass();
/*  68 */     CtClass joinpoint = createJoinpointClass(clazz, constructor, ciname, index);
/*  69 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
/*  70 */     CtField field = new CtField(joinpoint, ConstructionJoinPointGenerator.getGeneratedJoinPointFieldName(clazz.getSimpleName(), index), genadvisor);
/*     */ 
/*  74 */     field.setModifiers(4);
/*  75 */     genadvisor.addField(field);
/*     */   }
/*     */ 
/*     */   private CtClass createJoinpointClass(CtClass clazz, CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException
/*     */   {
/*  80 */     return ConstructionJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.instrumentor, clazz, constructor, ciname, index);
/*     */   }
/*     */ 
/*     */   protected void generateNotMatchedConstructionInfoField(CtConstructor constructor, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  91 */     generateConstructionInfoField(constructor, index);
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/*  96 */     return false;
/*     */   }
/*     */ 
/*     */   public static String constructionFactory(String className)
/*     */   {
/* 101 */     if (className.indexOf('.') >= 0) throw new RuntimeException("constructorFactory() takes a simple class name:" + className);
/* 102 */     return className + "_construction_" + "$aop";
/*     */   }
/*     */ 
/*     */   protected void insertInterception(CtConstructor constructor, int index) throws Exception
/*     */   {
/* 107 */     String constructionWrapperName = constructor.getDeclaringClass().getSimpleName() + "_con_" + "$aop";
/*     */ 
/* 109 */     String body = createInterceptingWrapperBody(constructor, index);
/* 110 */     CtMethod wrapper = createWrapperMethod(constructor, constructionWrapperName, body);
/* 111 */     insertWrapperCallInCtor(constructor, constructionWrapperName);
/*     */   }
/*     */ 
/*     */   private CtMethod createWrapperMethod(CtConstructor constructor, String wrapperName, String body)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 117 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
/* 118 */     CtClass[] params = constructor.getParameterTypes();
/* 119 */     CtClass[] wrapperParams = new CtClass[params.length + 1];
/* 120 */     wrapperParams[0] = constructor.getDeclaringClass();
/* 121 */     System.arraycopy(params, 0, wrapperParams, 1, params.length);
/*     */ 
/* 123 */     CtMethod wrapper = CtNewMethod.make(CtClass.voidType, wrapperName, wrapperParams, constructor.getExceptionTypes(), body, genadvisor);
/*     */ 
/* 130 */     genadvisor.addMethod(wrapper);
/* 131 */     return wrapper;
/*     */   }
/*     */ 
/*     */   private void insertWrapperCallInCtor(CtConstructor constructor, String wrapperName) throws NotFoundException, CannotCompileException
/*     */   {
/* 136 */     String wrapperCall = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(constructor.getDeclaringClass()) + ")" + "getCurrentAdvisor$aop()" + ")." + wrapperName + "(this" + (constructor.getParameterTypes().length == 0 ? "" : ", $$") + ");";
/*     */ 
/* 139 */     constructor.insertAfter(wrapperCall, false);
/*     */   }
/*     */ 
/*     */   private String createInterceptingWrapperBody(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException
/*     */   {
/* 144 */     String joinpointName = ConstructionJoinPointGenerator.getGeneratedJoinPointFieldName(constructor.getDeclaringClass().getSimpleName(), index);
/* 145 */     String infoName = getConstructionInfoFieldName(constructor.getDeclaringClass().getSimpleName(), index);
/* 146 */     String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " != null)" + "   { " + "    " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */ 
/* 158 */     return code;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.GeneratedAdvisorConstructionTransformer
 * JD-Core Version:    0.6.0
 */